/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.fi.dhc.helper.BillPrintServiceHelper;
import kd.fi.dhc.mircoservice.pojo.dto.mybillprint.PrintSettingInfo;
import kd.fi.dhc.mircoservice.pojo.dto.mybillprint.PrintTplInfo;

public class MyBillPrintSelectTemplatePlugin
extends AbstractFormPlugin {
    private static final String TEMPLATE_CACHE_KEY = "TEMPLATE_CACHE_KEY_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnconfilm"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        String formId = (String)view.getFormShowParameter().getCustomParam("formId");
        String text = (String)view.getFormShowParameter().getCustomParam("text");
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a", (String)"MyBillPrintSelectTemplatePlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        } else {
            Label label = (Label)this.getControl("labelap");
            label.setText(text);
            Map cacheTemplates = BillPrintServiceHelper.getCacheTemplates((IFormView)view, (String)TEMPLATE_CACHE_KEY, (String)formId);
            BillPrintServiceHelper.initDefaultCombo((IFormView)view, (String)"selecttemplate", (Map)cacheTemplates);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String formId = (String)view.getFormShowParameter().getCustomParam("formId");
        long billId = (Long)view.getFormShowParameter().getCustomParam("billId");
        if ("btnconfilm".equals(btn.getKey())) {
            Boolean newTpl;
            String tplNum;
            PrintTplInfo tplInfo;
            Object selecttemplate = this.getModel().getValue("selecttemplate");
            String templateId = selecttemplate + "";
            if (Objects.isNull(selecttemplate) || StringUtils.isBlank((CharSequence)templateId)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f", (String)"MyBillPrintSelectTemplatePlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
                return;
            }
            PrintSettingInfo tplSettingInfo = BillPrintServiceHelper.getTplSettingInfo((String)formId);
            String pdfURL = BillPrintServiceHelper.getPrintPreviewURL((PrintSettingInfo)tplSettingInfo, (PrintTplInfo)(tplInfo = new PrintTplInfo(templateId, tplNum = BillPrintServiceHelper.getTplNumById((String)templateId), newTpl = BosPrintServiceHelper.isNewTpl((String)tplNum))), (String)formId, Collections.singletonList(billId), (IFormView)view);
            if (StringUtils.isBlank((CharSequence)pdfURL)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8\u5931\u8d25", (String)"MyBillPrintSelectTemplatePlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u6253\u5370\u6210\u529f", (String)"MyBillPrintSelectTemplatePlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            view.sendFormAction(parentView);
            BillPrintServiceHelper.openForm((IFormView)view, (IFormView)view.getParentView(), (String)pdfURL);
            view.close();
        }
    }
}

