/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.formplugin.util.AppMenuUtil;
import kd.fi.dhc.helper.BillPrintServiceHelper;

public class MyBillPrintSettingPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String APP_NUMBER = "dhc";
    private static final String BOS_DEV_PORTAL_BIZ_APP = "bos_devportal_bizapp";
    private static final String MENU_TREE = "menutreeview";
    private static final String MENU_ENTRY = "entryentity";
    private static final String TOOL_BAR = "toolbarap";
    private static final String SEARCH_AP = "searchap";
    private static final String CACHE_SEARCH_NODES = "searchNodes";
    private static final String BTN_REFRESH = "btnrefresh";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_CLOSE = "btnclose";
    private static final String BTN_SYN = "btnsyn";
    private static final String CUSTOMIZED_MENU_FLAG = "#customized";
    private static final String CACHE_APP_ID = "appId";
    private static final String CACHE_APP_NAME = "appName";
    private static final String CACHE_ROOT = "root";
    private static final String CACHE_NODE_LEVEL = "nodeLevel";
    private static final String CACHE_CUST_NODEIDS = "customizedNodeIds";
    private static final String CACHE_CHECKED_FORM_NUMBER = "checkedFormNumber";
    private static final String CACHE_CHECKED_FORM_NAME = "checkedFormName";
    private static final String CALL_BACK_TREENODE_CLICK = "callBackTreeNodeClick";
    private static final String CALL_BACK_EXIT_CLICK = "callExitClick";
    private static final String CACHE_FORM_NAME_MAP_FORM_NUMBER = "formNameToFormNumber";
    private static final String CACHE_NODE_ID = "cacheNodeId";
    private static final String CACHE_NODE_NAME = "cacheNodeName";
    private static final String CACHE_TO_NODE_ID = "cacheToNodeId";
    private static final String CACHE_TO_NODE_NAME = "cacheToNodeName";
    private static final String CACHE_SEARCH_TEXT = "lastSearchText";
    private static final String FILTER_NAME = "filtername";
    private static final String RIGHT_FLEX = "flexpanelap2";
    private static final String FILTER_CALL_BACK = "filterCallBack";
    private static final String TEMPLATE_CACHE_KEY = "TEMPLATE_CACHE_KEY_";
    private final Log log = LogFactory.getLog(MyBillPrintSettingPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TextEdit filterName = (TextEdit)this.getView().getControl(FILTER_NAME);
        filterName.addButtonClickListener((ClickListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
        BasedataEdit mtTargetEdit = (BasedataEdit)this.getControl("billtype");
        mtTargetEdit.addBeforeF7SelectListener(this.getBillTypeBeforeF7SelectListener());
    }

    public void afterCreateNewData(EventObject e) {
        AppMetadata metadata = this.getAppMetadata();
        if (Objects.isNull(metadata)) {
            return;
        }
        String firstL5Node = this.renderMenuTree(metadata);
        this.showRightDy(firstL5Node, metadata);
    }

    public void search(SearchEnterEvent evt) {
        List<TreeNode> nodes;
        String searchText = evt.getText();
        String cacheSearchNodes = this.getPageCache().get(CACHE_SEARCH_NODES);
        String cacheSearchText = this.getPageCache().get(CACHE_SEARCH_TEXT);
        if (searchText.equals(cacheSearchText)) {
            nodes = StringUtils.isNotBlank((CharSequence)cacheSearchNodes) ? SerializationUtils.fromJsonStringToList((String)cacheSearchNodes, TreeNode.class) : this.getSearchNodes(searchText);
        } else {
            nodes = this.getSearchNodes(searchText);
            this.getPageCache().put(CACHE_SEARCH_TEXT, searchText);
        }
        if (nodes != null && nodes.size() > 0) {
            TreeNode node = nodes.remove(0);
            String parentId = node.getParentid();
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            tree.focusNode(node);
            tree.showNode(parentId);
            tree.treeNodeClick(parentId, node.getId());
            this.getPageCache().put(CACHE_SEARCH_NODES, SerializationUtils.toJsonString(nodes));
            if (nodes.size() == 0) {
                this.getPageCache().put(CACHE_SEARCH_NODES, "");
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\u3002", (String)"BillMappingMenuTreePlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId;
        String cacheNodeId = this.getPageCache().get(CACHE_NODE_ID);
        if (!StringUtils.equals((CharSequence)cacheNodeId, (CharSequence)(nodeId = evt.getNodeId().toString()))) {
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            Map map = tree.getTreeState().getFocusNode();
            String nodeName = (String)map.get("text");
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.getPageCache().put(CACHE_TO_NODE_ID, nodeId);
                this.getPageCache().put(CACHE_TO_NODE_NAME, nodeName);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u6253\u5370\u8bbe\u7f6e\u5df2\u6539\u53d8\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"MyBillPrintSettingPlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]), this.getPageCache().get(CACHE_NODE_NAME)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_TREENODE_CLICK));
                evt.setCancel(true);
                return;
            }
            String appId = this.getCurrentAppId();
            if (!StringUtils.equals((CharSequence)appId, (CharSequence)((String)evt.getParentNodeId()))) {
                AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
                this.showRightDy(nodeId, appMeta);
            } else {
                this.setRightHidden();
            }
            this.getPageCache().put(CACHE_NODE_ID, nodeId);
            this.getPageCache().put(CACHE_NODE_NAME, nodeName);
            this.getModel().setDataChanged(false);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)FILTER_NAME, (CharSequence)key)) {
            String appId = this.getCurrentAppId();
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
            String cacheNodeId = this.getPageCache().get(CACHE_NODE_ID);
            this.showFilterEditer(cacheNodeId, appMeta);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean dataChanged;
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_SAVE)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection entity = model.getEntryEntity(MENU_ENTRY);
            if (CollectionUtils.isEmpty((Collection)entity)) {
                return;
            }
            for (int i = 0; i < entity.size(); ++i) {
                DynamicObject dy = (DynamicObject)entity.get(i);
                Object filterName = dy.get(FILTER_NAME);
                Object conditionStr = dy.get("filtercondition");
                Object temp = dy.get("filtertemplateid");
                if (!StringUtils.isNotBlank((Object)filterName) && !StringUtils.isNotBlank((Object)conditionStr) || !StringUtils.isBlank((Object)temp)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6309\u6761\u4ef6\u8bbe\u7f6e\u7b2c%s\u884c\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MyBillPrintSettingPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]), i + 1));
                evt.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BTN_SYN)) {
            TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
            Map map = tree.getTreeState().getFocusNode();
            boolean isParent = (Boolean)map.get("isParent");
            if (isParent) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u6811\u4e2d\u9009\u4e2d\u4e00\u79cd\u4e1a\u52a1\u5355\u636e\u3002", (String)"MyBillPrintSettingPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)BTN_CLOSE, (CharSequence)key) && (dataChanged = this.getModel().getDataChanged())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u6253\u5370\u8bbe\u7f6e\u5df2\u6539\u53d8\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"MyBillPrintSettingPlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]), this.getPageCache().get(CACHE_NODE_NAME)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_EXIT_CLICK));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)BTN_REFRESH, (CharSequence)key)) {
            this.refreshCurrPage(this.getModel().getDataChanged());
        } else if (StringUtils.equals((CharSequence)BTN_SAVE, (CharSequence)key)) {
            TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
            Map nodeInfo = treeView.getTreeState().getFocusNode();
            String menuId = "";
            menuId = nodeInfo == null ? this.getPageCache().get(CACHE_NODE_ID) : (String)nodeInfo.get("id");
            Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_FORM_NAME_MAP_FORM_NUMBER), Map.class);
            String billNumber = (String)map.get(menuId);
            this.saveRightValue(billNumber);
            this.getModel().setDataChanged(false);
        } else if (StringUtils.equals((CharSequence)BTN_SYN, (CharSequence)key)) {
            this.synDefaultTemplate();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object retDataStr;
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex(MENU_ENTRY);
        if (FILTER_CALL_BACK.equals(e.getActionId()) && !Objects.isNull(retDataStr = e.getReturnData())) {
            Map retData = (Map)retDataStr;
            model.setValue(FILTER_NAME, retData.get("name"), currentRowIndex);
            model.setValue("filtercondition", retData.get("condition"), currentRowIndex);
            model.setDataChanged(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if (fieldKey.equals(FILTER_NAME)) {
            this.setConditionNull(model, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        boolean succeed = true;
        if (CALL_BACK_TREENODE_CLICK.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult()) || CALL_BACK_EXIT_CLICK.equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            String billNumber = this.getPageCache().get(CACHE_CHECKED_FORM_NUMBER);
            try {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(MENU_ENTRY);
                if (!CollectionUtils.isEmpty((Collection)entity)) {
                    for (int i = 0; i < entity.size(); ++i) {
                        DynamicObject dy = (DynamicObject)entity.get(i);
                        Object filterName = dy.get(FILTER_NAME);
                        Object conditionStr = dy.get("filtercondition");
                        Object temp = dy.get("filtertemplateid");
                        if (!StringUtils.isNotBlank((Object)filterName) && !StringUtils.isNotBlank((Object)conditionStr) || !StringUtils.isBlank((Object)temp)) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6309\u6761\u4ef6\u8bbe\u7f6e\u7b2c%s\u884c\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MyBillPrintSettingPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]), i + 1));
                        succeed = false;
                    }
                }
                if (succeed) {
                    succeed = this.saveRightValue(billNumber);
                }
            }
            catch (Exception e) {
                succeed = false;
            }
        }
        TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
        TreeNode treeNode = new TreeNode();
        if (succeed) {
            treeNode.setId(this.getPageCache().get(CACHE_TO_NODE_ID));
            treeView.focusNode(treeNode);
            String appId = this.getCurrentAppId();
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
            if (CALL_BACK_EXIT_CLICK.equalsIgnoreCase(callBackId)) {
                this.showRightDy(this.getPageCache().get(CACHE_NODE_ID), metadata);
                this.getView().close();
                return;
            }
            this.showRightDy(this.getPageCache().get(CACHE_TO_NODE_ID), metadata);
            this.getPageCache().put(CACHE_NODE_ID, this.getPageCache().get(CACHE_TO_NODE_ID));
            this.getPageCache().put(CACHE_NODE_NAME, this.getPageCache().get(CACHE_TO_NODE_NAME));
            this.getModel().setDataChanged(false);
        } else {
            treeNode.setId(this.getPageCache().get(CACHE_NODE_ID));
            treeView.focusNode(treeNode);
        }
    }

    private AppMetadata getAppMetadata() {
        String appId = this.getCurrentAppId();
        if (appId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"BillMappingMenuTreePlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            this.log.error(" kd.fi.dhc.formplugin.MyBillPrintSettingPlugin.afterCreateNewData: \u6839\u636e\u5e94\u7528\u7f16\u7801 [dhc] \u67e5\u8be2\u5e94\u7528ID\u51fa\u9519\uff0c\u672a\u67e5\u51fa\u6570\u636e\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728\u6216\u5e94\u7528\u7f16\u7801\u662f\u5426\u6b63\u786e\uff01");
            return null;
        }
        return AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
    }

    private String getCurrentAppId() {
        String appId = this.getPageCache().get(CACHE_APP_ID);
        if (StringUtils.isEmpty((CharSequence)appId)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)APP_NUMBER);
            DynamicObject app = QueryServiceHelper.queryOne((String)BOS_DEV_PORTAL_BIZ_APP, (String)"id, name", (QFilter[])new QFilter[]{numberFilter});
            appId = app == null ? null : app.getString("id");
            this.getPageCache().put(CACHE_APP_ID, appId);
            String appName = app == null ? null : app.getString("name");
            this.getPageCache().put(CACHE_APP_NAME, appName);
        }
        return appId;
    }

    private String renderMenuTree(AppMetadata metadata) {
        String appId = metadata.getId();
        String appName = metadata.getName().getLocaleValue();
        TreeNode root = new TreeNode("", appId, appName);
        List<TreeNode> nodeList = this.getBillNodeList(metadata);
        root.addChildren(nodeList);
        this.getPageCache().put(CACHE_ROOT, SerializationUtils.toJsonString((Object)root));
        TreeView tree = (TreeView)this.getView().getControl(MENU_TREE);
        tree.addNode(root);
        tree.showNode(appId);
        TreeNode firstL5OfL4 = root;
        if (nodeList != null && nodeList.size() > 0) {
            TreeNode firstL4Node = nodeList.get(0);
            List L5ListOfL4 = firstL4Node.getChildren();
            if (L5ListOfL4 != null && L5ListOfL4.size() > 0) {
                firstL5OfL4 = (TreeNode)L5ListOfL4.get(0);
                tree.showNode(firstL4Node.getId());
                tree.focusNode(firstL5OfL4);
            }
        } else {
            tree.focusNode(root);
        }
        this.getPageCache().put(CACHE_NODE_ID, firstL5OfL4.getId());
        this.getPageCache().put(CACHE_NODE_NAME, firstL5OfL4.getText());
        return firstL5OfL4.getId();
    }

    private List<TreeNode> getBillNodeList(AppMetadata appMeta) {
        String appId = this.getCurrentAppId();
        JSONArray appIds = AppMenuUtil.getAppIds(appId);
        List menuElements = appMeta.getAppMenus();
        ArrayList<String> firMenuListId = new ArrayList<String>(8);
        ArrayList<TreeNode> firMenuList = new ArrayList<TreeNode>(8);
        for (AppMenuElement menuElement : menuElements) {
            String menuNumber;
            String parentMenuId = menuElement.getParentId();
            if (!StringUtils.isBlank((CharSequence)parentMenuId) && !appIds.contains((Object)parentMenuId) || (menuNumber = menuElement.getNumber()) == null || !menuNumber.endsWith(CUSTOMIZED_MENU_FLAG) || CUSTOMIZED_MENU_FLAG.equalsIgnoreCase(menuNumber)) continue;
            String menuId = menuElement.getId();
            firMenuListId.add(menuId);
            String menuName = (String)menuElement.getName().getDefaultItem();
            TreeNode treeNode = new TreeNode(appId, menuId, menuName);
            firMenuList.add(treeNode);
        }
        HashMap<String, Integer> nodeLevel = new HashMap<String, Integer>(16);
        this.getMenuTreeNode(menuElements, firMenuList, nodeLevel);
        this.getPageCache().put(CACHE_CUST_NODEIDS, SerializationUtils.toJsonString(firMenuListId));
        this.getPageCache().put(CACHE_NODE_LEVEL, SerializationUtils.toJsonString(nodeLevel));
        return firMenuList;
    }

    private void synDefaultTemplate() {
        String key;
        String formNumber = this.getFormNumber();
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)currUserId, (String)(key = formNumber + "_printsetting"));
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            this.setDefaultValue(settingData);
            this.getModel().setDataChanged(true);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6253\u5370\u8bbe\u7f6e\u540c\u6b65\u6210\u529f\u3002", (String)"MyBillPrintSettingPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
    }

    private void setDefaultValue(String settingData) {
        Object pageSeparation;
        Object pageNumType;
        Object vSavePage;
        Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        Object defaultTemplateId = jsonData.get("templateid");
        this.getModel().setValue("defaulttemplate", defaultTemplateId);
        Object printerId = jsonData.get("printerid");
        this.getModel().setValue("defaultprinter", printerId);
        Object printLang = jsonData.get("printlang");
        if (StringUtils.isNotBlank(printLang)) {
            this.getModel().setValue("printlang", printLang);
        } else {
            Lang lang = RequestContext.get().getLang();
            this.getModel().setValue("printlang", (Object)lang.getLocale().toString());
        }
        Object hSavePage = jsonData.get("hSavePage");
        if (hSavePage instanceof Boolean) {
            this.getModel().setValue("hsavepage", hSavePage);
        }
        if ((vSavePage = jsonData.get("vSavePage")) instanceof Boolean) {
            this.getModel().setValue("vsavepage", vSavePage);
        }
        if (StringUtils.isNotBlank(pageNumType = jsonData.get("pageNumType"))) {
            this.getModel().setValue("pagenumtype", pageNumType);
        }
        if (StringUtils.isNotBlank(pageSeparation = jsonData.get("pageSeparation"))) {
            this.getModel().setValue("pageseparation", pageSeparation);
        }
    }

    private String getFormNumber() {
        String formNumber = "";
        String appId = this.getCurrentAppId();
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        String nodeId = this.getPageCache().get(CACHE_NODE_ID);
        Map<String, Object> selectedNodeInfos = this.getSelectedNodeInfos(nodeId, metadata);
        if (!ObjectUtils.isEmpty(selectedNodeInfos)) {
            formNumber = selectedNodeInfos.get("formNumber") + "";
        }
        return formNumber;
    }

    private void setConditionNull(IDataModel model, int rowIndex) {
        Object value = model.getValue(FILTER_NAME, rowIndex);
        if (StringUtils.isBlank((Object)value)) {
            model.setValue("filtercondition", null, rowIndex);
        }
    }

    private void setEntryRowNull(IDataModel model, int rowIndex) {
        model.setValue("enable", (Object)Boolean.FALSE, rowIndex);
        model.setValue("filtertemplateid", null, rowIndex);
        model.setValue(FILTER_NAME, null, rowIndex);
        model.setValue("filtercondition", null, rowIndex);
    }

    private boolean saveRightValue(String billNumber) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billNumber);
        long currUserId = RequestContext.get().getCurrUserId();
        qFilter.and("creator", "=", (Object)currUserId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"dhc_mybillpsmapping", (QFilter[])qFilter.toArray());
        if (Objects.isNull(dynamicObject)) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"dhc_mybillpsmapping");
        }
        IDataModel model = this.getModel();
        dynamicObject.set("billno", (Object)billNumber);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("defaulttemplate", model.getValue("defaulttemplate"));
        dynamicObject.set("printlang", model.getValue("printlang"));
        dynamicObject.set("defaultprinter", model.getValue("defaultprinter"));
        dynamicObject.set("hsavepage", model.getValue("hsavepage"));
        dynamicObject.set("vsavepage", model.getValue("vsavepage"));
        dynamicObject.set("pagenumtype", model.getValue("pagenumtype"));
        dynamicObject.set("pageseparation", model.getValue("pageseparation"));
        dynamicObject.set("creator", (Object)currUserId);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(MENU_ENTRY);
        DynamicObjectCollection entryEntity = model.getEntryEntity(MENU_ENTRY);
        dynamicObjectCollection.clear();
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                DynamicObject entry = dynamicObjectCollection.addNew();
                entry.set("billtype", object.get("billtype"));
                entry.set("enable", object.get("enable"));
                entry.set("filtertemplateid", object.get("filtertemplateid"));
                entry.set(FILTER_NAME, object.get(FILTER_NAME));
                entry.set("filtercondition", object.get("filtercondition"));
            }
        }
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Exception e) {
            return false;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6253\u5370\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f\u3002", (String)"MyBillPrintSettingPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        return true;
    }

    private void showRightDy(String selectNodeId, AppMetadata appMeta) {
        Map<String, Object> selectedNodeInfos = this.getSelectedNodeInfos(selectNodeId, appMeta);
        if (!ObjectUtils.isEmpty(selectedNodeInfos)) {
            String formNumber = (String)selectedNodeInfos.get("formNumber");
            if (StringUtils.isBlank((CharSequence)formNumber)) {
                this.setRightHidden();
                return;
            }
            String formName = (String)selectedNodeInfos.get("formName");
            this.initPrintLangCombo();
            Map cacheTemplates = BillPrintServiceHelper.getCacheTemplates((IFormView)this.getView(), (String)TEMPLATE_CACHE_KEY, (String)formNumber);
            BillPrintServiceHelper.initDefaultCombo((IFormView)this.getView(), (String)"defaulttemplate", (Map)cacheTemplates);
            BillPrintServiceHelper.initDefaultCombo((IFormView)this.getView(), (String)"filtertemplateid", (Map)cacheTemplates);
            this.setRightDyValue(formNumber);
            if (!formNumber.isEmpty()) {
                this.getPageCache().put(CACHE_CHECKED_FORM_NUMBER, formNumber);
                this.getPageCache().put(CACHE_CHECKED_FORM_NAME, formName);
            }
            this.setRightShow();
        } else {
            this.setRightHidden();
        }
    }

    private void setRightDyValue(String formNumber) {
        this.setAllValueNull();
        IDataModel model = this.getModel();
        model.deleteEntryData(MENU_ENTRY);
        QFilter qFilter = new QFilter("billno", "=", (Object)formNumber);
        qFilter.and("creator", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"dhc_mybillpsmapping", (String)EntityField.buildSelectField((String[])new String[]{"billno", "billstatus", "defaulttemplate", "printlang", "defaultprinter", "hsavepage", "vsavepage", "pagenumtype", "pageseparation", "entryentity.billtype billtype", "entryentity.enable enable", "entryentity.filtertemplateid filtertemplateid", "entryentity.filtername filtername", "entryentity.filtercondition filtercondition"}), (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)collection.get(0);
        model.setValue("defaulttemplate", dynamicObject.get("defaulttemplate"));
        model.setValue("printlang", dynamicObject.get("printlang"));
        model.setValue("defaultprinter", dynamicObject.get("defaultprinter"));
        model.setValue("hsavepage", dynamicObject.get("hsavepage"));
        model.setValue("vsavepage", dynamicObject.get("vsavepage"));
        model.setValue("pagenumtype", dynamicObject.get("pagenumtype"));
        model.setValue("pageseparation", dynamicObject.get("pageseparation"));
        model.batchCreateNewEntryRow(MENU_ENTRY, collection.size());
        int i = 0;
        for (DynamicObject dyo : collection) {
            model.setValue("billtype", dyo.get("billtype"), i);
            model.setValue("enable", dyo.get("enable"), i);
            model.setValue("filtertemplateid", dyo.get("filtertemplateid"), i);
            model.setValue(FILTER_NAME, dyo.get(FILTER_NAME), i);
            model.setValue("filtercondition", dyo.get("filtercondition"), i);
            ++i;
        }
    }

    private void setAllValueNull() {
        IDataModel model = this.getModel();
        model.deleteEntryData(MENU_ENTRY);
        model.setValue("defaulttemplate", null);
        model.setValue("printlang", null);
        model.setValue("defaultprinter", null);
        model.setValue("hsavepage", null);
        model.setValue("vsavepage", null);
        model.setValue("pagenumtype", null);
        model.setValue("pageseparation", null);
        this.getView().updateView(RIGHT_FLEX);
    }

    private void setRightShow() {
        this.getView().setVisible(Boolean.TRUE, new String[]{RIGHT_FLEX});
    }

    private void setRightHidden() {
        this.getView().setVisible(Boolean.FALSE, new String[]{RIGHT_FLEX});
    }

    private void getMenuTreeNode(List<AppMenuElement> menuElements, List<TreeNode> parentMenuList, Map<String, Integer> nodeLevel) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (AppMenuElement menuElement : menuElements) {
            String parentMenuId = menuElement.getParentId();
            for (TreeNode parentNode : parentMenuList) {
                String parentNodeId = parentNode.getId();
                if (!parentNodeId.equals(parentMenuId) || menuElement.getVisible().equals("false")) continue;
                String menuId = menuElement.getId();
                String menuName = (String)menuElement.getName().getDefaultItem();
                String menuNumber = menuElement.getFormNumber();
                if ("dhc_menubill".equals(menuNumber)) {
                    Map param = (Map)SerializationUtils.fromJsonString((String)menuElement.getParameter(), Map.class);
                    menuNumber = param.getOrDefault("form", "");
                }
                TreeNode childNode = new TreeNode(parentMenuId, menuId, menuName, false);
                map.put(menuId, menuNumber);
                this.buildNode(parentNode, childNode);
                nodeLevel.put(menuId, 2);
            }
        }
        this.getPageCache().put(CACHE_FORM_NAME_MAP_FORM_NUMBER, SerializationUtils.toJsonString(map));
        for (TreeNode node : parentMenuList) {
            nodeLevel.put(node.getId(), 1);
        }
    }

    private void buildNode(TreeNode parentNode, TreeNode childNode) {
        int seq = 0;
        if (parentNode.getChildren() != null) {
            seq = parentNode.getChildren().size();
        }
        parentNode.addChild(seq, childNode);
    }

    private List<TreeNode> getSearchNodes(String searchText) {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_ROOT), TreeNode.class);
        List firstNode = root.getChildren();
        for (TreeNode firNode : firstNode) {
            List secondNode;
            String firText = firNode.getText();
            if (StringUtils.isNotEmpty((CharSequence)firText) && firText.contains(searchText)) {
                res.add(firNode);
            }
            if ((secondNode = firNode.getChildren()) == null) continue;
            for (TreeNode secNode : secondNode) {
                String secText = secNode.getText();
                if (!StringUtils.isNotEmpty((CharSequence)secText) || !secText.contains(searchText)) continue;
                res.add(secNode);
            }
        }
        return res;
    }

    private Map<String, Object> getSelectedNodeInfos(String selectNodeId, AppMetadata appMeta) {
        List menuElements = appMeta.getAppMenus();
        HashMap<String, Object> nodeInfo = new HashMap<String, Object>(8);
        AppMenuElement menuElement = menuElements.stream().filter(v -> selectNodeId.equals(v.getId())).findAny().orElse(null);
        if (menuElement != null) {
            String formNumber = menuElement.getFormNumber();
            String formName = menuElement.getFormName();
            if ("dhc_menubill".equals(formNumber)) {
                Map param = (Map)SerializationUtils.fromJsonString((String)menuElement.getParameter(), Map.class);
                formNumber = param.getOrDefault("form", "");
                DynamicObject billAccessed = QueryServiceHelper.queryOne((String)"dhc_billaccessed", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formNumber)});
                formName = billAccessed.getString("name");
            }
            nodeInfo.put("formName", formName);
            nodeInfo.put("formNumber", formNumber);
        }
        return nodeInfo;
    }

    private void refreshCurrPage(boolean dataChanged) {
        String appId = this.getCurrentAppId();
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
        TreeView treeView = (TreeView)this.getView().getControl(MENU_TREE);
        Map nodeInfo = treeView.getTreeState().getFocusNode();
        if (nodeInfo == null) {
            return;
        }
        String nodeId = (String)nodeInfo.get("id");
        Boolean isParent = (Boolean)nodeInfo.get("isParent");
        if (StringUtils.isNotBlank((CharSequence)nodeId) && !isParent.booleanValue() && dataChanged) {
            this.showRightDy(nodeId, metadata);
            this.getModel().setDataChanged(false);
        }
    }

    private void showFilterEditer(String selectNodeId, AppMetadata appMeta) {
        FormMetadata formMeta;
        String entityId;
        Map<String, Object> selectedNodeInfos = this.getSelectedNodeInfos(selectNodeId, appMeta);
        if (ObjectUtils.isEmpty(selectedNodeInfos)) {
            return;
        }
        String formId = (String)selectedNodeInfos.get("formNumber");
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(MENU_ENTRY);
        Object name = this.getModel().getValue(FILTER_NAME, currentRowIndex);
        Object condition = this.getModel().getValue("filtercondition", currentRowIndex);
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        if (!id.equals(entityId = (formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form)).getEntityId())) {
            formId = MetadataDao.getNumberById((String)entityId);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("dhc_printfilterediter");
        showParameter.setCustomParam("formId", (Object)formId);
        showParameter.setCustomParam("name", name);
        showParameter.setCustomParam("condition", condition);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FILTER_CALL_BACK);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private BeforeF7SelectListener getBillTypeBeforeF7SelectListener() {
        return event -> {
            String cacheNodeId = this.getPageCache().get(CACHE_NODE_ID);
            AppMetadata appMetadata = this.getAppMetadata();
            if (Objects.isNull(appMetadata)) {
                return;
            }
            Map<String, Object> selectedNodeInfos = this.getSelectedNodeInfos(cacheNodeId, appMetadata);
            if (!ObjectUtils.isEmpty(selectedNodeInfos)) {
                String formNumber = (String)selectedNodeInfos.get("formNumber");
                QFilter filter = new QFilter("billformid", "=", (Object)formNumber);
                event.setCustomQFilters(Arrays.asList(filter.recombine()));
            }
        };
    }

    private void initPrintLangCombo() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ComboEdit printLangCombo = (ComboEdit)this.getView().getControl("printlang");
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List enableLangs = inteService.getLocalLangForPrint("1");
        for (EnabledLang lang : enableLangs) {
            ComboItem item = new ComboItem();
            item.setValue(lang.getNumber());
            item.setCaption(new LocaleString(lang.getName()));
            comboItems.add(item);
        }
        printLangCombo.setComboItems(comboItems);
    }
}

