/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.dhc.helper.BillPrintServiceHelper;
import kd.fi.dhc.runnable.MyBillPrintingProcess;

public class MyBillPrintingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"MyBillPrintPool", (int)2);
    private List<Object> pkIds;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.iniFormParameter(parameter);
        this.start();
    }

    private void iniFormParameter(FormShowParameter parameter) {
        this.pkIds = this.getPkIds(parameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btncancel".equals(c.getKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u7ec8\u6b62\u6253\u5370\u4efb\u52a1\uff1f", (String)"MyBillPrintingPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CANCEL"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("CANCEL".equalsIgnoreCase(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            bar.stop();
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent e) {
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        ProgressBar bar = (ProgressBar)view.getControl("progressbarap");
        try {
            String taskId = this.getTaskId();
            if (StringUtils.isBlank((CharSequence)taskId)) {
                taskId = DBServiceHelper.genStringId();
                FormShowParameter parameter = view.getFormShowParameter();
                this.iniFormParameter(parameter);
                MyBillPrintingProcess execute = new MyBillPrintingProcess(taskId, this.pkIds, parentView, view);
                threadPool.execute((Runnable)execute);
                this.setTaskId(taskId);
                return;
            }
            List<String> noTpl = MyBillPrintingProcess.getNoTpl(taskId);
            Set<String> pdfurl = MyBillPrintingProcess.getPDFURL(taskId);
            if (!CollectionUtils.isEmpty(pdfurl)) {
                e.setProgress(100);
                bar.stop();
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u6253\u5370\u6210\u529f", (String)"MyBillPrintSelectTemplatePlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                view.sendFormAction(parentView);
                for (String pdfURL : pdfurl) {
                    BillPrintServiceHelper.openForm((IFormView)view, (IFormView)parentView, (String)pdfURL);
                }
                MyBillPrintingProcess.setPDFURL(taskId, null);
                view.close();
            } else if (!CollectionUtils.isEmpty(noTpl)) {
                bar.stop();
                BillPrintServiceHelper.showPrintResult(noTpl, (IFormView)view, (IFormView)parentView);
                MyBillPrintingProcess.setNoTpl(taskId, null);
                view.close();
            } else {
                int progress = MyBillPrintingProcess.getProgress(taskId);
                boolean interruption = MyBillPrintingProcess.isInterruption(taskId);
                if (interruption) {
                    parentView.showTipNotification(ResManager.loadKDString((String)"\u6253\u5370\u5931\u8d25", (String)"MyBillPrintingPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                    view.sendFormAction(parentView);
                    bar.stop();
                    view.close();
                } else {
                    e.setProgress(progress);
                }
            }
        }
        catch (Exception ex) {
            parentView.showErrMessage(String.format(ResManager.loadKDString((String)"\u62a5\u9519\u4fe1\u606f:\u4e0b\u5217\u5355\u636e\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u8df3\u8f6c\u81f3\u6253\u5370\u8bbe\u7f6e\u9875\u9762\uff1f", (String)"MyBillPrintingPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]), new Object[0]), ex.getMessage());
            view.sendFormAction(parentView);
            bar.stop();
            view.close();
        }
    }

    private IFormView getParentView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = null;
        try {
            parentView = this.getView().getView(parentPageId);
        }
        catch (Exception var4) {
            parentView = this.getView().getViewNoPlugin(parentPageId);
        }
        return parentView;
    }

    private String getTaskId() {
        return this.getPageCache().get("taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("taskid", taskId);
    }

    private List<Object> getPkIds(FormShowParameter parameter) {
        String str = (String)parameter.getCustomParam("pkIds");
        List<Object> pkids = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            pkids = (List)SerializationUtils.fromJsonString((String)str, List.class);
        }
        return pkids;
    }

    private void start() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }
}

