/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.dhc.enums.ReimburseStatusEnum;

public class ReimburseStatusMappingPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener {
    private static final String billStatusFormKey = "dhc_billmappingstatus";
    private static final String billStatusKey = "billstatus";
    private static final String billTypeKey = "billtype";
    private static final String entryEntityKey = "entryentity";
    private static final String reimburseStatusKeyKey = "reimbursestatuskey";
    private static final String reimburseStatusNameKey = "reimbursestatusname";
    private static final String billStatusFormClose = "billStatusFormClose";
    private static final String otherMappedBillStatus = "otherMappedBillStatus";
    private static final String currentMappedBillStatus = "currentMappedBillStatus";
    private static final String paramNumberKey = "paramNumber";
    private static final String btnOkKey = "btnok";
    private boolean isUpdateMapped = false;
    private boolean isShowConfirm = true;
    private Map<String, Map<String, String>> allMappedBillStatusMap;
    private static final String CACHEKEY_STATUSMAP = "cache_map";
    private static final String CACHEKEY_STATUS_INTI_MAP = "cache_init_map";

    public void initialize() {
        TextEdit textEdit = (TextEdit)this.getView().getControl(billStatusKey);
        textEdit.addButtonClickListener((ClickListener)this);
        Button btn = (Button)this.getView().getControl(btnOkKey);
        btn.addClickListener((ClickListener)this);
        this.setColEditorProp();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        IDataModel dataModel = this.getModel();
        String mappingNumber = (String)param.getCustomParam("mappingNumber");
        this.allMappedBillStatusMap = this.getAllMappedBillStatus(mappingNumber);
        ReimburseStatusEnum[] reimburseStatus = ReimburseStatusEnum.values();
        this.getModel().batchCreateNewEntryRow(entryEntityKey, reimburseStatus.length - 1);
        for (int i = 0; i < reimburseStatus.length; ++i) {
            Map<String, String> billStatus;
            int reimburseStatusKey = reimburseStatus[i].getValue();
            String reimburseStatuName = reimburseStatus[i].getName();
            dataModel.setValue(reimburseStatusKeyKey, (Object)reimburseStatusKey, i);
            dataModel.setValue(reimburseStatusNameKey, (Object)reimburseStatuName, i);
            if (this.allMappedBillStatusMap == null || this.allMappedBillStatusMap.size() <= 0 || (billStatus = this.allMappedBillStatusMap.get(reimburseStatusKey + "")) == null) continue;
            StringBuilder statusNameBd = new StringBuilder();
            billStatus.forEach((statusKey, statsName) -> statusNameBd.append((String)statsName).append(','));
            statusNameBd.deleteCharAt(statusNameBd.length() - 1);
            dataModel.setValue(billStatusKey, (Object)statusNameBd.toString(), i);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        FormShowParameter param = this.getView().getFormShowParameter();
        String billType = (String)param.getCustomParam("entryNumber");
        String paramNumber = (String)param.getCustomParam(paramNumberKey);
        if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)paramNumber)) {
            return;
        }
        switch (clickKey) {
            case "billstatus": {
                this.openBillMappingStatusForm(billType, paramNumber);
                break;
            }
            case "btnok": {
                this.saveMappingStatus(billType);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData != null && billStatusFormClose.equals(actionId)) {
            Map returnDataMap = (Map)returnData;
            this.getPageCache().put("isWholeMapped", (String)returnDataMap.get("isWholeMapped"));
            this.isUpdateMapped = Boolean.parseBoolean((String)returnDataMap.get("isUpdateMapped"));
            returnDataMap.remove("isWholeMapped");
            returnDataMap.remove("isUpdateMapped");
            if (this.isUpdateMapped) {
                this.setBillStatusAndMappedStatus(returnDataMap);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isShowConfirm && !this.compareBillStatusUpdated()) {
            ConfirmCallBackListener exitConfirm = new ConfirmCallBackListener("exit");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9000\u51fa\u540e\u5c06\u4e22\u5931\u4fee\u6539\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9000\u51fa\u3002", (String)"ReimburseStatusMappingPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, exitConfirm);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("exit".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.isShowConfirm = false;
            this.getView().close();
        }
    }

    private Map<String, Map<String, String>> getAllMappedBillStatus(String allMappedStatus) {
        if (StringUtils.isEmpty((String)allMappedStatus)) {
            return new HashMap<String, Map<String, String>>(16);
        }
        Map mappedBillStatus = (Map)SerializationUtils.fromJsonString((String)allMappedStatus, Map.class);
        HashMap<String, Map<String, String>> allMappedBillStatus = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry entry : mappedBillStatus.entrySet()) {
            HashMap status = new HashMap(16);
            Arrays.asList(((String)entry.getValue()).split(",")).forEach(v -> {
                String[] keyAndValue = v.split("_");
                status.put(keyAndValue[0], keyAndValue[1]);
            });
            allMappedBillStatus.put((String)entry.getKey(), status);
        }
        this.getPageCache().put(CACHEKEY_STATUSMAP, SerializationUtils.toJsonString(allMappedBillStatus));
        this.getPageCache().put(CACHEKEY_STATUS_INTI_MAP, SerializationUtils.toJsonString(allMappedBillStatus));
        return allMappedBillStatus;
    }

    private void saveMappingStatus(String billType) {
        String allMapped = this.getPageCache().get("isWholeMapped");
        if (allMapped != null && !Boolean.parseBoolean(allMapped)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u672a\u5b8c\u5168\u6620\u5c04\u3002", (String)"ReimburseStatusMappingPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.allMappedBillStatusMap = this.getStatusMapFromCache();
        Map<String, String> reimbursingMappedStatus = this.allMappedBillStatusMap.get(ReimburseStatusEnum.REIMBURSING.getValue() + "");
        Map<String, String> reimbursedMappedStatus = this.allMappedBillStatusMap.get(ReimburseStatusEnum.HAVE_BEEN_REIMBURSED.getValue() + "");
        if (CollectionUtils.isEmpty(reimbursingMappedStatus) || CollectionUtils.isEmpty(reimbursedMappedStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8d26\u4e2d\u3001\u62a5\u8d26\u5b8c\u6210\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u3002", (String)"ReimburseStatusMappingPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap mappedStatus = new HashMap(16);
        this.allMappedBillStatusMap.forEach((key, status) -> {
            StringBuilder statusOfReimburse = new StringBuilder();
            status.forEach((statusKey, statusName) -> statusOfReimburse.append((String)statusKey).append('_').append((String)statusName).append(','));
            if (statusOfReimburse.length() > 0) {
                statusOfReimburse.deleteCharAt(statusOfReimburse.length() - 1);
                mappedStatus.put(key, statusOfReimburse.toString());
            }
        });
        HashMap<String, String> returnData = new HashMap<String, String>(4);
        returnData.put("entryNumber", billType);
        returnData.put("mappingNumber", SerializationUtils.toJsonString(mappedStatus));
        this.getView().returnDataToParent(returnData);
        this.isShowConfirm = false;
        this.getView().close();
    }

    private void openBillMappingStatusForm(String billType, String paramNumber) {
        ArrayList<String> allMappedBillStatusKey = new ArrayList<String>();
        ArrayList<String> currentMappedStatusKey = new ArrayList<String>();
        this.allMappedBillStatusMap = this.getStatusMapFromCache();
        if (this.allMappedBillStatusMap != null) {
            this.allMappedBillStatusMap.forEach((key, status) -> status.forEach((statusKey, statusName) -> allMappedBillStatusKey.add((String)statusKey)));
            int index = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
            String currentReimburseStatusKey = this.getModel().getValue(reimburseStatusKeyKey, index) + "";
            Map<String, String> currentMappedStatus = this.allMappedBillStatusMap.get(currentReimburseStatusKey);
            if (currentMappedStatus != null) {
                currentMappedStatus.forEach((statusKey, statusValue) -> {
                    allMappedBillStatusKey.remove(statusKey);
                    currentMappedStatusKey.add((String)statusKey);
                });
            }
        }
        this.showBillMappingStatusForm(billType, paramNumber, allMappedBillStatusKey, currentMappedStatusKey);
    }

    private void showBillMappingStatusForm(String billType, String paramNumber, List<String> otherMappedBillStatusKey, List<String> currentMappedStatusKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(billStatusFormKey);
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCustomParam(billTypeKey, (Object)billType);
        showParameter.setCustomParam(paramNumberKey, (Object)paramNumber);
        showParameter.setCustomParam(currentMappedBillStatus, currentMappedStatusKey);
        showParameter.setCustomParam(otherMappedBillStatus, otherMappedBillStatusKey);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, billStatusFormClose);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setBillStatusAndMappedStatus(Map<String, String> billStatusFormReturnData) {
        IDataModel dataModel = this.getModel();
        int index = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
        String currentReimburseStatusKey = dataModel.getValue(reimburseStatusKeyKey, index) + "";
        StringBuilder currentNewMappingStatusNameBd = new StringBuilder();
        if (billStatusFormReturnData != null && billStatusFormReturnData.size() != 0) {
            billStatusFormReturnData.forEach((key, value) -> currentNewMappingStatusNameBd.append((String)value).append(','));
            currentNewMappingStatusNameBd.deleteCharAt(currentNewMappingStatusNameBd.length() - 1);
        }
        this.allMappedBillStatusMap = this.getStatusMapFromCache();
        this.allMappedBillStatusMap.put(currentReimburseStatusKey, billStatusFormReturnData);
        this.getPageCache().put(CACHEKEY_STATUSMAP, SerializationUtils.toJsonString(this.allMappedBillStatusMap));
        this.getModel().setValue(billStatusKey, (Object)currentNewMappingStatusNameBd.toString(), index);
    }

    private void setColEditorProp() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(entryEntityKey, "setColEditorProp", new Object[]{billStatusKey, "sx", Boolean.FALSE});
    }

    private Map<String, Map<String, String>> getStatusMapFromCache() {
        String statusValue = this.getPageCache().get(CACHEKEY_STATUSMAP);
        if (StringUtils.isEmpty((String)statusValue)) {
            return new HashMap<String, Map<String, String>>(3);
        }
        return (Map)SerializationUtils.fromJsonString((String)statusValue, Map.class);
    }

    private Map<String, Map<String, String>> getInitialBillStatusMapFromCache() {
        String statusValue = this.getPageCache().get(CACHEKEY_STATUS_INTI_MAP);
        if (StringUtils.isEmpty((String)statusValue)) {
            return new HashMap<String, Map<String, String>>(3);
        }
        return (Map)SerializationUtils.fromJsonString((String)statusValue, Map.class);
    }

    private boolean compareBillStatusUpdated() {
        Map<String, Map<String, String>> initialBillStatusMap = this.getInitialBillStatusMapFromCache();
        Map<String, Map<String, String>> cached = this.getStatusMapFromCache();
        for (Map.Entry<String, Map<String, String>> entry : initialBillStatusMap.entrySet()) {
            String key = entry.getKey();
            Map<String, String> initMap = entry.getValue();
            Map<String, String> currMap = cached.get(key);
            if (initMap.size() != currMap.size()) {
                return false;
            }
            for (Map.Entry<String, String> subEntry : initMap.entrySet()) {
                String subKey = subEntry.getKey();
                if (subEntry.getValue().equals(currMap.get(subKey))) continue;
                return false;
            }
        }
        return true;
    }
}

