/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin.exception;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.dhc.enums.DataSynTypeEnum;
import kd.fi.dhc.executor.DataSynchronizationExecutor;
import kd.fi.dhc.util.DynamicObjectUtils;

public class SynBillDataFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(SynBillDataFormPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String KEY_BILLTYPE = "billtype";
    private static final String KEY_BILLNUMBER = "billnumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn_ok = (Button)this.getControl(BTN_OK);
        btn_ok.addClickListener((ClickListener)this);
        BasedataEdit billType = (BasedataEdit)this.getControl(KEY_BILLTYPE);
        billType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            DynamicObject billTypeObj = (DynamicObject)model.getValue(KEY_BILLTYPE);
            if (billTypeObj == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u5355\u636e\u201d\u3002", (String)"SynBillDataFormPlugin_6", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            String billTypeNumber = billTypeObj.getString("id");
            String billNo = (String)model.getValue(KEY_BILLNUMBER);
            if (StringUtils.isEmpty((String)billNo)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u7f16\u7801\u201d\u3002", (String)"SynBillDataFormPlugin_7", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean success = this.synBillData(billTypeNumber, billNo);
            if (success) {
                view.returnDataToParent((Object)"true");
                view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u6210\u529f\u3002", (String)"SynBillDataFormPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
                view.close();
            }
        }
    }

    private boolean synBillData(String entityNumber, String billNumber) {
        IFormView view = this.getView();
        if (entityNumber == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"SynBillDataFormPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return false;
        }
        String numberProperty = DynamicObjectUtils.getNumberProperty((String)entityNumber);
        if (numberProperty == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u65e0\u5355\u636e\u7f16\u53f7\u5c5e\u6027\u3002", (String)"SynBillDataFormPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject billTypeObj = (DynamicObject)this.getModel().getValue(KEY_BILLTYPE);
        String id = billTypeObj.getString("id");
        String name = billTypeObj.getString("name");
        QFilter billNoFilter = new QFilter(numberProperty, "=", (Object)billNumber);
        DynamicObject billData = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{billNoFilter});
        if (billData == null) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u5355\u636e\u3002", (String)"SynBillDataFormPlugin_2", (String)"fi-dhc-formplugin", (Object[])new Object[0]), name, billNumber));
            return false;
        }
        try {
            long billId = (Long)billData.getPkValue();
            HashSet<Long> pkValues = new HashSet<Long>();
            pkValues.add(billId);
            DataSynchronizationExecutor executor = new DataSynchronizationExecutor(entityNumber, pkValues, DataSynTypeEnum.SYN_DATA);
            executor.execute();
        }
        catch (KDException e) {
            log.error("dhc synchronization bill data error -- \u8f6c\u6362\u6620\u5c04\u6570\u636e\u62a5\u9519", (Throwable)e);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5355\u636e%2$s\u8f6c\u6362\u4e3a\u201c\u6211\u7684\u62a5\u8d26\u201d\u6570\u636e\u51fa\u9519\uff1a%3$s", (String)"SynBillDataFormPlugin_3", (String)"fi-dhc-formplugin", (Object[])new Object[0]), id, billNumber, e.getMessage()));
            return false;
        }
        catch (Throwable th) {
            log.error("dhc synchronization bill data error", th);
            view.showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SynBillDataFormPlugin_4", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ArrayList<String> billList = new ArrayList<String>(16);
        Map dhcBillaccessedMap = BusinessDataServiceHelper.loadFromCache((String)"dhc_billaccessed", (String)"accessedbillnew.number", null);
        for (Map.Entry entry : dhcBillaccessedMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            billList.add(dynamicObject.getString("accessedbillnew.number"));
        }
        QFilter filter = new QFilter("number", "in", billList);
        ListShowParameter listParam = (ListShowParameter)arg0.getFormShowParameter();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"dhc_billaccessed");
        String name = dynamicObject.getDataEntityType().getDisplayName().getLocaleValue();
        listParam.setCaption(name);
        listParam.getListFilterParameter().getQFilters().add(filter);
    }
}

