/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin.reimorder;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.mvc.bill.BillView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.dhc.listener.BeforeBusItemF7SelectListener;
import kd.fi.dhc.util.AccountBookUtil;
import kd.fi.dhc.util.BaseDataHelper;
import kd.fi.dhc.util.FormOperateUtil;

public class ReimOrderFormPlugin
extends AbstractFormPlugin {
    private static final String BOS_USER = "bos_user";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String KEY_CHANGEAPPLIER = "changeapplier";
    private static final String APP_DHC = "dhc";
    private static final String Caller_PropertyChanged = "propertyChanged";
    private static final String Caller_BindData = "bindData";
    private static final String Caller_CreateNew = "createNew";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        String entityName = this.getModel().getDataEntityType().getName();
        BasedataEdit biztypeF7 = (BasedataEdit)this.getControl("biztype");
        biztypeF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeBusItemF7SelectListener(this.getView(), entityName, "accountingorg", "dept"));
        this.addClickListeners(new String[]{KEY_CHANGEAPPLIER});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBaseInfo(Caller_CreateNew);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDateFieldsMaxVal();
        this.setButtonVisible();
        FormOperateUtil.setSwitchButtonVisible((IDataModel)this.getModel(), (IFormView)this.getView(), (String)KEY_CHANGEAPPLIER);
        this.initBaseInfo(Caller_BindData);
        this.checkUserRigth();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        this.setButtonVisible();
        FormOperateUtil.setSwitchButtonVisible((IDataModel)this.getModel(), (IFormView)this.getView(), (String)KEY_CHANGEAPPLIER);
        if ((args.getSource() instanceof Save || args.getSource() instanceof Submit) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"accountingorg"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_CHANGEAPPLIER.equals(key)) {
            FormOperateUtil.clickSwitchButton((EventObject)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (IFormPlugin)this, (String)KEY_CHANGEAPPLIER);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("changeapplierclose".equals(actionId)) {
            FormOperateUtil.switchButtonclosedCallBack((ClosedCallBackEvent)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)"company", (String)"dept", (String)"position", (String)"biztype");
        }
    }

    private void initBaseInfo(String caller) {
        Long deptId;
        IDataModel model = this.getModel();
        BillView view = (BillView)this.getView();
        OperationStatus status = view.getStatus();
        DynamicObject creator = (DynamicObject)model.getValue("creator");
        Long creatorId = (Long)creator.getPkValue();
        DynamicObject creator_ = BusinessDataServiceHelper.loadSingleFromCache((Object)creatorId, (String)BOS_USER);
        Object accOrg = model.getValue("accountingorg");
        if (accOrg == null) {
            Long accOrgId = Long.valueOf(AccountBookUtil.getAccountingOrgOnNew(null, (Long)creatorId, (String)APP_DHC, (String)this.getView().getEntityId()));
            model.setValue("accountingorg", (Object)accOrgId);
        }
        if ((deptId = Long.valueOf(UserServiceHelper.getUserMainOrgId((long)creatorId))) <= 0L) {
            if (Caller_CreateNew.equals(caller)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u63d0\u5355\u4eba\u9700\u8981\u4e3b\u804c\u4f4d\u624d\u80fd\u63d0\u5355\uff0c\u8bf7\u5230\u201c\u7cfb\u7edf\u670d\u52a1\u4e91> \u57fa\u7840\u670d\u52a1>\u4eba\u5458\u201d\u5904\u8bbe\u7f6e\u3002", (String)"ReimOrderFormPlugin_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            }
            view.setVisible(Boolean.FALSE, new String[]{"tbmain"});
            view.setVisible(Boolean.TRUE, new String[]{"tbmain1"});
            view.setEnable(Boolean.FALSE, new String[]{"contentpanel"});
            return;
        }
        if (Caller_CreateNew.equals(caller)) {
            model.setValue("dept", (Object)deptId);
            String position = UserServiceHelper.getUserMainJob((long)creatorId);
            model.setValue("position", (Object)position);
            Map companyInfo = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            model.setValue("company", companyInfo.get("id"));
        }
        Image applierPic = (Image)this.getControl("applierpic");
        applierPic.setUrl(BaseDataHelper.getUserImage((Long)creatorId));
        Label applierv = (Label)this.getControl("applierv");
        applierv.setText(creator_.getString("name"));
        Label telv = (Label)this.getControl("telv");
        Object val = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)((IDataEntityProperty)creator_.getDataEntityType().getProperties().get((Object)"phone")), (String)Lang.get().toString(), (String)"FORM", (DynamicObject)creator_, (Object)creator_.getString("phone"));
        telv.setText(String.valueOf(val));
    }

    private void setDateFieldsMaxVal() {
        Date now = new Date();
        List<String> needFields = Collections.singletonList("applydate");
        needFields.forEach(p -> {
            DateEdit dateEdit = (DateEdit)this.getControl((String)p);
            dateEdit.setMaxDate(now);
        });
    }

    private void checkUserRigth() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject creator = (DynamicObject)model.getValue("creator");
        DynamicObject accountOrg = (DynamicObject)model.getValue("accountingorg");
        Long creatorId = (Long)creator.getPkValue();
        Long accountOrgId = (Long)accountOrg.getPkValue();
        boolean hasRight = AccountBookUtil.hasAccountOrgRight((Long)accountOrgId, (Long)creatorId, (String)APP_DHC, (String)this.getView().getEntityId());
        if (!hasRight) {
            view.setEnable(Boolean.FALSE, new String[]{"contentpanelflex"});
            view.setVisible(Boolean.FALSE, new String[]{"titlepanel"});
            view.setVisible(Boolean.TRUE, new String[]{"tbmain1"});
            model.setDataChanged(false);
        }
    }

    private void setButtonVisible() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        IFormView view = this.getView();
        switch (billStatus) {
            case "A": {
                view.setEnable(Boolean.FALSE, new String[]{"bar_invalid"});
                view.setEnable(Boolean.TRUE, new String[]{BAR_SUBMIT});
                view.setEnable(Boolean.FALSE, new String[]{"bar_unsubmit"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                view.setVisible(Boolean.TRUE, new String[]{BAR_SAVE});
                view.setVisible(Boolean.TRUE, new String[]{"bar_del"});
                view.setVisible(Boolean.TRUE, new String[]{BAR_SUBMIT});
                view.setVisible(Boolean.FALSE, new String[]{"tbmain1"});
                break;
            }
            case "B": {
                view.setEnable(Boolean.TRUE, new String[]{"bar_audit"});
                view.setEnable(Boolean.FALSE, new String[]{"bar_unaudit"});
                view.setEnable(Boolean.TRUE, new String[]{"bar_invalid"});
                view.setEnable(Boolean.FALSE, new String[]{BAR_SUBMIT});
                view.setEnable(Boolean.TRUE, new String[]{"bar_unsubmit"});
                view.setVisible(Boolean.TRUE, new String[]{"viewimage"});
                view.setVisible(Boolean.TRUE, new String[]{"viewflow"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_audit"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_invalid"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_unsubmit"});
                view.setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                view.setVisible(Boolean.FALSE, new String[]{"tbmain1"});
                break;
            }
            case "C": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                view.setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                view.setVisible(Boolean.FALSE, new String[]{"tbmain1"});
                break;
            }
            case "D": {
                view.setEnable(Boolean.FALSE, new String[]{"bar_audit"});
                view.setEnable(Boolean.TRUE, new String[]{"bar_unaudit"});
                view.setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                view.setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                view.setVisible(Boolean.TRUE, new String[]{"viewimage"});
                view.setVisible(Boolean.TRUE, new String[]{"viewflow"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                view.setVisible(Boolean.FALSE, new String[]{"tbmain1"});
                break;
            }
            case "E": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                view.setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                view.setVisible(Boolean.FALSE, new String[]{"tbmain1"});
                break;
            }
            case "F": {
                view.setVisible(Boolean.FALSE, new String[]{BAR_SUBMIT});
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                view.setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
                view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                view.setVisible(Boolean.FALSE, new String[]{"tbmain1"});
            }
        }
    }
}

