/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.formplugin.reimorder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.dhc.util.BillShowParameterUtil;

public class ReimOrderListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ReimOrderListPlugin.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection collection = super.getData(start, limit);
                ArrayList ids = new ArrayList();
                collection.forEach(v -> ids.add(String.valueOf(v.getPkValue())));
                if (!ids.isEmpty()) {
                    ReimOrderListPlugin.this.setNextAuditor(collection, ids);
                }
                return collection;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fileldName = args.getHyperLinkClickEvent().getFieldName();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if ("nextauditor".equals(fileldName)) {
            args.setCancel(true);
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u4efb\u52a1", (String)"TallyApplyBillListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Object billid = selectedRows.get(0).getPrimaryKeyValue();
            ListShowParameter listshow = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listshow.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billid);
        } else if ("billno".equals(fileldName)) {
            args.setCancel(true);
            ListSelectedRow selectedRow = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo();
            Long selectId = (Long)selectedRow.getPrimaryKeyValue();
            this.showBillForm(selectId);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.getParameter().setHasRight(true);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        commonFilterColumns.forEach(v -> {
            String columnName = v.getFieldName();
            if (StringUtils.equals((CharSequence)columnName, (CharSequence)"applydate")) {
                v.setDefaultValue("63");
            }
        });
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean isValid;
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        IFormView view = this.getView();
        int size = selectedRows.size();
        if (("trackup".equals(itemKey) || "trackdown".equals(itemKey) || "viewimage".equals(itemKey) || "viewflow".equals(itemKey)) && (isValid = this.isSelectRowsInvalid(view, size, false))) {
            evt.setCancel(true);
        }
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> ids) {
        Map<String, String> nextAuditor = this.getNextAuditor(ids);
        collection.forEach(v -> {
            String id = String.valueOf(v.getPkValue());
            v.set("nextauditor", (Object)(nextAuditor.get(id) == null ? "" : nextAuditor.get(id)));
        });
    }

    public Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>(10);
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        Iterator var5 = allPro.entrySet().iterator();
        while (var5.hasNext()) {
            String pkid = (String)var5.next().getKey();
            List node = (List)allPro.get(pkid);
            node.forEach(e -> {
                String nodeStr = e.getCurrentNodeName();
                String auditor = e.getParticipantName();
                if (auditor != null && !"".equals(auditor.trim())) {
                    nodeStr = nodeStr + " / " + auditor;
                }
                nodeMap.put(pkid, nodeStr);
            });
        }
        return nodeMap;
    }

    private boolean isSelectRowsInvalid(IFormView view, Integer size, boolean canMultipleSelect) {
        if (size == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ManaulTallyListPlugin_4", (String)"fi-fr-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (size > 1 && !canMultipleSelect) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"ManaulTallyListPlugin_5", (String)"fi-fr-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void showBillForm(Long selectDataId) {
        DynamicObject selectBillData = this.getSelectBillData(selectDataId);
        if (selectBillData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"MyBillListPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            return;
        }
        String id = selectBillData.getString("id");
        String billStatus = selectBillData.getString("billstatus");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            BillShowParameter parameter = BillShowParameterUtil.getBusBillShowParamter("dhc_reimorder", id);
            if (parameter != null) {
                if (!"A".equals(billStatus) && !"E".equals(billStatus)) {
                    parameter.setStatus(OperationStatus.VIEW);
                } else {
                    Long orgId;
                    Long userId = Long.parseLong(RequestContext.get().getUserId());
                    Integer hasPerm = PermissionServiceHelper.checkPermission((Long)userId, (Long)(orgId = Long.valueOf(RequestContext.get().getOrgId())), (String)"0HAJN6NF6DOV", (String)"dhc_reimorder", (String)"4715a0df000000ac");
                    if (hasPerm != 1) {
                        parameter.setStatus(OperationStatus.VIEW);
                    }
                }
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"MyBillListPlugin_5", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getSelectBillData(Long selectDataId) {
        return QueryServiceHelper.queryOne((String)"dhc_reimorder", (String)"id, billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectDataId)});
    }
}

