/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.runnable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.dhc.constant.EntityField;
import kd.fi.dhc.helper.BillPrintServiceHelper;
import kd.fi.dhc.mircoservice.pojo.dto.mybillprint.PrintSettingInfo;
import kd.fi.dhc.mircoservice.pojo.dto.mybillprint.PrintTplInfo;

public class MyBillPrintingProcess
implements Runnable {
    private static final Log log = LogFactory.getLog(MyBillPrintingProcess.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private String taskId;
    private List<Object> pkIds;
    private IFormView view;
    private IFormView thisview;

    public MyBillPrintingProcess(String taskId, List<Object> pkIds, IFormView view, IFormView thisview) {
        this.taskId = taskId;
        this.pkIds = pkIds;
        this.view = view;
        this.thisview = thisview;
    }

    public MyBillPrintingProcess() {
    }

    @Override
    public void run() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            MyBillPrintingProcess.setInterruption(this.taskId, true);
            log.error("print more bill error :" + e.getMessage(), (Throwable)e);
        }
    }

    private void doExecute() {
        String formId;
        log.info("print begin taskId = " + this.taskId);
        QFilter qFilter = new QFilter("id", "in", this.pkIds);
        String selectProperties = EntityField.buildSelectField((String[])new String[]{"id", "billno", "billid", "bill.number", "billnew.id"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"dhc_mybilllist", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"MyBillListPlugin_1", (String)"fi-dhc-formplugin", (Object[])new Object[0]));
            MyBillPrintingProcess.setInterruption(this.taskId, true);
            return;
        }
        Map<String, List<DynamicObject>> groupByFormIdBills = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getString("billnew.id")));
        Set<String> strings = groupByFormIdBills.keySet();
        Map<Long, List<DynamicObject>> collect1 = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("billid")));
        Set<Long> billIds = collect1.keySet();
        Map printSettingInfoMap = BillPrintServiceHelper.getAllTplSettingInfo(strings);
        MyBillPrintingProcess.setProgress(this.taskId, 20);
        ArrayList<String> noTplIds = new ArrayList<String>(8);
        HashMap<Long, List> allBillTplInfo = new HashMap<Long, List>(16);
        for (DynamicObject dy2 : dynamicObjects) {
            formId = dy2.getString("billnew.id");
            long billId = dy2.getLong("billid");
            String billNo = dy2.getString("billno");
            List tpl = BillPrintServiceHelper.getTpl((IFormView)this.thisview, (String)formId, (long)billId, billIds, (boolean)false);
            if (CollectionUtils.isEmpty((Collection)tpl)) {
                noTplIds.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"MyBillPrintingProcess_0", (String)"fi-dhc-formplugin", (Object[])new Object[0]), billNo));
                continue;
            }
            allBillTplInfo.put(billId, tpl);
        }
        if (!CollectionUtils.isEmpty(noTplIds)) {
            MyBillPrintingProcess.setNoTpl(this.taskId, noTplIds);
            return;
        }
        MyBillPrintingProcess.setProgress(this.taskId, 50);
        HashSet<String> pdfURLs = new HashSet<String>(8);
        Set<Map.Entry<String, List<DynamicObject>>> entries = groupByFormIdBills.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            formId = entry.getKey();
            PrintSettingInfo printSettingInfo = (PrintSettingInfo)printSettingInfoMap.get(formId);
            List<DynamicObject> value = entry.getValue();
            ArrayList<PrintTplInfo> tplInfos = new ArrayList<PrintTplInfo>(value.size());
            for (DynamicObject dy3 : value) {
                Object billId = dy3.get("billid");
                List printTplInfos = (List)allBillTplInfo.get((Long)billId);
                PrintTplInfo tplInfo = (PrintTplInfo)printTplInfos.get(0);
                tplInfos.add(tplInfo);
            }
            Map<String, List<PrintTplInfo>> tplMap = tplInfos.stream().collect(Collectors.groupingBy(PrintTplInfo::getTplId));
            Map collect = tplInfos.stream().collect(Collectors.groupingBy(PrintTplInfo::getTplId, Collectors.mapping(PrintTplInfo::getBillId, Collectors.toList())));
            for (Map.Entry tplEntry : collect.entrySet()) {
                String pdfURL = BillPrintServiceHelper.getPrintPreviewURL((PrintSettingInfo)printSettingInfo, (PrintTplInfo)tplMap.get(tplEntry.getKey()).get(0), (String)formId, collect.get(tplEntry.getKey()), (IFormView)this.view);
                pdfURLs.add(pdfURL);
            }
        }
        MyBillPrintingProcess.setPDFURL(this.taskId, pdfURLs);
    }

    public static Set<String> getPDFURL(String taskId) {
        String pdfUrlsStr = (String)CACHE.get(MyBillPrintingProcess.buildCacheType(taskId), "pdfUrls");
        if (StringUtils.isBlank((CharSequence)pdfUrlsStr)) {
            return null;
        }
        return (Set)SerializationUtils.fromJsonString((String)pdfUrlsStr, Set.class);
    }

    public static void setPDFURL(String taskId, Set<String> pdfURLs) {
        CACHE.put(MyBillPrintingProcess.buildCacheType(taskId), "pdfUrls", (Object)SerializationUtils.toJsonString(pdfURLs));
    }

    public static int getProgress(String taskId) {
        String progress = (String)CACHE.get(MyBillPrintingProcess.buildCacheType(taskId), "progress");
        return StringUtils.isBlank((CharSequence)progress) ? 0 : Integer.parseInt(progress);
    }

    public static void setProgress(String taskId, int progress) {
        CACHE.put(MyBillPrintingProcess.buildCacheType(taskId), "progress", (Object)String.valueOf(progress));
    }

    public static boolean isInterruption(String taskId) {
        String interruption = (String)CACHE.get(MyBillPrintingProcess.buildCacheType(taskId), "interruption");
        return !StringUtils.isBlank((CharSequence)interruption) && Boolean.parseBoolean(interruption);
    }

    public static void setInterruption(String taskId, boolean interruption) {
        CACHE.put(MyBillPrintingProcess.buildCacheType(taskId), "interruption", (Object)String.valueOf(interruption));
    }

    public static List<String> getNoTpl(String taskId) {
        String notpl = (String)CACHE.get(MyBillPrintingProcess.buildCacheType(taskId), "notpl");
        if (StringUtils.isBlank((CharSequence)notpl)) {
            return null;
        }
        return (List)SerializationUtils.fromJsonString((String)notpl, List.class);
    }

    public static void setNoTpl(String taskId, List<String> pdfURLs) {
        CACHE.put(MyBillPrintingProcess.buildCacheType(taskId), "notpl", (Object)SerializationUtils.toJsonString(pdfURLs));
    }

    private static String buildCacheType(String taskId) {
        return "MyBillPrintingProcess_" + taskId;
    }
}

