/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.dhc.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class DhcMyBillSyncExtBillNameUpdateServiceImpl
implements IUpgradeService {
    private Log logger = LogFactory.getLog(DhcMyBillSyncExtBillNameUpdateServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.logger.info("\u63a5\u5165\u5355\u636e\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            String sqlExe = "update t_dhc_billaccessed set faccessedbillnew = fnumber where faccessedbillnew = ' ';";
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sqlExe);
            this.logger.info("\u63a5\u5165\u5355\u636e\u6570\u636e\u5347\u7ea7\u7ed3\u675f");
            HashMap<String, String> entityMap = new HashMap<String, String>();
            String algoKey = this.getClass().getName();
            String sql = "select fnumber,faccessedbill from t_dhc_billaccessed where faccessedbill != ' '";
            try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
                for (Row row : dataSet) {
                    String fid = row.getString("fnumber");
                    String fdentityid = row.getString("faccessedbill");
                    entityMap.put(fdentityid, fid);
                }
            }
            this.logger.info("\u66f4\u65b0\u6211\u7684\u62a5\u8d26\u6570\u636e\uff0c\u65b0\u5b57\u6bb5\u8d4b\u503c\u5f00\u59cb");
            Long beginTime = System.currentTimeMillis();
            Long eachTime = 0L;
            Long eachDuration = 0L;
            int times = 0;
            ArrayList<Object[]> updateMyBillDataList = new ArrayList<Object[]>();
            String sql3 = "SELECT fid,fbill FROM t_dhc_mybilllist where fbill != ' ' and fbillnew = ' '";
            String updateSql3 = "update t_dhc_mybilllist set fbillnew = ? where fid = ?";
            try {
                DataSet dataSet1 = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql3);
                for (Row row : dataSet1) {
                    String fbill = row.getString("fbill");
                    Long fid = row.getLong("fid");
                    String entityId = (String)entityMap.get(fbill);
                    Object[] objects = new Object[2];
                    if (StringUtils.isEmpty((String)entityId)) {
                        entityId = MetadataDao.getNumberById((String)fbill);
                        entityMap.putIfAbsent(fbill, entityId);
                    }
                    objects[0] = entityId;
                    objects[1] = fid;
                    if (null != entityId) {
                        updateMyBillDataList.add(objects);
                    }
                    if (updateMyBillDataList.size() < 1000) continue;
                    this.logger.info("\u66f4\u65b0\u6211\u7684\u62a5\u8d26\u6570\u636e\uff0c\u65b0\u5b57\u6bb5\u8d4b\u503c\u5f00\u59cb\uff0c\u6279\u6b21\u53f7\uff1a" + ++times);
                    eachTime = System.currentTimeMillis();
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateSql3, updateMyBillDataList);
                    updateMyBillDataList.clear();
                    eachDuration = System.currentTimeMillis() - eachTime;
                    this.logger.info("\u66f4\u65b0\u6211\u7684\u62a5\u8d26\u6570\u636e\uff0c\u65b0\u5b57\u6bb5\u8d4b\u503c\u7ed3\u675f\uff0c\u6279\u6b21\u53f7\uff1a" + times + " \u8017\u65f6\uff1a" + eachDuration + " ms");
                }
                if (updateMyBillDataList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateSql3, updateMyBillDataList);
                }
            }
            catch (Exception ex) {
                this.logger.error("\u5347\u7ea7\u66f4\u65b0\u6211\u7684\u62a5\u8d26\u6570\u636e\u51fa\u9519\uff01" + ex.getMessage(), (Throwable)ex);
                result.setSuccess(false);
            }
            Long duration = System.currentTimeMillis() - beginTime;
            this.logger.info("\u66f4\u65b0\u6211\u7684\u62a5\u8d26\u6570\u636e\uff0c\u65b0\u5b57\u6bb5\u8d4b\u503c\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a" + duration + " ms");
            String sql1 = "select fbillid from t_dhc_billdatainit";
            String sql2 = "select fbillid from t_dhc_datainitrecord";
            String updateSql1 = "update t_dhc_billdatainit set fbillid = ? where fbillid = ?";
            String updateSql2 = "update t_dhc_datainitrecord set fbillid = ? where fbillid = ?";
            ArrayList<Object[]> initDataList = new ArrayList<Object[]>(16);
            ArrayList<Object[]> recordList = new ArrayList<Object[]>(16);
            try {
                DataSet dataSet1 = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql1);
                for (Row row : dataSet1) {
                    Object[] objects = new Object[2];
                    String fbillid = row.getString("fbillid");
                    String entityId = (String)entityMap.get(fbillid);
                    objects[0] = entityId;
                    objects[1] = fbillid;
                    if (null != entityId) {
                        initDataList.add(objects);
                    }
                    if (initDataList.size() < 1000) continue;
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateSql1, initDataList);
                    initDataList.clear();
                }
                if (initDataList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateSql1, initDataList);
                }
                DataSet dataSet2 = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql2);
                for (Row row : dataSet2) {
                    Object[] objects = new Object[2];
                    String fbillid = row.getString("fbillid");
                    String entityId = (String)entityMap.get(fbillid);
                    objects[0] = entityId;
                    objects[1] = fbillid;
                    if (null != entityId) {
                        recordList.add(objects);
                    }
                    if (recordList.size() < 1000) continue;
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateSql2, recordList);
                    recordList.clear();
                }
                if (recordList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateSql2, recordList);
                }
            }
            catch (Exception ex) {
                this.logger.error("\u5347\u7ea7\u66f4\u65b0\u62a5\u8d26\u521d\u59cb\u5316\u4fe1\u606f\u6570\u636e\u51fa\u9519\uff01" + ex.getMessage(), (Throwable)ex);
                result.setSuccess(false);
            }
            this.logger.info("\u6211\u7684\u62a5\u8d26\u6570\u636e\u5347\u7ea7\u6210\u529f");
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }
}

