/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.basedata.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class FillOrgBuilder {
    public static final Log logger = LogFactory.getLog(FillOrgBuilder.class);
    private final Set<Long> permAcountingOrgs = new TreeSet<Long>();
    private final List<Long> fillpermAcountingOrgs;

    public FillOrgBuilder(Collection<Long> selectOrgIds) {
        this.permAcountingOrgs.addAll(selectOrgIds);
        this.fillpermAcountingOrgs = new ArrayList<Long>();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("10");
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        rootNode.setChildren(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param));
        this.recursiveOrgTree(Collections.singletonList(rootNode), 0, false);
    }

    private void recursiveOrgTree(List<TreeNode> treeChildren, int level, boolean next) {
        for (TreeNode treeChild : treeChildren) {
            List childrens;
            boolean contains = this.permAcountingOrgs.contains(Long.valueOf(treeChild.getId()));
            if (contains || next) {
                logger.info("\u6709\u6743\u9650 - \u5305\u542b\u6216\u8005\u4e0b\u7ea7" + treeChild);
                this.fillpermAcountingOrgs.add(Long.valueOf(treeChild.getId()));
                childrens = treeChild.getChildren();
                if (childrens == null) continue;
                this.recursiveOrgTree(childrens, level + 1, true);
                continue;
            }
            childrens = treeChild.getChildren();
            if (childrens == null) continue;
            this.recursiveOrgTree(childrens, level + 1, false);
        }
    }

    public List<Long> getFillpermAcountingOrgs() {
        return this.fillpermAcountingOrgs;
    }
}

