/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.basedata.org;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.mobile.basedata.org.OrgTreeNode;

public class OrgNodeBuilder {
    public static final Log logger = LogFactory.getLog(OrgNodeBuilder.class);
    private final OrgTreeNode topNode;
    private final Set<Long> permAcountingOrgs = new TreeSet<Long>();
    private final Map<String, OrgTreeNode> treeMap = new HashMap<String, OrgTreeNode>();
    private int minLevel = 10;

    public OrgNodeBuilder(Collection<Long> selectOrgIds) {
        this.topNode = new OrgTreeNode();
        this.permAcountingOrgs.addAll(selectOrgIds);
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("10");
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        rootNode.setChildren(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param));
        this.recursiveOrgTree(this.topNode, Collections.singletonList(rootNode), 0, false);
        logger.info(this.topNode.toString());
        TreeSet<OrgTreeNode> objects = new TreeSet<OrgTreeNode>(this.topNode.getChildren());
        this.topNode.getChildren().clear();
        this.shrinkOrgTree(objects);
        logger.info(this.topNode.toString());
    }

    public OrgTreeNode getTopNode() {
        return this.topNode;
    }

    private void shrinkOrgTree(Set<OrgTreeNode> nextList) {
        for (OrgTreeNode node : nextList) {
            if (node.getLevel() == this.minLevel) {
                this.topNode.getChildren().add(node);
                continue;
            }
            this.shrinkOrgTree(node.getChildren());
        }
    }

    private boolean recursiveOrgTree(OrgTreeNode orgTreeNode, List<TreeNode> treeChildren, int level, boolean next) {
        boolean have = false;
        for (TreeNode treeChild : treeChildren) {
            OrgTreeNode node;
            boolean haveNext;
            boolean contains = this.permAcountingOrgs.contains(Long.valueOf(treeChild.getId()));
            if (contains || next) {
                List children;
                OrgTreeNode node2;
                if (contains) {
                    if (level < this.minLevel) {
                        this.minLevel = level;
                    }
                    logger.info("\u6709\u6743\u9650 - (\u771f)" + treeChild);
                    node2 = this.getOrgTreeNode(orgTreeNode, treeChild, level, true, next);
                    children = treeChild.getChildren();
                    if (children != null) {
                        this.recursiveOrgTree(node2, children, level + 1, true);
                    }
                } else {
                    logger.info("\u6709\u6743\u9650 - (\u8865\u4e0b\u7ea7)" + treeChild);
                    node2 = this.getOrgTreeNode(orgTreeNode, treeChild, level, false, true);
                    children = treeChild.getChildren();
                    if (children != null) {
                        this.recursiveOrgTree(node2, children, level + 1, true);
                    }
                }
                have = true;
                continue;
            }
            List children = treeChild.getChildren();
            if (children == null || !(haveNext = this.recursiveOrgTree(node = this.getOrgTreeNode(null, treeChild, level, false, false), children, level + 1, false))) continue;
            this.treeMap.put(node.getId(), node);
            orgTreeNode.getChildren().add(node);
            have = true;
        }
        return have;
    }

    private OrgTreeNode getOrgTreeNode(OrgTreeNode pNode, TreeNode treeChild, int level, boolean selfPerm, boolean extendsPerm) {
        OrgTreeNode node;
        if (!this.treeMap.containsKey(treeChild.getId())) {
            node = new OrgTreeNode();
            node.setId(treeChild.getId());
            node.setText(treeChild.getText());
            node.setParentid(treeChild.getParentid());
            node.setSelfPerm(selfPerm);
            node.setExtendsPerm(extendsPerm);
            node.setIsvirtual(pNode == null);
            node.setLevel(level);
            if (pNode != null) {
                pNode.getChildren().add(node);
                this.treeMap.put(node.getId(), node);
            }
        } else {
            node = this.treeMap.get(treeChild.getId());
        }
        return node;
    }
}

