/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.basedata.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.mobile.basedata.IDynamicNode;
import kd.fi.er.mobile.basedata.org.OrgGroup;

public class OrgTreeNode
implements Comparable<OrgTreeNode>,
IDynamicNode {
    private String id = "0";
    private String text = ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"OrgTreeNode_0", (String)"fi-er-mb-business", (Object[])new Object[0]);
    private String parentid = "";
    private Object data;
    protected Set<OrgTreeNode> children = new TreeSet<OrgTreeNode>();
    private boolean selfPerm = true;
    private boolean extendsPerm = true;
    private boolean isvirtual = false;
    private int level;

    public Collection<Long> containOrgIds() {
        HashSet<Long> set = new HashSet<Long>();
        this.iterate(10, node -> {
            if (node.hasPerm()) {
                set.add(Long.valueOf(node.id));
            }
        });
        return set;
    }

    public Collection<Long> childOrgIds() {
        Collection<Long> longs = this.containOrgIds();
        longs.remove(Long.valueOf(this.id));
        return longs;
    }

    public void iterate(int maxLevel, Consumer<OrgTreeNode> callback) {
        callback.accept(this);
        if (maxLevel > 0 && this.getChildren() != null) {
            for (OrgTreeNode child : this.getChildren()) {
                child.iterate(maxLevel - 1, callback);
            }
        }
    }

    public OrgTreeNode getNodeById(Long id) {
        if (id == null || id == Long.parseLong(this.id)) {
            return this;
        }
        Set<OrgTreeNode> children = this.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return null;
        }
        for (OrgTreeNode child : children) {
            OrgTreeNode nodeById = child.getNodeById(id);
            if (nodeById == null) continue;
            return nodeById;
        }
        return null;
    }

    public boolean hasPerm() {
        return this.isSelfPerm() || this.isExtendsPerm();
    }

    public boolean isSelfPerm() {
        return this.selfPerm;
    }

    public boolean isExtendsPerm() {
        return this.extendsPerm;
    }

    public void setExtendsPerm(boolean extendsPerm) {
        this.extendsPerm = extendsPerm;
    }

    public void setSelfPerm(boolean selfPerm) {
        this.selfPerm = selfPerm;
    }

    public boolean isIsvirtual() {
        return this.isvirtual;
    }

    public void setIsvirtual(boolean isvirtual) {
        this.isvirtual = isvirtual;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentid() {
        return this.parentid;
    }

    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Set<OrgTreeNode> getChildren() {
        return this.children;
    }

    public List<OrgTreeNode> getChildrenList() {
        return new ArrayList<OrgTreeNode>(this.getChildren());
    }

    @Override
    public int compareTo(OrgTreeNode o) {
        return this.getId().compareTo(o.getId());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public List<? extends IDynamicNode> nextList() {
        return this.getChildrenList();
    }

    public HashMap<Long, OrgGroup> groupingMap() {
        HashMap<Long, OrgGroup> llMap = new HashMap<Long, OrgGroup>();
        for (OrgTreeNode next : this.children) {
            Collection<Long> longs = next.containOrgIds();
            for (Long aLong : longs) {
                llMap.put(aLong, new OrgGroup(Long.valueOf(next.id), next.getChildren().isEmpty()));
            }
        }
        return llMap;
    }
}

