/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.basedata.project;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.basedata.project.ProjectTreeNode;

public class ProjectNodeBuilder {
    public static final Log logger = LogFactory.getLog(ProjectNodeBuilder.class);
    private final ProjectTreeNode topNode = new ProjectTreeNode();
    private final Set<Long> selectedProjectIds = new HashSet<Long>();
    private final Map<Long, ProjectTreeNode> permProjectMap = new HashMap<Long, ProjectTreeNode>();

    public ProjectNodeBuilder(Set<Long> selectProjectIds, String entityName) {
        DynamicObjectCollection allProjects = this.getProjectDataSet(entityName);
        if (allProjects == null) {
            return;
        }
        if (selectProjectIds == null) {
            selectProjectIds = allProjects.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        }
        this.selectedProjectIds.addAll(selectProjectIds);
        HashMap<Long, DynamicObject> allProjectsGroupedById = new HashMap<Long, DynamicObject>();
        allProjects.forEach(dy -> allProjectsGroupedById.put(dy.getLong("id"), (DynamicObject)dy));
        Map<Integer, List<DynamicObject>> allProjectsGroupedByLevel = allProjects.stream().collect(Collectors.groupingBy(dy -> dy.getInt("level")));
        for (Map.Entry<Integer, List<DynamicObject>> integerListEntry : allProjectsGroupedByLevel.entrySet()) {
            logger.info("\u7b2c" + integerListEntry.getKey() + "\u5c42\u8282\u70b9", integerListEntry.getValue().stream().map(dy -> dy.getString("name") + "----" + dy.getLong("id")).collect(Collectors.toList()));
        }
        List<DynamicObject> selectedProjects = allProjects.stream().filter(dy -> this.selectedProjectIds.contains(dy.getLong("id"))).collect(Collectors.toList());
        int minLevel = selectedProjects.stream().map(dy -> dy.getInt("level")).min(Integer::compareTo).orElseGet(() -> 1);
        int maxLevel = allProjects.stream().map(dy -> dy.getInt("level")).max(Integer::compareTo).orElseGet(() -> 1);
        Set<Long> minLevelProjectIds = this.getTopProjectNodeIds(selectedProjects, minLevel, allProjectsGroupedById);
        this.buildFirstLevelProjectNode(minLevelProjectIds, allProjectsGroupedById);
        this.buildNextLevelProjectNode(minLevel, maxLevel, allProjectsGroupedByLevel);
    }

    private void buildNextLevelProjectNode(int minLevel, int maxLevel, Map<Integer, List<DynamicObject>> allProjectsGroupedByLevel) {
        Set<ProjectTreeNode> parentLevelProjects = this.topNode.getChildren();
        for (int i = minLevel + 1; i <= maxLevel; ++i) {
            List<DynamicObject> allCurrentLevelProjects = allProjectsGroupedByLevel.get(i);
            HashSet<ProjectTreeNode> currentLevelProjects = new HashSet<ProjectTreeNode>(allCurrentLevelProjects.size());
            for (DynamicObject currentLevelProject : allCurrentLevelProjects) {
                ProjectTreeNode parentNode = parentLevelProjects.stream().filter(node -> currentLevelProject.getLong("parent") == node.getId().longValue()).findFirst().orElseGet(() -> null);
                if (parentNode == null) continue;
                ProjectTreeNode projectTreeNode = this.selectedProjectIds.contains(currentLevelProject.getLong("id")) ? this.getNode(currentLevelProject, currentLevelProject.getLong("parent"), true, false, false) : (parentNode.hasPerm() ? this.getNode(currentLevelProject, currentLevelProject.getLong("parent"), false, true, false) : this.getNode(currentLevelProject, currentLevelProject.getLong("parent"), false, false, true));
                parentNode.getChildren().add(projectTreeNode);
                currentLevelProjects.add(projectTreeNode);
            }
            parentLevelProjects = currentLevelProjects;
        }
    }

    private void buildFirstLevelProjectNode(Set<Long> minLevelProjectIds, HashMap<Long, DynamicObject> allProjectsGroupedById) {
        for (Long minLevelProjectId : minLevelProjectIds) {
            DynamicObject dynamicObject = allProjectsGroupedById.get(minLevelProjectId);
            ProjectTreeNode projectTreeNode = this.selectedProjectIds.contains(minLevelProjectId) ? this.getNode(dynamicObject, -1L, true, false, false) : this.getNode(dynamicObject, -1L, false, false, true);
            this.topNode.getChildren().add(projectTreeNode);
        }
    }

    private Set<Long> getTopProjectNodeIds(List<DynamicObject> selectedProjects, int minLevel, HashMap<Long, DynamicObject> allProjectsGroupedById) {
        HashSet<Long> minLevelProjectIds = new HashSet<Long>();
        for (DynamicObject project : selectedProjects) {
            int level = project.getInt("level");
            if (level == minLevel) {
                minLevelProjectIds.add(project.getLong("id"));
                continue;
            }
            if (level <= minLevel) continue;
            while (level > minLevel && (project = allProjectsGroupedById.get(project.getLong("parent"))) != null) {
                level = project.getInt("level");
            }
            if (project == null) continue;
            minLevelProjectIds.add(project.getLong("id"));
        }
        return minLevelProjectIds;
    }

    public ProjectTreeNode getTopNode() {
        return this.topNode;
    }

    public Set<Long> getSelectedProjectIds() {
        return this.selectedProjectIds;
    }

    public Map<Long, ProjectTreeNode> getPermProjectMap() {
        return this.permProjectMap;
    }

    private DynamicObjectCollection getProjectDataSet(String entityName) {
        DynamicObjectCollection dynamicObjects;
        switch (entityName) {
            case "expenseProject": {
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                dynamicObjects = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id,name,level,parent", (QFilter[])new QFilter[]{statusFilter, enableFilter});
                break;
            }
            case "project": {
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                dynamicObjects = QueryServiceHelper.query((String)"bd_project", (String)"id,name,level,parent", (QFilter[])new QFilter[]{statusFilter, enableFilter});
                break;
            }
            default: {
                dynamicObjects = null;
            }
        }
        return dynamicObjects;
    }

    private ProjectTreeNode getNode(DynamicObject dynamicObject, Long parentId, boolean selfPerm, boolean extendsPerm, boolean isVirtual) {
        ProjectTreeNode projectTreeNode = new ProjectTreeNode();
        projectTreeNode.setId(dynamicObject.getLong("id"));
        projectTreeNode.setName(dynamicObject.getString("name"));
        projectTreeNode.setLevel(dynamicObject.getInt("level"));
        projectTreeNode.setParentid(parentId);
        projectTreeNode.setSelfPerm(selfPerm);
        projectTreeNode.setExtendsPerm(extendsPerm);
        projectTreeNode.setIsvirtual(isVirtual);
        return projectTreeNode;
    }
}

