/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.basedata.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.mobile.basedata.IDynamicNode;
import kd.fi.er.mobile.basedata.org.OrgGroup;

public class ProjectTreeNode
implements Comparable<ProjectTreeNode>,
IDynamicNode {
    private Long id = 0L;
    private String name = ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"ProjectTreeNode_0", (String)"bos-entity-core", (Object[])new Object[0]);
    private Long parentid = 0L;
    private int level;
    private Object data;
    protected Set<ProjectTreeNode> children = new TreeSet<ProjectTreeNode>();
    private boolean selfPerm = true;
    private boolean extendsPerm = true;
    private boolean isVirtual = false;

    @Override
    public int compareTo(ProjectTreeNode o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public List<? extends IDynamicNode> nextList() {
        return new ArrayList<ProjectTreeNode>(this.getChildren());
    }

    public boolean hasPerm() {
        return this.isSelfPerm() || this.isExtendsPerm();
    }

    public Set<Long> getPermissionProjectIds() {
        HashSet<Long> permissionIds = new HashSet<Long>();
        if (this.getId() == 0L) {
            this.recursiveNodeTree(this.getChildren(), permissionIds);
        } else {
            this.recursiveNodeTree(Collections.singleton(this), permissionIds);
        }
        return permissionIds;
    }

    private void recursiveNodeTree(Set<ProjectTreeNode> treeChildren, Set<Long> permissionIds) {
        for (ProjectTreeNode projectTreeNode : treeChildren) {
            Set<ProjectTreeNode> children;
            if (projectTreeNode.hasPerm()) {
                permissionIds.add(projectTreeNode.getId());
            }
            if ((children = projectTreeNode.getChildren()) == null) continue;
            this.recursiveNodeTree(children, permissionIds);
        }
    }

    public ProjectTreeNode getNodeById(Long id) {
        if (id == null || id.equals(this.id)) {
            return this;
        }
        Set<ProjectTreeNode> children = this.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return null;
        }
        for (ProjectTreeNode child : children) {
            ProjectTreeNode nodeById = child.getNodeById(id);
            if (nodeById == null) continue;
            return nodeById;
        }
        return null;
    }

    public HashMap<Long, OrgGroup> groupingMap() {
        HashMap<Long, OrgGroup> llMap = new HashMap<Long, OrgGroup>();
        for (ProjectTreeNode next : this.children) {
            Set<Long> longs = next.getPermissionProjectIds();
            for (Long aLong : longs) {
                llMap.put(aLong, new OrgGroup(next.id, next.getChildren().isEmpty()));
            }
        }
        return llMap;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getParentid() {
        return this.parentid;
    }

    public void setParentid(Long parentid) {
        this.parentid = parentid;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Set<ProjectTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(Set<ProjectTreeNode> children) {
        this.children = children;
    }

    public boolean isSelfPerm() {
        return this.selfPerm;
    }

    public void setSelfPerm(boolean selfPerm) {
        this.selfPerm = selfPerm;
    }

    public boolean isExtendsPerm() {
        return this.extendsPerm;
    }

    public void setExtendsPerm(boolean extendsPerm) {
        this.extendsPerm = extendsPerm;
    }

    public boolean isIsVirtual() {
        return this.isVirtual;
    }

    public void setIsvirtual(boolean isvirtual) {
        this.isVirtual = isvirtual;
    }
}

