/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Format;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.er.mobile.common.AmountConvert;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.dto.AmountConvertDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.enums.UnitEnum;
import kd.fi.er.mobile.exception.ErMobiErrorCodeBox;
import kd.fi.er.mobile.exception.ErMobiNoExchangeRateException;
import kd.fi.er.mobile.service.my.UserSettingDAO;

public class AmountHandler
implements AmountConvert {
    public static final Log logger = LogFactory.getLog(AmountHandler.class);
    private static final String ENTITY_BD_CURRENCY = "bd_currency";
    private static final String ENTITY_BD_EXRATETABLE = "bd_exratetable";
    private static final RoundingMode roundingMode = RoundingMode.HALF_UP;
    private static final Integer DEFAULT_AMOUNT_PRECISION = 2;
    private DynamicObject currency = null;
    private DynamicObject exratetable = null;
    private UnitEnum unitEnum = UnitEnum.SYSTEM_ADAPTATION;
    private final Map<Long, BigDecimal> exRateCache = new HashMap<Long, BigDecimal>();
    private Format format;

    private AmountHandler() {
    }

    public static AmountHandler getAmountHandler() {
        AmountHandler handler = new AmountHandler();
        handler.init();
        return handler;
    }

    private void init() {
        AmountConvertDTO convertDTO = AmountHelper.getCacheAmountConvert();
        if (convertDTO == null) {
            DynamicObject dynamicObject = UserSettingDAO.getCurrUserSetting();
            this.setProperties(dynamicObject.getDynamicObject("currency"), dynamicObject.getDynamicObject("exratetable"), dynamicObject.getString("unit"));
        } else {
            this.setProperties(BusinessDataServiceHelper.loadSingleFromCache((Object)convertDTO.getCurrencyId(), (String)ENTITY_BD_CURRENCY), BusinessDataServiceHelper.loadSingleFromCache((Object)convertDTO.getExratetableId(), (String)ENTITY_BD_EXRATETABLE), convertDTO.getUnit());
        }
        long userId = RequestContext.get().getCurrUserId();
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)userId);
        String sign = this.currency.getString("sign");
        fobj.getCurrencyFormat().setCurrencySymbols(sign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(this.getAmtPrecision());
        this.format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
    }

    public void setUnitEnum(UnitEnum unitEnum) {
        this.unitEnum = unitEnum;
    }

    private void setProperties(DynamicObject currency, DynamicObject exratetable, String unit) {
        this.currency = currency;
        this.exratetable = exratetable;
        this.unitEnum = UnitEnum.get(unit);
    }

    public DynamicObject getCurrency() {
        return this.currency;
    }

    public DynamicObject getExratetable() {
        return this.exratetable;
    }

    public UnitEnum getUnitEnum() {
        return this.unitEnum;
    }

    public int getAmtPrecision() {
        return DEFAULT_AMOUNT_PRECISION;
    }

    public BigDecimal convertByCurrency(long srcCurrencyId, BigDecimal amount) {
        BigDecimal exchangeRate = this.exRateCache.get(srcCurrencyId);
        if (exchangeRate == null) {
            exchangeRate = this.getExchangeRate(srcCurrencyId, this.currency.getLong("id"), this.exratetable.getLong("id"));
            this.exRateCache.put(srcCurrencyId, exchangeRate);
        }
        return amount.multiply(exchangeRate);
    }

    private BigDecimal getExchangeRate(long sourceCurrencyId, long targetCurrencyId, long exchangeRateTableId) {
        if (sourceCurrencyId == targetCurrencyId) {
            return BigDecimal.ONE;
        }
        Date date = new Date();
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        if (exchangeRate != null) {
            return exchangeRate;
        }
        ErMobiNoExchangeRateException ex = new ErMobiNoExchangeRateException(ErMobiErrorCodeBox.NO_EXCHANGE_RATE, new Object[0]);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceCurrencyId, (String)ENTITY_BD_CURRENCY);
        if (dynamicObject != null) {
            ex.setAbsentCurrencies(Collections.singletonList(dynamicObject.getString("name")));
        } else {
            ex.setAbsentCurrencies(Collections.singletonList(sourceCurrencyId + ""));
        }
        logger.info("throw NO_EXCHANGE_RATE Exception: " + ex.getMessage());
        throw ex;
    }

    public BigDecimal convertByUnit(BigDecimal amount) {
        if (this.unitEnum == UnitEnum.SYSTEM_ADAPTATION) {
            return this.convertBySystemAdaptation(amount);
        }
        return amount.divide(this.unitEnum.getScale(), this.getAmtPrecision(), roundingMode);
    }

    private BigDecimal convertBySystemAdaptation(BigDecimal amount) {
        if (amount.compareTo(new BigDecimal("10000")) < 0) {
            return amount.divide(UnitEnum.YUAN.getScale(), this.getAmtPrecision(), roundingMode);
        }
        if (amount.compareTo(new BigDecimal("100000000")) < 0) {
            return amount.divide(UnitEnum.TEN_THOUSAND.getScale(), this.getAmtPrecision(), roundingMode);
        }
        return amount.divide(UnitEnum.HUNDRED_MILLION.getScale(), this.getAmtPrecision(), roundingMode);
    }

    public String formatAmount(BigDecimal amount) {
        BigDecimal value = this.convertByUnit(amount);
        return this.format.format(value);
    }

    public UnitEnum getUnitEnum(BigDecimal amount) {
        if (UnitEnum.SYSTEM_ADAPTATION.name().equals(this.unitEnum.name())) {
            if (amount.compareTo(new BigDecimal("10000")) < 0) {
                return UnitEnum.YUAN;
            }
            if (amount.compareTo(new BigDecimal("100000000")) < 0) {
                return UnitEnum.TEN_THOUSAND;
            }
            return UnitEnum.HUNDRED_MILLION;
        }
        return this.unitEnum;
    }

    public UnitEnum getUnitEnum(double amount) {
        if (UnitEnum.SYSTEM_ADAPTATION.name().equals(this.unitEnum.name())) {
            if (amount < 10000.0) {
                return UnitEnum.YUAN;
            }
            if (amount < 1.0E8) {
                return UnitEnum.TEN_THOUSAND;
            }
            return UnitEnum.HUNDRED_MILLION;
        }
        return this.unitEnum;
    }

    public SignAmount getSignAmount(long currency, BigDecimal targetAmount) {
        return this.getSignAmount(this.convertByCurrency(currency, targetAmount));
    }

    public SignAmount getSignAmount(BigDecimal targetAmount) {
        SignAmount signAmount = new SignAmount();
        signAmount.setValue(targetAmount);
        signAmount.setUnit(this.getUnitEnum(targetAmount).getDesc());
        signAmount.setSign(this.formatAmount(targetAmount));
        return signAmount;
    }

    public SignAmount getSignAmount(double amount) {
        return this.getSignAmount(BigDecimal.valueOf(amount));
    }

    public AmountConvertDTO getConvertDTO() {
        AmountConvertDTO dto = new AmountConvertDTO();
        dto.setCurrencyId(this.currency.getLong("id"));
        dto.setExratetableId(this.exratetable.getLong("id"));
        dto.setUnit(this.unitEnum.getValue());
        return dto;
    }
}

