/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.common;

import java.math.BigDecimal;
import kd.bos.cache.ThreadCache;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.dto.AmountConvertDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.enums.UnitEnum;

public class AmountHelper {
    private static final ThreadLocal<AmountHandler> current = new ThreadLocal();

    public static AmountHandler get() {
        AmountHandler handler = current.get();
        if (handler == null) {
            handler = AmountHandler.getAmountHandler();
            current.set(handler);
        }
        return handler;
    }

    public static AmountHandler get(AmountConvertDTO convertDTO) {
        AmountHelper.cacheAmountConvert(convertDTO);
        return AmountHelper.get();
    }

    public static AmountConvertDTO getConvertDTO() {
        return AmountHelper.get().getConvertDTO();
    }

    public static void cacheAmountConvert(AmountConvertDTO convertDTO) {
        if (convertDTO != null) {
            ThreadCache.put((Object)"amountconvertdto", (Object)convertDTO);
        }
    }

    public static AmountConvertDTO getCacheAmountConvert() {
        return (AmountConvertDTO)ThreadCache.get((Object)"amountconvertdto", () -> null, (boolean)false);
    }

    public static BigDecimal convertByCurrency(long srcCurrencyId, BigDecimal amount) {
        return AmountHelper.get().convertByCurrency(srcCurrencyId, amount);
    }

    public static int getAmtPrecision() {
        return AmountHelper.get().getAmtPrecision();
    }

    public static String unit(BigDecimal amount) {
        return AmountHelper.get().getUnitEnum(amount).getDesc();
    }

    public static UnitEnum handleUnitEnum(BigDecimal amount) {
        UnitEnum unitEnum = AmountHelper.get().getUnitEnum(amount);
        if (unitEnum == UnitEnum.YUAN) {
            return null;
        }
        return unitEnum;
    }

    public static SignAmount getSignAmount(double amount) {
        return AmountHelper.getSignAmount(BigDecimal.valueOf(amount));
    }

    public static SignAmount getSignAmount(Long currency, double amount) {
        return AmountHelper.getSignAmount(currency, BigDecimal.valueOf(amount));
    }

    public static String text(BigDecimal amount) {
        if (amount == null) {
            return "-";
        }
        AmountHandler amountHandler = AmountHelper.get();
        UnitEnum unitEnum = AmountHelper.handleUnitEnum(amount);
        String unitStr = "";
        if (unitEnum != null) {
            unitStr = unitEnum.getDesc();
        }
        return amountHandler.formatAmount(amount) + unitStr;
    }

    public static SignAmount getSignAmount(BigDecimal targetAmount) {
        return AmountHelper.get().getSignAmount(targetAmount);
    }

    public static SignAmount getSignAmount(Long currency, BigDecimal srcAmount) {
        SignAmount signAmount = new SignAmount();
        signAmount.setSrcCurrency(currency);
        signAmount.setSrcValue(srcAmount);
        AmountHandler handler = AmountHelper.get();
        BigDecimal targetAmount = handler.convertByCurrency(currency, srcAmount);
        signAmount.setValue(targetAmount);
        UnitEnum unitEnum = handler.getUnitEnum(targetAmount);
        signAmount.setUnit(unitEnum.getDesc());
        signAmount.setSign(handler.formatAmount(targetAmount));
        return signAmount;
    }

    public static UnitEnum getUnitEnum(BigDecimal amount) {
        return AmountHelper.get().getUnitEnum(amount);
    }

    public static SignAmount getZeroSignAmount() {
        return AmountHelper.get().getSignAmount(BigDecimal.ZERO);
    }
}

