/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.common;

import java.util.Collections;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterReader;
import kd.fi.er.mobile.common.UserShareLogDao;
import kd.fi.er.mobile.service.my.UserSettingDAO;
import kd.fi.er.mobile.util.JsonUtils;

public class UserParameterHelper {
    public static final String EM_M_USER_CUSTOM_CARDS = "EM_M_USER_CUSTOM_CARDS";

    public static void saveCustomCard(String cardStrs) {
        long userId = RequestContext.get().getCurrUserId();
        ParameterHelper.saveUserCustParameter((long)userId, (String)"em_m_index", (String)EM_M_USER_CUSTOM_CARDS, (String)cardStrs);
        UserParameterHelper.removeThreadCache(userId, "em_m_index", EM_M_USER_CUSTOM_CARDS);
    }

    public static void removeThreadCache(Long userId, String formId, String paramKey) {
        String type = String.format("%s.%s", CacheKeyUtil.getAcctId(), "CUST_PARAMETER");
        String cacheKey = String.format("%s,%s,%s", userId, formId, paramKey);
        ThreadCache.remove((Object)(type + "." + cacheKey));
    }

    public static String getCustomCard() {
        long userId = RequestContext.get().getCurrUserId();
        String cacheValue = ParameterCache.getCustParamFromCache((Long)userId, (String)"em_m_index", (String)EM_M_USER_CUSTOM_CARDS);
        if (cacheValue == null) {
            cacheValue = ParameterReader.getUserCustParameter((Long)userId, (String)"em_m_index", (String)EM_M_USER_CUSTOM_CARDS);
            if (cacheValue == null) {
                return null;
            }
            ParameterCache.putCustParamToCache((Long)userId, (String)"em_m_index", (String)EM_M_USER_CUSTOM_CARDS, (String)cacheValue);
        }
        return cacheValue;
    }

    public static List<Long> getCacheFilterOrgIds() {
        long userId = RequestContext.get().getCurrUserId();
        String formId = "em_m_share_card_m";
        String paramKey = "em_m_filter_orgids";
        String cacheValue = ParameterCache.getCustParamFromCache((Long)userId, (String)formId, (String)paramKey);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            cacheValue = UserShareLogDao.getUserFilter();
            if (StringUtils.isBlank((CharSequence)cacheValue)) {
                return Collections.emptyList();
            }
            ParameterCache.putCustParamToCache((Long)userId, (String)formId, (String)paramKey, (String)cacheValue);
        }
        return JsonUtils.fromJsonToList(cacheValue, Long.class);
    }

    public static void putFilterOrgIdsToCache(List<Long> filterIds) {
        String json = JsonUtils.toJson(filterIds);
        UserShareLogDao.saveUserFilter(json);
        long userId = RequestContext.get().getCurrUserId();
        String formId = "em_m_share_card_m";
        String paramKey = "em_m_filter_orgids";
        ParameterCache.putCustParamToCache((Long)userId, (String)formId, (String)paramKey, (String)json);
    }

    public static Integer getDueDate() {
        String dueDate = UserSettingDAO.getKeyValue("duedate");
        if (StringUtils.isBlank((CharSequence)dueDate)) {
            dueDate = "10";
        }
        return Integer.parseInt(dueDate);
    }

    public static void setDueDate(Integer dueDate) {
        UserSettingDAO.saveKeyValue("duedate", dueDate.toString());
    }
}

