/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.datarange;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import kd.bos.exception.KDBizException;
import kd.fi.er.mobile.common.MultiLangEnumBridge;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.IDateRange;

public enum DateRangeEnum {
    TODAY("today", new MultiLangEnumBridge("\u4eca\u65e5", "DateRangeEnum_0", "fi-er-mb-business")),
    CURRENT_WEEK("current_week", new MultiLangEnumBridge("\u672c\u5468", "DateRangeEnum_1", "fi-er-mb-business")),
    CURRENT_MONTH("current_month", new MultiLangEnumBridge("\u672c\u6708", "DateRangeEnum_2", "fi-er-mb-business")),
    CURRENT_YEAR("current_year", new MultiLangEnumBridge("\u672c\u5e74", "DateRangeEnum_3", "fi-er-mb-business")),
    PREVIOUS_MONTH("previous_month", new MultiLangEnumBridge("\u4e0a\u6708", "DateRangeEnum_4", "fi-er-mb-business")),
    PREVIOUS_YEAR("previous_year", new MultiLangEnumBridge("\u53bb\u5e74", "DateRangeEnum_5", "fi-er-mb-business")),
    UNLIMIT("unlimit", new MultiLangEnumBridge("\u4e0d\u9650", "DateRangeEnum_6", "fi-er-mb-business")),
    CUSTOM("custom", new MultiLangEnumBridge("\u81ea\u5b9a\u4e49", "DateRangeEnum_7", "fi-er-mb-business"));

    private final String number;
    private final MultiLangEnumBridge name;

    private DateRangeEnum(String number, MultiLangEnumBridge name) {
        this.number = number;
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public static DateRangeEnum getEnumByNumber(String number) {
        for (DateRangeEnum rangeEnum : DateRangeEnum.values()) {
            if (!rangeEnum.getNumber().equals(number)) continue;
            return rangeEnum;
        }
        throw new KDBizException("not exsit BaseDataEnum by " + number);
    }

    public DateRange toDateRange() {
        DateRange dateRange = new DateRange(this.getNumber());
        return DateRangeEnum.fillDateRange(dateRange);
    }

    public static DateRange fillDateRange(IDateRange dateRange) {
        LocalDate endDate;
        LocalDate startDate;
        String spanType = dateRange.getSpanType();
        String spanDesc = DateRangeEnum.getEnumByNumber(dateRange.getSpanType()).getName();
        switch (dateRange.getSpanType()) {
            case "today": {
                startDate = LocalDate.now();
                endDate = LocalDate.now();
                break;
            }
            case "current_week": {
                startDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                endDate = LocalDate.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
                break;
            }
            case "current_month": {
                startDate = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                endDate = LocalDate.now().with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case "current_year": {
                startDate = LocalDate.now().with(TemporalAdjusters.firstDayOfYear());
                endDate = LocalDate.now().with(TemporalAdjusters.lastDayOfYear());
                break;
            }
            case "previous_month": {
                startDate = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
                endDate = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case "previous_year": {
                startDate = LocalDate.now().minusYears(1L).with(TemporalAdjusters.firstDayOfYear());
                endDate = LocalDate.now().minusYears(1L).with(TemporalAdjusters.lastDayOfYear());
                break;
            }
            case "unlimit": {
                startDate = null;
                endDate = null;
                break;
            }
            default: {
                startDate = dateRange.getStartDate();
                endDate = dateRange.getEndDate();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy.MM.dd");
                spanDesc = startDate.format(formatter) + "~" + endDate.format(formatter);
            }
        }
        return new DateRange(spanType, spanDesc, startDate, endDate);
    }
}

