/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.datarange;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.fi.er.mobile.util.CommonUtils;

public class DateRangeUtils {
    public static DataSet filterDataSet(DataSet dataSet, String property, LocalDate startDate, LocalDate endDate) {
        if (startDate != null || endDate != null) {
            Map<String, Object> dateRange = DateRangeUtils.createDateRangeMap(startDate, endDate);
            if (endDate == null) {
                return dataSet.filter(property + " >= startDate", dateRange);
            }
            if (startDate == null) {
                return dataSet.filter(property + " < endDate", dateRange);
            }
            return dataSet.filter(property + " >= startDate and " + property + " < endDate ", dateRange);
        }
        return dataSet;
    }

    public static Map<String, Object> createDateRangeMap(LocalDate startDate, LocalDate endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (startDate != null) {
            map.put("startDate", CommonUtils.localDate2Date(startDate));
        }
        if (endDate != null) {
            map.put("endDate", CommonUtils.localDate2Date(endDate.plusDays(1L)));
        }
        return map;
    }
}

