/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.datarange;

import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import kd.fi.er.mobile.datarange.IDateRange;

public class DateRangeWrapper {
    private LocalDate startDate;
    private LocalDate endDate;
    private LocalDate linkStartDate;
    private LocalDate linkEndDate;
    private LocalDate previousStartDate;
    private LocalDate previousEndDate;
    private int dateType = 0;

    public DateRangeWrapper(IDateRange dateRange) {
        this(dateRange.getStartDate(), dateRange.getEndDate());
    }

    public DateRangeWrapper(LocalDate startDate, LocalDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        if (startDate == null || endDate == null) {
            if (startDate == null && endDate == null) {
                this.dateType = 3;
            }
            return;
        }
        if (DateRangeWrapper.iswholeYear(startDate, endDate)) {
            this.linkStartDate = startDate.minusYears(1L).with(TemporalAdjusters.firstDayOfYear());
            this.linkEndDate = startDate.minusYears(1L).with(TemporalAdjusters.lastDayOfYear());
            this.dateType = 2;
            this.startDate = this.linkStartDate;
            this.endDate = endDate;
        } else if (DateRangeWrapper.iswholeMonth(startDate, endDate)) {
            this.linkStartDate = startDate.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
            this.linkEndDate = endDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
            this.previousStartDate = startDate.minusYears(1L).with(TemporalAdjusters.firstDayOfMonth());
            this.previousEndDate = endDate.minusYears(1L).with(TemporalAdjusters.lastDayOfMonth());
            this.dateType = 1;
            this.startDate = this.previousStartDate;
            this.endDate = endDate;
        }
    }

    public static boolean iswholeMonth(LocalDate startDate, LocalDate endDate) {
        return startDate.equals(startDate.with(TemporalAdjusters.firstDayOfMonth())) && endDate.equals(startDate.with(TemporalAdjusters.lastDayOfMonth()));
    }

    public static boolean iswholeYear(LocalDate startDate, LocalDate endDate) {
        return startDate.equals(startDate.with(TemporalAdjusters.firstDayOfYear())) && endDate.equals(startDate.with(TemporalAdjusters.lastDayOfYear()));
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalDate getLinkStartDate() {
        return this.linkStartDate;
    }

    public LocalDate getLinkEndDate() {
        return this.linkEndDate;
    }

    public int getDateType() {
        return this.dateType;
    }

    public boolean canCompareToAvg() {
        return this.dateType == 0 || this.dateType == 1 || this.dateType == 2;
    }

    public boolean canCompareToPrevious() {
        return this.dateType == 1;
    }

    public boolean canCompareToLink() {
        return this.dateType == 1 || this.dateType == 2;
    }

    public LocalDate getPreviousStartDate() {
        return this.previousStartDate;
    }

    public void setPreviousStartDate(LocalDate previousStartDate) {
        this.previousStartDate = previousStartDate;
    }

    public LocalDate getPreviousEndDate() {
        return this.previousEndDate;
    }

    public void setPreviousEndDate(LocalDate previousEndDate) {
        this.previousEndDate = previousEndDate;
    }
}

