/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.DateRangeWrapper;
import kd.fi.er.mobile.dto.AmountConvertDTO;

public class ParameterCardDTO
implements Serializable {
    public static final long serialVersionUID = 1L;
    private List<Long> orgIds = new ArrayList<Long>();
    private Long shareUserid;
    private AmountConvertDTO convertDTO;
    private String orgLabelText;
    private DateRange dateRange;
    private final HashMap<String, Object> extData = new HashMap();

    public Long getShareUserid() {
        return this.shareUserid;
    }

    public void setShareUserid(Long shareUserid) {
        this.shareUserid = shareUserid;
    }

    public AmountConvertDTO getConvertDTO() {
        return this.convertDTO;
    }

    public void setConvertDTO(AmountConvertDTO convertDTO) {
        this.convertDTO = convertDTO;
    }

    public List<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public String getOrgLabelText() {
        return this.orgLabelText;
    }

    public void setOrgLabelText(String orgLabelText) {
        this.orgLabelText = orgLabelText;
    }

    public void putExt(String key, Object value) {
        this.extData.put(key, value);
    }

    public Object fetchExt(String key) {
        return this.extData.get(key);
    }

    public List<QFilter> filterOrg(String orgField) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(orgField, "in", this.getOrgIds()));
        return qFilters;
    }

    public List<QFilter> filterRange(String orgField, String dateField) {
        List<QFilter> qFilters = this.filterOrg(orgField);
        qFilters.add(new QFilter(orgField, "in", this.getOrgIds()));
        if (this.dateRange.getStartDate() != null) {
            qFilters.add(new QFilter(dateField, ">=", (Object)this.dateRange.getStartDate()));
        }
        if (this.dateRange.getEndDate() != null) {
            qFilters.add(new QFilter(dateField, "<", (Object)this.dateRange.getEndDate().plusDays(1L)));
        }
        return qFilters;
    }

    public List<QFilter> filterPersonal(String personField) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter(personField, "=", (Object)this.getFilterUserId()));
        return qFilters;
    }

    public long getFilterUserId() {
        Long shareUserid = this.getShareUserid();
        long userId = shareUserid != null ? shareUserid.longValue() : RequestContext.get().getCurrUserId();
        return userId;
    }

    public List<QFilter> filterPersonalRange(String personField, String dateField) {
        List<QFilter> qFilters = this.filterPersonal(personField);
        if (this.dateRange.getStartDate() != null) {
            qFilters.add(new QFilter(dateField, ">=", (Object)this.dateRange.getStartDate()));
        }
        if (this.dateRange.getEndDate() != null) {
            qFilters.add(new QFilter(dateField, "<", (Object)this.dateRange.getEndDate().plusDays(1L)));
        }
        return qFilters;
    }

    public List<QFilter> filterWideRange(String orgField, String dateField) {
        List<QFilter> qFilters = this.filterOrg(orgField);
        qFilters.add(new QFilter(orgField, "in", this.getOrgIds()));
        DateRangeWrapper wrapper = new DateRangeWrapper(this.dateRange);
        if (wrapper.getEndDate() != null) {
            qFilters.add(new QFilter(dateField, "<", (Object)wrapper.getEndDate().plusDays(1L)));
        }
        if (wrapper.getStartDate() != null) {
            qFilters.add(new QFilter(dateField, ">=", (Object)wrapper.getStartDate()));
        }
        return qFilters;
    }
}

