/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.er.mobile.common.MultiLangEnumBridge;
import kd.fi.er.mobile.enums.Card;
import kd.fi.er.mobile.enums.ICard;

public enum CardEnum implements ICard
{
    NOT_CANCEL_PREPAID(new MultiLangEnumBridge("\u672a\u6838\u9500\u9884\u4ed8\u6b3e\u5206\u5e03", "CardEnum_0", "fi-er-mb-business"), "em_m_not_cancel_prepaid"),
    OUTSTANDING_LOAN(new MultiLangEnumBridge("\u5458\u5de5\u672a\u8fd8\u501f\u6b3e", "CardEnum_1", "fi-er-mb-business"), "em_m_repaidloan_card"),
    TOTAL_EXPENSES(new MultiLangEnumBridge("\u8d39\u7528\u603b\u989d", "CardEnum_2", "fi-er-mb-business"), "em_m_total_expenses_new"),
    TREND_EXPENSES(new MultiLangEnumBridge("\u8d39\u7528\u8d8b\u52bf", "CardEnum_3", "fi-er-mb-business"), "em_m_trend_card"),
    APPLYPROJECTBILL_PROGRESS(new MultiLangEnumBridge("\u7acb\u9879\u5355\u62a5\u9500\u8fdb\u5ea6", "CardEnum_4", "fi-er-mb-business"), "em_m_applyprojectbill_pro"),
    MAIN_EXPENSES(new MultiLangEnumBridge("\u4e3b\u8981\u8d39\u7528\u5206\u5e03", "CardEnum_13", "fi-er-mb-business"), "em_m_main_expense"),
    TRADER_BILL_OVERALL(new MultiLangEnumBridge("\u5546\u65c5\u6574\u4f53\u6982\u51b5", "CardEnum_5", "fi-er-mb-business"), "em_m_traderbilloverall"),
    AIRLINES_RS(new MultiLangEnumBridge("\u822a\u53f8\u5173\u7cfb\u5206\u6790", "CardEnum_6", "fi-er-mb-business"), "em_m_airlines_rs_card"),
    AIRPLANE_DISCOUNT(new MultiLangEnumBridge("\u63d0\u524d\u8ba2\u7968\u5929\u6570\u4e0e\u6298\u6263\u5206\u6790", "CardEnum_14", "fi-er-mb-business"), "em_m_airplane_discount"),
    EXIST_REBOOK_ANA(new MultiLangEnumBridge("\u9000\u6539\u7b7e\u5206\u6790", "CardEnum_7", "fi-er-mb-business"), "em_m_exist_rebook_card"),
    AIR_EXPENSE_ANA(new MultiLangEnumBridge("\u673a\u7968\u4ef7\u683c\u5206\u6790", "CardEnum_8", "fi-er-mb-business"), "em_m_airexpense_ana"),
    TRIP_TAIL_RANK(new MultiLangEnumBridge("\u5dee\u65c5\u8def\u7ebf\u6392\u540d", "CardEnum_9", "fi-er-mb-business"), "em_m_triptail_rank");

    private final String formId;
    private final MultiLangEnumBridge caption;

    private CardEnum(MultiLangEnumBridge caption, String formId) {
        this.caption = caption;
        this.formId = formId;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public String getCaption() {
        return this.caption.loadKDString();
    }

    public static HashMap<String, ICard> toMap() {
        CardEnum[] values;
        LinkedHashMap<String, ICard> map = new LinkedHashMap<String, ICard>();
        for (CardEnum cardEnum : values = CardEnum.values()) {
            map.put(cardEnum.formId, new Card(cardEnum.getFormId(), cardEnum.getCaption()));
        }
        return map;
    }

    public static Set<String> toSet() {
        return Arrays.stream(CardEnum.values()).map(CardEnum::getFormId).collect(Collectors.toSet());
    }
}

