/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.enums;

import java.util.HashMap;
import kd.fi.er.mobile.common.MultiLangEnumBridge;

public enum ExpenseStatusEnum {
    STATUS_GROUP1("tabpageap1", new MultiLangEnumBridge("\u5f85\u5ba1\u6279", "ExpenseStatusEnum_0", "fi-er-mb-business")),
    STATUS_GROUP2("tabpageap2", new MultiLangEnumBridge("\u5f85\u4ed8\u6b3e", "ExpenseStatusEnum_1", "fi-er-mb-business")),
    STATUS_GROUP3("tabpageap3", new MultiLangEnumBridge("\u5df2\u4ed8\u6b3e", "ExpenseStatusEnum_2", "fi-er-mb-business"));

    private final String tabKey;
    private final MultiLangEnumBridge desc;

    private ExpenseStatusEnum(String tabKey, MultiLangEnumBridge desc) {
        this.tabKey = tabKey;
        this.desc = desc;
    }

    public static ExpenseStatusEnum getSolt(String billstauts) {
        if ("B".equals(billstauts) || "C".equals(billstauts)) {
            return STATUS_GROUP1;
        }
        if ("E".equals(billstauts) || "F".equals(billstauts)) {
            return STATUS_GROUP2;
        }
        return STATUS_GROUP3;
    }

    public String[] getStatus() {
        if (this.name().equals(STATUS_GROUP1.name())) {
            return new String[]{"B", "C"};
        }
        if (this.name().equals(STATUS_GROUP2.name())) {
            return new String[]{"E", "F"};
        }
        return new String[]{"G", "I"};
    }

    public String[] getExtStatus() {
        return new String[]{"E", "F", "G", "I"};
    }

    public HashMap<String, Object> getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (this.name().equals(STATUS_GROUP1.name())) {
            map.put("v1", "B");
            map.put("v2", "C");
        } else if (this.name().equals(STATUS_GROUP2.name())) {
            map.put("v1", "E");
            map.put("v2", "F");
        } else {
            map.put("v1", "G");
            map.put("v2", "I");
        }
        return map;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public String getTabKey() {
        return this.tabKey;
    }

    public static ExpenseStatusEnum byTabKey(String tabKey) {
        if (tabKey.equals(STATUS_GROUP1.getTabKey())) {
            return STATUS_GROUP1;
        }
        if (tabKey.equals(STATUS_GROUP2.getTabKey())) {
            return STATUS_GROUP2;
        }
        return STATUS_GROUP3;
    }
}

