/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.enums;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.fi.er.mobile.common.MultiLangEnumBridge;

public enum TimeSlotEnum {
    time_slot_first(new MultiLangEnumBridge("\u5c0f\u4e8e1\u6708", "TimeSlotEnum_0", "ssc-task-mobile")),
    time_slot_second(new MultiLangEnumBridge("1\u6708~3\u6708", "TimeSlotEnum_1", "ssc-task-mobile")),
    time_slot_three(new MultiLangEnumBridge("3\u6708~6\u6708", "TimeSlotEnum_2", "ssc-task-mobile")),
    time_slot_four(new MultiLangEnumBridge("6\u6708~1\u5e74", "TimeSlotEnum_3", "ssc-task-mobile")),
    time_slot_five(new MultiLangEnumBridge("1\u5e74\u4ee5\u4e0a", "TimeSlotEnum_4", "ssc-task-mobile"));

    private final MultiLangEnumBridge desc;

    private TimeSlotEnum(MultiLangEnumBridge value) {
        this.desc = value;
    }

    public static TimeSlotEnum getTimeSlot(long until) {
        if (until <= 30L) {
            return time_slot_first;
        }
        if (until <= 90L) {
            return time_slot_second;
        }
        if (until <= 180L) {
            return time_slot_three;
        }
        if (until <= 365L) {
            return time_slot_four;
        }
        return time_slot_five;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public static List<String> getTimeSlotList() {
        TimeSlotEnum[] values = TimeSlotEnum.values();
        return Stream.of(values).map(v -> v.desc.loadKDString()).collect(Collectors.toList());
    }
}

