/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.enums;

import java.math.BigDecimal;
import kd.fi.er.mobile.common.MultiLangEnumBridge;

public enum UnitEnum {
    YUAN("0", BigDecimal.ONE, new MultiLangEnumBridge("\u5143", "UnitEnum_0", "fi-er-mb-business")),
    THOUSAND("1", new BigDecimal("1000"), new MultiLangEnumBridge("\u5343", "UnitEnum_1", "fi-er-mb-business")),
    TEN_THOUSAND("2", new BigDecimal("10000"), new MultiLangEnumBridge("\u4e07", "UnitEnum_2", "fi-er-mb-business")),
    HUNDRED_MILLION("3", new BigDecimal("100000000"), new MultiLangEnumBridge("\u4ebf", "UnitEnum_3", "fi-er-mb-business")),
    BILLION("4", new BigDecimal("1000000000"), new MultiLangEnumBridge("\u5341\u4ebf", "UnitEnum_4", "fi-er-mb-business")),
    SYSTEM_ADAPTATION("99", null, new MultiLangEnumBridge("\u7cfb\u7edf\u81ea\u9002\u5e94", "UnitEnum_5", "fi-er-mb-business"));

    private final String value;
    private final BigDecimal scale;
    private final MultiLangEnumBridge desc;

    private UnitEnum(String value, BigDecimal scale, MultiLangEnumBridge desc) {
        this.value = value;
        this.scale = scale;
        this.desc = desc;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public String getUnit() {
        if (this.name().equals(YUAN.name())) {
            return "";
        }
        return this.desc.loadKDString();
    }

    public BigDecimal getScale() {
        return this.scale;
    }

    public static UnitEnum get(String unit) {
        switch (unit) {
            case "99": {
                return SYSTEM_ADAPTATION;
            }
            case "4": {
                return BILLION;
            }
            case "3": {
                return HUNDRED_MILLION;
            }
            case "2": {
                return TEN_THOUSAND;
            }
            case "1": {
                return THOUSAND;
            }
        }
        return YUAN;
    }
}

