/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class IndexServiceHelper {
    public static final String appId = "em";
    public static final String appId2 = "kdem";

    public static Set<Long> getPermAcountingOrgs() {
        long currUserId = RequestContext.get().getCurrUserId();
        return IndexServiceHelper.getPermAcountingOrgs(currUserId);
    }

    public static Set<Long> getPermAcountingOrgs(long userId) {
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return IndexServiceHelper.getAllAccountingOrgIds();
        }
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)"em_m_index_perm", (String)"47150e89000000ac");
        List emPerms = hasPermOrgs.getHasPermOrgs();
        HasPermOrgResult kdemPerms = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)AppMetadataCache.getAppInfo((String)appId2).getId(), (String)"em_m_index_perm", (String)"47150e89000000ac");
        emPerms.addAll(kdemPerms.getHasPermOrgs());
        List longs = OrgUnitServiceHelper.filterOrgDuty((List)emPerms, (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        return new HashSet<Long>(longs);
    }

    public static boolean hasSpecificPerm() {
        long userId = RequestContext.get().getCurrUserId();
        return IndexServiceHelper.hasSpecificPerm(userId);
    }

    public static boolean hasSpecificPerm(long userId) {
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return true;
        }
        boolean hasSpecificPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)"em_m_index_perm", (String)"47150e89000000ac");
        boolean hasSpecificPerm2 = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId2, (String)"em_m_index_perm", (String)"47150e89000000ac");
        return hasSpecificPerm || hasSpecificPerm2;
    }

    public static Set<Long> getAllAccountingOrgIds() {
        return new HashSet<Long>(OrgUnitServiceHelper.getAllOrg((String)"10"));
    }

    public static long getMainOrgId() {
        return IndexServiceHelper.getMainOrgId(IndexServiceHelper.getPermAcountingOrgs());
    }

    public static long getMainOrgId(Collection<Long> orgIdLst) {
        QFilter orgFilters = new QFilter("org", "in", orgIdLst);
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilters, treeTypeFilter, defaultViewFilter};
        String orderBys = "level asc, org.number asc";
        long mainOrgId = -1L;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)IndexServiceHelper.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)orderBys, (int)1);){
            for (Row row : ds) {
                mainOrgId = row.getLong("org");
            }
        }
        return mainOrgId;
    }

    public static List<QFilter> getPermAcountingOrgsQFilters() {
        long userId = RequestContext.get().getCurrUserId();
        return IndexServiceHelper.getPermAcountingOrgsQFilters(userId);
    }

    public static List<QFilter> getPermAcountingOrgsQFilters(long userId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            qFilters.add(new QFilter(OrgViewTypeEnum.IS_ACCOUNTING.getFieldKey(), "=", (Object)"1"));
        } else {
            qFilters.add(new QFilter("id", "in", IndexServiceHelper.getPermAcountingOrgs()));
        }
        return qFilters;
    }
}

