/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.my;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.mobile.service.my.data.UserInfoDTO;

public class MineDataServiceHelper {
    public static UserInfoDTO getUserInfo(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,picturefield,entryentity.id,entryentity.position,entryentity.dpt.name,entryentity.ispartjob";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            DynamicObject currentUser = null;
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!dynamicObject.getBoolean("entryentity.ispartjob")) {
                    currentUser = dynamicObject;
                }
                if (currentUser != null) continue;
                currentUser = dynamicObject;
            }
            assert (currentUser != null);
            userInfoDTO.setUserId(userId);
            userInfoDTO.setName(currentUser.getString("name"));
            userInfoDTO.setPosition(currentUser.getString("entryentity.position"));
            userInfoDTO.setDptName(currentUser.getString("entryentity.dpt.name"));
            userInfoDTO.setAvatarUrl(MineDataServiceHelper.getUserImageFullPath(userId));
        }
        return userInfoDTO;
    }

    private static String getUserImageFullPath(Long userId) {
        ArrayList<Long> id = new ArrayList<Long>(1);
        id.add(userId);
        Map userAvatarPath = UserServiceHelper.getUserAvatarPath(id, (boolean)true);
        return userAvatarPath.size() > 0 ? (String)userAvatarPath.get(userId) : null;
    }
}

