/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.my;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.mobile.common.CommonQueryHelper;
import kd.fi.er.mobile.exception.ErMobiErrorCodeBox;
import kd.fi.er.mobile.exception.ErMobiException;
import kd.fi.er.mobile.service.index.IndexServiceHelper;
import kd.fi.er.mobile.util.JsonUtils;

public class UserSettingDAO {
    public static final Log logger = LogFactory.getLog(UserSettingDAO.class);
    public static final String ENTITY_USER_SETTING = "em_m_usersetting";
    private static final String DEFAULT_UNIT = "99";
    public static final String FORM_ID = "em_m_usersetting";
    private static final IAppCache cache = AppCache.get((String)"em");

    public static DynamicObject getCurrUserSetting() {
        long mainOrgId = IndexServiceHelper.getMainOrgId();
        if (mainOrgId == -1L) {
            mainOrgId = OrgUnitServiceHelper.getRootOrgId();
        }
        return UserSettingDAO.getCurrUserSetting(mainOrgId);
    }

    public static DynamicObject getCurrUserSetting(long mainOrgId) {
        long currUserId = RequestContext.get().getCurrUserId();
        return UserSettingDAO.getUserSetting(mainOrgId, currUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicObject getUserSetting(long mainOrgId, long userId) {
        QFilter qFilter = new QFilter("user", "=", (Object)userId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"em_m_usersetting", (String)"id,user,currency,exratetable,unit", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) return dynamicObject;
        dynamicObject = UserSettingDAO.createDefaultUserSettingDynamicObject(mainOrgId, userId);
        Class<UserSettingDAO> clazz = UserSettingDAO.class;
        synchronized (UserSettingDAO.class) {
            boolean exists = QueryServiceHelper.exists((String)"em_m_usersetting", (QFilter[])qFilter.toArray());
            if (exists) {
                // ** MonitorExit[var6_4] (shouldn't be in output)
                return BusinessDataServiceHelper.loadSingleFromCache((String)"em_m_usersetting", (String)"id,user,currency,exratetable,unit", (QFilter[])qFilter.toArray());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return dynamicObject;
        }
    }

    private static DynamicObject createDefaultUserSettingDynamicObject(long mainOrgId, long userId) {
        long currencyId = 0L;
        long exchangeRateTableId = 0L;
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)mainOrgId);
        if (!baseAccountingInfo.isEmpty()) {
            currencyId = (Long)baseAccountingInfo.get("baseCurrencyID");
            exchangeRateTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
        }
        if (currencyId == 0L || exchangeRateTableId == 0L) {
            throw new ErMobiException(ErMobiErrorCodeBox.NO_CURRENCY, CommonQueryHelper.getOrgName(mainOrgId));
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"em_m_usersetting");
        DynamicObject userSetting = (DynamicObject)type.createInstance();
        userSetting.set("user", (Object)userId);
        userSetting.set("currency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency"));
        userSetting.set("exratetable", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)exchangeRateTableId, (String)"bd_exratetable"));
        userSetting.set("unit", (Object)DEFAULT_UNIT);
        return userSetting;
    }

    public static void update(String fields, Object[] newValues) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject userSetting = BusinessDataServiceHelper.loadSingle((String)"em_m_usersetting", (String)fields, (QFilter[])new QFilter("user", "=", (Object)userId).toArray());
        String[] fieldArr = fields.split(",");
        for (int i = 0; i < fieldArr.length; ++i) {
            userSetting.set(fieldArr[i], newValues[i]);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userSetting});
    }

    public static void saveKeyValue(String paramKey, String value) {
        long userId = RequestContext.get().getCurrUserId();
        String jsonStr = UserSettingDAO.getUserCustParameter(userId, "em_m_usersetting");
        Map<String, String> map = StringUtils.isNotBlank((CharSequence)jsonStr) ? JsonUtils.fromJsonToMap(jsonStr) : new HashMap<String, String>();
        map.put(paramKey, value);
        UserSettingDAO.saveUserCustParameter(userId, "em_m_usersetting", JsonUtils.toJson(map));
    }

    public static void saveUserCustParameter(long userId, String formId, String jsonStr) {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        String sql = "UPDATE T_ER_USERSETTING SET FOTHERINFO = ? WHERE FUSERID = ?";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                params.add(new SqlParameter(":FOTHERINFO", 252, (Object)jsonStr));
                params.add(new SqlParameter(":FUSERID", 8, (Object)userId));
                DB.update((DBRoute)DBRoute.of((String)"em"), (String)sql, (Object[])params.toArray(new SqlParameter[0]));
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("TXException", e.getMessage()), new Object[0]);
        }
        String cacheKey = String.format("%s,%s", userId, formId);
        cache.remove(cacheKey);
        ThreadCache.remove((Object)cacheKey);
    }

    public static String getUserCustParameter(long userId, String formId) {
        String cacheKey = String.format("%s,%s", userId, formId);
        String result = (String)ThreadCache.get((Object)cacheKey, () -> (String)cache.get(cacheKey, String.class));
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return result;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"em_m_usersetting", (String)"id,extinfo", (QFilter[])new QFilter("user", "=", (Object)userId).toArray());
        if (dynamicObject != null) {
            String extinfo = dynamicObject.getString("extinfo");
            cache.put(cacheKey, (Object)extinfo);
            return extinfo;
        }
        return null;
    }

    public static String getKeyValue(String paramKey) {
        long userId = RequestContext.get().getCurrUserId();
        String jsonStr = UserSettingDAO.getUserCustParameter(userId, "em_m_usersetting");
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            Map<String, String> map = JsonUtils.fromJsonToMap(jsonStr);
            return map.get(paramKey);
        }
        return null;
    }
}

