/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.overall;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.BusinessDataHelper;
import kd.fi.er.mobile.dto.ConfigMap;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.enums.BillStatusEnum;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.vo.DataListVO;
import kd.fi.er.mobile.vo.DataVO;

public class ExpenseTrendDataHelper {
    private static final String ALGO_KEY = ExpenseTrendDataHelper.class.getName();

    /*
     * Exception decompiling
     */
    public static DataListVO loadData(ParameterCardDTO dto, String datePattern) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void calIncreaseRate(List<DataVO> vos) {
        for (int i = 0; i < vos.size() - 1; ++i) {
            DataVO v1 = vos.get(i);
            DataVO v2 = vos.get(i + 1);
            BigDecimal increase = CommonUtils.compareRatio(v1.getValue(), v2.getValue());
            if (increase != null) {
                BigDecimal setScale = increase.multiply(new BigDecimal("100")).setScale(0, 4);
                v1.setIncrease(setScale);
                v1.setItemvalue1(String.format(ResManager.loadKDString((String)"\u589e\u957f\u7387:%1$s%%", (String)"ExpenseTrendDataHelper_2", (String)"fi-er-mb-business", (Object[])new Object[0]), setScale));
                continue;
            }
            v1.setItemvalue1(ResManager.loadKDString((String)"\u589e\u957f\u7387: -", (String)"ExpenseTrendDataHelper_1", (String)"fi-er-mb-business", (Object[])new Object[0]));
        }
        if (vos.size() > 0) {
            vos.get(vos.size() - 1).setItemvalue1(ResManager.loadKDString((String)"\u589e\u957f\u7387: -", (String)"ExpenseTrendDataHelper_1", (String)"fi-er-mb-business", (Object[])new Object[0]));
        }
    }

    protected static List<DataVO> buildDatas(List<DataVO> list, SignAmount zeroSignAmount, String datePattern) {
        if (list.isEmpty()) {
            return list;
        }
        boolean isMonth = !"yyyy".equals(datePattern);
        Map<String, DataVO> itemMap = list.stream().collect(Collectors.toMap(DataVO::getItemname, o -> o));
        int size = 6;
        DataVO startVo = list.get(list.size() - 1);
        ArrayList<DataVO> results = new ArrayList<DataVO>(size);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(datePattern);
        LocalDate pDate = LocalDate.now().with(isMonth ? TemporalAdjusters.firstDayOfMonth() : TemporalAdjusters.firstDayOfYear());
        int startV = ExpenseTrendDataHelper.getStartV(startVo.getItemname(), isMonth);
        for (int i = 0; i < size || startV <= ExpenseTrendDataHelper.getPosV(pDate, isMonth); ++i) {
            String name = pDate.format(dateTimeFormatter);
            DataVO dataVO = itemMap.get(name);
            if (dataVO == null) {
                dataVO = new DataVO();
                dataVO.setItemname(name);
                dataVO.setCount(0L);
                dataVO.setSignAmount(zeroSignAmount);
                dataVO.setItemvalue(zeroSignAmount.getText());
            }
            results.add(dataVO);
            pDate = isMonth ? pDate.minusMonths(1L) : pDate.minusYears(1L);
        }
        return results;
    }

    private static int getPosV(LocalDate pDate, boolean isMonth) {
        if (isMonth) {
            return pDate.getYear() * 100 + pDate.getMonthValue();
        }
        return pDate.getYear();
    }

    private static int getStartV(String dateStr, boolean isMonth) {
        if (isMonth) {
            LocalDate startDate = LocalDate.parse(dateStr + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return startDate.getYear() * 100 + startDate.getMonthValue();
        }
        return Integer.parseInt(dateStr);
    }

    private static DataSet getDailyreimbursebillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, CardEnum.NOT_CANCEL_PREPAID.getFormId(), "er_dailyreimbursebill", ExpenseTrendDataHelper::getDailyreimbursebillDataSet);
    }

    private static DataSet getDailyreimbursebillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterRange(configMap.get("expenseentryentity.entrycostcompany"), "bizdate");
        qFilters.add(new QFilter(configMap.get("billstatus"), "not in", (Object)new String[]{BillStatusEnum.SAVED.getValue(), BillStatusEnum.AUDITNOPASS.getValue(), BillStatusEnum.WASTE.getValue()}));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_dailyreimbursebill"), (String)(configMap.get("id") + " as id," + configMap.get("expenseentryentity.id") + " as entryId," + configMap.get("bizdate") + " as bizdate," + configMap.get("currency") + " as currency," + configMap.get("expenseentryentity.expeapprovecurramount") + " as approveamount"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("id,entryid,bizdate,approveamount,currency").distinct();
    }

    private static DataSet getTripreimbursebillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, CardEnum.NOT_CANCEL_PREPAID.getFormId(), "er_tripreimbursebill", ExpenseTrendDataHelper::getTripreimbursebillDataSet);
    }

    private static DataSet getTripreimbursebillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterRange(configMap.get("tripentry.entryentity.travelcostcompany"), "bizdate");
        qFilters.add(new QFilter(configMap.get("billstatus"), "not in", (Object)new String[]{BillStatusEnum.SAVED.getValue(), BillStatusEnum.AUDITNOPASS.getValue(), BillStatusEnum.WASTE.getValue()}));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_tripreimbursebill"), (String)(configMap.get("id") + " as id," + configMap.get("tripentry.entryentity.id") + " as entryId," + configMap.get("bizdate") + " as bizdate," + configMap.get("currency") + " as currency," + configMap.get("tripentry.entryentity.entryappamount") + " as approveamount"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("id,entryid,bizdate,approveamount,currency").distinct();
    }

    private static DataSet getPublicreimbursebillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, CardEnum.NOT_CANCEL_PREPAID.getFormId(), "er_publicreimbursebill", ExpenseTrendDataHelper::getPublicreimbursebillDataSet);
    }

    private static DataSet getPublicreimbursebillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterRange(configMap.get("expenseentryentity.entrycostcompany"), "bizdate");
        qFilters.add(new QFilter(configMap.get("billstatus"), "not in", (Object)new String[]{BillStatusEnum.SAVED.getValue(), BillStatusEnum.AUDITNOPASS.getValue(), BillStatusEnum.WASTE.getValue()}));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_publicreimbursebill"), (String)(configMap.get("id") + " as id," + configMap.get("expenseentryentity.id") + " as entryId," + configMap.get("bizdate") + " as bizdate," + configMap.get("currency") + " as currency," + configMap.get("expenseentryentity.expeapprovecurramount") + " as approveamount"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("id,entryid,bizdate,approveamount,currency").distinct();
    }

    private static /* synthetic */ int lambda$loadData$2(DataVO o1, DataVO o2) {
        return -o1.getItemname().compareTo(o2.getItemname());
    }

    private static /* synthetic */ DataVO lambda$loadData$1(AmountHandler handler, Map.Entry entry) {
        DataVO dataVO = new DataVO();
        dataVO.setItemname((String)entry.getKey());
        DoubleSummaryStatistics statistics = (DoubleSummaryStatistics)entry.getValue();
        double sumAmount = statistics.getSum();
        SignAmount signAmount = handler.getSignAmount(sumAmount);
        dataVO.setSignAmount(signAmount);
        dataVO.setItemvalue(signAmount.getText());
        return dataVO;
    }

    private static /* synthetic */ String lambda$loadData$0(Row row) {
        return row.getString("groupdate");
    }
}

