/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.overall;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.BusinessDataHelper;
import kd.fi.er.mobile.dto.ConfigMap;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.BillStatusEnum;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.enums.TimeSlotEnum;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.vo.DataChartListVO;

public class NotCancelPrepaidDataHelper {
    private static final String ALGO_KEY = NotCancelPrepaidDataHelper.class.getName();

    /*
     * Exception decompiling
     */
    public static DataChartListVO loadData(ParameterCardDTO dto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<Row> filterDailyLoanBillDataSet(DataSet dailyLoanBillDataSet) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(dailyLoanBillDataSet, 16), false).collect(Collectors.groupingBy(row -> row.getLong("id"))).entrySet().stream().filter(NotCancelPrepaidDataHelper::valid).flatMap(entry -> ((List)entry.getValue()).stream()).filter(new Predicate<Row>(){
            private final Map<Object, Boolean> seen = new ConcurrentHashMap<Object, Boolean>();

            @Override
            public boolean test(Row row) {
                return this.seen.putIfAbsent(row.getLong("entryid"), Boolean.TRUE) == null;
            }
        }).collect(Collectors.toList());
    }

    private static boolean valid(Map.Entry<Long, List<Row>> entry) {
        List<Row> rows = entry.getValue();
        for (Row row : rows) {
            if (!"er_payeer".equals(row.getString("payertype")) || !Boolean.TRUE.equals(row.getBoolean("isemployee"))) continue;
            return false;
        }
        return true;
    }

    private static DataSet getPrePayBillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, CardEnum.NOT_CANCEL_PREPAID.getFormId(), "er_prepaybill", NotCancelPrepaidDataHelper::getPrePayBillDataSet);
    }

    private static DataSet getPrePayBillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterOrg(configMap.get("expenseentryentity.entrycostcompany"));
        qFilters.add(new QFilter(configMap.get("billstatus"), "=", (Object)BillStatusEnum.PAID.getValue()));
        qFilters.add(new QFilter(configMap.get("billpayertype"), "=", (Object)"bd_supplier"));
        qFilters.add(new QFilter(configMap.get("expenseentryentity.expebalanceamount"), ">", (Object)0));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_prepaybill"), (String)(configMap.get("billstatus") + " as billstatus," + configMap.get("bizdate") + " as bizdate," + configMap.get("auditdate") + " as auditdate," + configMap.get("expenseentryentity.id") + " as entryid," + configMap.get("expenseentryentity.expebalanceamount") + " as balanceamount," + configMap.get("currency") + " as currency"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("entryid,bizdate,auditdate,balanceamount,currency").distinct();
    }

    private static DataSet getDailyLoanBillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, CardEnum.NOT_CANCEL_PREPAID.getFormId(), "er_dailyloanbill", NotCancelPrepaidDataHelper::getDailyLoanBillDataSet);
    }

    private static DataSet getDailyLoanBillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterOrg(configMap.get("expenseentryentity.entrycostcompany"));
        qFilters.add(new QFilter(configMap.get("billstatus"), "=", (Object)BillStatusEnum.PAID.getValue()));
        qFilters.add(new QFilter(configMap.get("expenseentryentity.expebalanceamount"), ">", (Object)0));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_dailyloanbill"), (String)(configMap.get("id") + " as id," + configMap.get("bizdate") + " as bizdate," + configMap.get("auditdate") + " as auditdate," + configMap.get("expenseentryentity.id") + " as entryid," + configMap.get("expenseentryentity.expebalanceamount") + " as balanceamount," + configMap.get("expenseentryentity.entrycostcompany") + " as costcompany," + configMap.get("accountentry.payertype") + " as payertype," + configMap.get("accountentry.payer.isemployee") + " as isemployee," + configMap.get("currency") + " as currency"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("entryid,bizdate,auditdate,balanceamount,currency,id,payertype,isemployee").distinct();
    }

    private static /* synthetic */ double lambda$loadData$1(AmountHandler handler, Row value) {
        BigDecimal balanceamount = value.getBigDecimal("balanceamount");
        long currency = value.getLong("currency");
        return handler.convertByCurrency(currency, balanceamount).doubleValue();
    }

    private static /* synthetic */ String lambda$loadData$0(Row row) {
        Date auditdate = row.getDate("auditdate");
        if (auditdate == null) {
            auditdate = row.getDate("bizdate");
        }
        LocalDate date = CommonUtils.date2LocalDate(auditdate);
        long until = LocalDate.now().until(date, ChronoUnit.DAYS);
        return TimeSlotEnum.getTimeSlot(-until).name();
    }
}

