/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.overall;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.BusinessDataHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.ConfigMap;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.BillStatusEnum;
import kd.fi.er.mobile.enums.CardEnum;
import kd.fi.er.mobile.enums.ExpireSlotEnum;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.RepaidLoanVO;

public class NotRepaidLoanDataHelper {
    private static final String ALGO_KEY = NotRepaidLoanDataHelper.class.getName();
    public static final Log logger = LogFactory.getLog(NotRepaidLoanDataHelper.class);

    /*
     * Exception decompiling
     */
    public static DataChartListVO loadData(ParameterCardDTO dto, Integer dueDate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<RepaidLoanVO> loadDataList(String tabKey, ParameterCardDTO dto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean batchSendMessage(String expireSlot, ParameterCardDTO dto) {
        List<RepaidLoanVO> loanVOS = NotRepaidLoanDataHelper.loadDataList(expireSlot, dto);
        Map<Long, List<RepaidLoanVO>> listMap = loanVOS.stream().collect(Collectors.groupingBy(RepaidLoanVO::getApplierId));
        AmountHandler handler = AmountHelper.get();
        for (Map.Entry<Long, List<RepaidLoanVO>> entry : listMap.entrySet()) {
            long userId = entry.getKey();
            List<RepaidLoanVO> dtos = entry.getValue();
            int count = dtos.size();
            BigDecimal totalAmount = dtos.stream().map(RepaidLoanVO::getAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            String text = handler.getSignAmount(totalAmount).getText();
            MessageInfo messageInfo = null;
            try {
                messageInfo = NotRepaidLoanDataHelper.createMessageInfo(expireSlot, count, text, userId);
                logger.info(messageInfo.toString());
                long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
                if (msgId != 0L) continue;
                return false;
            }
            catch (KDException e) {
                logger.error(String.format("Unsent message is:%s,error:%s", new Object[]{messageInfo, e}));
            }
        }
        return true;
    }

    public static MessageInfo createMessageInfo(String expireSlot, int count, String totalAmountText, Long userId) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTag(ResManager.loadKDString((String)"\u8d39\u7528\u5206\u6790", (String)"NotRepaidLoanDataHelper_0", (String)"fi-er-mb-business", (Object[])new Object[0]));
        messageInfo.setTitle(ResManager.loadKDString((String)"\u6309\u65f6\u8fd8\u6b3e\u6216\u6838\u9500\u63d0\u9192", (String)"NotRepaidLoanDataHelper_1", (String)"fi-er-mb-business", (Object[])new Object[0]));
        String content = "";
        if (ExpireSlotEnum.expired.name().equals(expireSlot)) {
            content = ResManager.loadKDString((String)"\u4f60\u6709%1$s\u7b14,\u603b\u989d%2$s\u7684\u501f\u6b3e\u5df2\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u8fd8\u6b3e\u6216\u6838\u9500", (String)"NotRepaidLoanDataHelper_2", (String)"fi-er-mb-business", (Object[])new Object[0]);
        } else if (ExpireSlotEnum.due.name().equals(expireSlot)) {
            content = ResManager.loadKDString((String)"\u4f60\u6709%1$s\u7b14,\u603b\u989d%2$s\u7684\u501f\u6b3e\u5373\u5c06\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u8fd8\u6b3e\u6216\u6838\u9500", (String)"NotRepaidLoanDataHelper_3", (String)"fi-er-mb-business", (Object[])new Object[0]);
        }
        messageInfo.setContent(String.format(content, count, totalAmountText));
        messageInfo.setUserIds(new ArrayList<Long>(Collections.singletonList(userId)));
        messageInfo.setType("message");
        messageInfo.setMobContentUrl("");
        messageInfo.setNotifyType("");
        return messageInfo;
    }

    private static DataSet getDailyLoanBillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, CardEnum.OUTSTANDING_LOAN.getFormId(), "er_dailyloanbill", NotRepaidLoanDataHelper::getDailyLoanBillDataSet);
    }

    private static DataSet getDailyLoanBillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterOrg(configMap.get("expenseentryentity.entrycostcompany"));
        qFilters.add(new QFilter(configMap.get("billstatus"), "=", (Object)BillStatusEnum.PAID.getValue()));
        qFilters.add(new QFilter(configMap.get("expenseentryentity.expebalanceamount"), ">", (Object)0));
        qFilters.add(new QFilter(configMap.get("accountentry.payertype"), "=", (Object)"er_payeer").and("accountentry.payer.isemployee", "=", (Object)Boolean.TRUE));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_dailyloanbill"), (String)(configMap.get("billno") + " as billno," + configMap.get("repaymentdate") + " as repaymentdate," + configMap.get("expenseentryentity.id") + " as entryid," + configMap.get("expenseentryentity.expebalanceamount") + " as balanceamount," + configMap.get("applier") + " as applierid," + configMap.get("currency") + " as currency"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("billno,applierid,repaymentdate,entryid,balanceamount,currency").distinct();
    }

    private static DataSet getTripeqBill(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, CardEnum.OUTSTANDING_LOAN.getFormId(), "er_tripreqbill", NotRepaidLoanDataHelper::getTripeqBillDataSet);
    }

    private static DataSet getTripeqBillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterOrg(configMap.get("tripentry.entrycostcompany"));
        qFilters.add(new QFilter(configMap.get("billstatus"), "=", (Object)BillStatusEnum.PAID.getValue()));
        qFilters.add(new QFilter(configMap.get("tripentry.accbalanceamount"), ">", (Object)0));
        qFilters.add(new QFilter(configMap.get("accountentry.payertype"), "=", (Object)"er_payeer").and("accountentry.payer.isemployee", "=", (Object)Boolean.TRUE));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_tripreqbill"), (String)(configMap.get("billno") + " as billno," + configMap.get("repaymentdate") + " as repaymentdate," + configMap.get("tripentry.id") + " as entryid," + configMap.get("tripentry.accbalanceamount") + " as balanceamount," + configMap.get("applier") + " as applierid," + configMap.get("currency") + " as currency"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("billno,applierid,repaymentdate,entryid,balanceamount,currency").distinct();
    }

    private static DataSet filterDataSet(DataSet dataSet, String expireSlot, Integer dueDate) {
        LocalDate now = LocalDate.now();
        M param = M.map().kv("dueDate", dueDate).kv("nowDate", CommonUtils.localDate2Date(now)).kv("nextDate", CommonUtils.localDate2Date(now.plusDays(1L)));
        if (ExpireSlotEnum.expired.name().equals(expireSlot)) {
            return dataSet.filter("repaymentdate < nextDate ", (Map)param);
        }
        if (ExpireSlotEnum.due.name().equals(expireSlot)) {
            return dataSet.filter("repaymentdate >= nextDate  and DATEDIF(nowDate,repaymentdate,'D') <= dueDate", (Map)param);
        }
        return dataSet.filter("DATEDIF(nowDate,repaymentdate,'D') > dueDate", (Map)param);
    }

    private static /* synthetic */ RepaidLoanVO lambda$loadDataList$4(Map mapMap, AmountHandler handler, Row row) {
        String billNo = row.getString("billno");
        Long applierId = row.getLong("applierId");
        Map applierInfo = (Map)mapMap.get(applierId);
        String repaymentDate = row.getString("repaymentdate");
        Long currency = row.getLong("currency");
        BigDecimal srcValue = handler.convertByCurrency(currency, row.getBigDecimal("balanceamount"));
        RepaidLoanVO vo = new RepaidLoanVO();
        vo.setBillNo(billNo);
        vo.setApplierId(applierId);
        ILocaleString name = (ILocaleString)applierInfo.get("name");
        vo.setName(name.getLocaleValue());
        vo.setAvatar(String.valueOf(applierInfo.get("picturefield")));
        vo.setAmount(srcValue);
        vo.setRepaymentdate(repaymentDate);
        return vo;
    }

    private static /* synthetic */ Map lambda$loadDataList$3(Map o) {
        return o;
    }

    private static /* synthetic */ Long lambda$loadDataList$2(Map map) {
        return (Long)map.get("id");
    }

    private static /* synthetic */ Long lambda$loadDataList$1(Row row) {
        return row.getLong("applierid");
    }

    private static /* synthetic */ String lambda$loadData$0(Integer dueDate, Row row) {
        Date repaymentdate = row.getDate("repaymentdate");
        LocalDate date = CommonUtils.date2LocalDate(repaymentdate);
        long until = LocalDate.now().until(date, ChronoUnit.DAYS);
        return ExpireSlotEnum.getSolt(until, dueDate).name();
    }
}

