/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.overall;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.mobile.basedata.BaseDataHelper;
import kd.fi.er.mobile.basedata.org.OrgGroup;
import kd.fi.er.mobile.basedata.org.OrgNodeBuilder;
import kd.fi.er.mobile.basedata.org.OrgTreeNode;
import kd.fi.er.mobile.basedata.project.ProjectNodeBuilder;
import kd.fi.er.mobile.basedata.project.ProjectTreeNode;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.service.analyse.DynamicListGroupDataProcess;
import kd.fi.er.mobile.service.analyse.data.DynamicGroupTransferData;
import kd.fi.er.mobile.service.analyse.data.GroupDataModel;
import kd.fi.er.mobile.service.analyse.data.HeadDataModel;
import kd.fi.er.mobile.service.analyse.data.ItemModel;
import kd.fi.er.mobile.service.analyse.data.ListDataModel;
import kd.fi.er.mobile.service.analyse.enums.BaseGroupDataEnum;

public class TotalExpenseAnalysisDataProcessImpl
implements DynamicListGroupDataProcess {
    public static final Log logger = LogFactory.getLog(TotalExpenseAnalysisDataProcessImpl.class);

    @Override
    public HeadDataModel getTemplateHeadData(DynamicGroupTransferData transferData) {
        AmountHandler amountHandler = AmountHelper.get(transferData.getCardParameter().getConvertDTO());
        DataSet allBillsDataSet = this.getAllBillsDataSet(transferData);
        DataSet filterBillDataSet = this.doExtFilter(transferData, allBillsDataSet);
        HashSet<Long> ids = new HashSet<Long>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Row row : filterBillDataSet) {
            ids.add(row.getLong("id"));
            totalAmount = totalAmount.add(amountHandler.convertByCurrency(row.getLong("currency"), row.getBigDecimal("approveamount")));
        }
        HeadDataModel data = new HeadDataModel();
        data.setName1(ResManager.loadKDString((String)"\u8d39\u7528\u603b\u989d", (String)"TotalExpenseAnalysisDataProcessImpl_0", (String)"fi-er-mb-business", (Object[])new Object[0]));
        data.setValue1(AmountHelper.getSignAmount(totalAmount).getText());
        data.setName2(ResManager.loadKDString((String)"\u8d39\u7528\u7b14\u6570", (String)"TotalExpenseAnalysisDataProcessImpl_1", (String)"fi-er-mb-business", (Object[])new Object[0]));
        data.setValue2(String.valueOf(ids.size()));
        return data;
    }

    @Override
    public ListDataModel getListData(DynamicGroupTransferData transferData) {
        AmountHelper.cacheAmountConvert(transferData.getCardParameter().getConvertDTO());
        DataSet allBillsDataSet = this.getAllBillsDataSet(transferData);
        try (DataSet filterBillDataSet = this.doExtFilter(transferData, allBillsDataSet);){
            ListDataModel listDataModel = this.translateDataSet2ItemModel(transferData, filterBillDataSet);
            return listDataModel;
        }
    }

    /*
     * Exception decompiling
     */
    private DataSet getAllBillsDataSet(DynamicGroupTransferData transferData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ListDataModel translateDataSet2ItemModel(DynamicGroupTransferData transferData, DataSet filterBillDataSet) {
        String currentGroupBy = transferData.lastGroupby().getGroupBy();
        ArrayList<ItemModel> items = new ArrayList<ItemModel>();
        AmountHandler amountHandler = AmountHelper.get();
        switch (currentGroupBy) {
            case "orgid": {
                OrgTreeNode orgTopNode = new OrgNodeBuilder(new HashSet<Long>(transferData.getCardParameter().getOrgIds())).getTopNode();
                OrgTreeNode orgNode = orgTopNode.getNodeById(this.getParentNodeFilterId(transferData, currentGroupBy));
                HashMap<Long, OrgGroup> orgGroupingMap = orgNode.groupingMap();
                Set<Long> orgLongs = orgGroupingMap.values().stream().map(OrgGroup::getId).collect(Collectors.toSet());
                Map<Long, String> orgBaseData = BaseDataHelper.getBaseData(currentGroupBy, orgLongs);
                items.addAll(this.getProjectItems(orgGroupingMap, filterBillDataSet, currentGroupBy, orgBaseData));
                break;
            }
            case "billType": {
                BigDecimal amountOfGroupId;
                HashSet<Long> groupIds = new HashSet<Long>();
                HashMap<Long, BigDecimal> amountMapById = new HashMap<Long, BigDecimal>();
                for (Object next : filterBillDataSet.copy()) {
                    Long groupId = next.getLong(currentGroupBy);
                    groupIds.add(groupId);
                    amountOfGroupId = (BigDecimal)amountMapById.get(groupId);
                    if (amountOfGroupId == null) {
                        amountMapById.put(groupId, amountHandler.convertByCurrency(next.getLong("currency"), next.getBigDecimal("approveamount")));
                        continue;
                    }
                    BigDecimal sumOfOrgId = amountOfGroupId.add(amountHandler.convertByCurrency(next.getLong("currency"), next.getBigDecimal("approveamount")));
                    amountMapById.put(groupId, sumOfOrgId);
                }
                Map<Long, String> nameMap = BaseDataHelper.getBaseData(currentGroupBy, groupIds);
                for (Long groupId : groupIds) {
                    amountOfGroupId = (BigDecimal)amountMapById.get(groupId);
                    ItemModel item = new ItemModel();
                    item.setGroupid(groupId);
                    item.setItemname(nameMap.get(groupId));
                    item.setItemvalue(AmountHelper.getSignAmount(amountOfGroupId).getText());
                    item.setSignAmount(AmountHelper.getSignAmount(amountOfGroupId));
                    item.setValue(amountOfGroupId);
                    item.setHaveChildren(false);
                    items.add(item);
                }
                break;
            }
            case "expenseProject": {
                ProjectTreeNode expenseProjectTopNode = new ProjectNodeBuilder(null, currentGroupBy).getTopNode();
                Long parentNodeFilterId = this.getParentNodeFilterId(transferData, currentGroupBy);
                if (parentNodeFilterId != null && parentNodeFilterId == -2L) {
                    HashMap<Long, OrgGroup> tripProjectGroupingMap = this.groupingTripProjectMap(filterBillDataSet.copy(), false);
                    Set<Long> tripProjectLongs = tripProjectGroupingMap.values().stream().map(OrgGroup::getId).collect(Collectors.toSet());
                    Map<Long, String> tripProjectBaseData = BaseDataHelper.getBaseData("tripProject", tripProjectLongs);
                    items.addAll(this.getProjectItems(tripProjectGroupingMap, filterBillDataSet, currentGroupBy, tripProjectBaseData));
                    break;
                }
                if (parentNodeFilterId == null) {
                    ProjectTreeNode expenseProjectNode = expenseProjectTopNode.getNodeById(parentNodeFilterId);
                    HashMap<Long, OrgGroup> expenseProjectGroupingMap = expenseProjectNode.groupingMap();
                    Set<Long> expenseProjectLongs = expenseProjectGroupingMap.values().stream().map(OrgGroup::getId).collect(Collectors.toSet());
                    Map<Long, String> expenseProjectBaseData = BaseDataHelper.getBaseData("expenseProject", expenseProjectLongs);
                    DataSet expenseProjectDataSet = filterBillDataSet.copy().filter("billType != 2");
                    items.addAll(this.getProjectItems(expenseProjectGroupingMap, expenseProjectDataSet, currentGroupBy, expenseProjectBaseData));
                    DataSet tripProjectDataSet = filterBillDataSet.filter("billType = 2");
                    HashMap<Long, OrgGroup> tripProjectGroupingMap = this.groupingTripProjectMap(tripProjectDataSet.copy(), true);
                    HashMap<Long, String> tripProjectBaseData = new HashMap<Long, String>();
                    tripProjectBaseData.put(-2L, ResManager.loadKDString((String)"\u5dee\u65c5\u8d39\u7528", (String)"TotalExpenseAnalysisDataProcessImpl_2", (String)"fi-er-mb-business", (Object[])new Object[0]));
                    items.addAll(this.getProjectItems(tripProjectGroupingMap, tripProjectDataSet, currentGroupBy, tripProjectBaseData));
                    break;
                }
                ProjectTreeNode expenseProjectNode = expenseProjectTopNode.getNodeById(parentNodeFilterId);
                HashMap<Long, OrgGroup> expenseProjectGroupingMap = expenseProjectNode.groupingMap();
                List<Long> expenseProjectLongs = expenseProjectGroupingMap.values().stream().map(OrgGroup::getId).collect(Collectors.toList());
                Map<Long, String> expenseProjectBaseData = BaseDataHelper.getBaseData("expenseProject", expenseProjectLongs);
                items.addAll(this.getProjectItems(expenseProjectGroupingMap, filterBillDataSet, currentGroupBy, expenseProjectBaseData));
                break;
            }
            case "project": {
                ProjectTreeNode projectTopNode = new ProjectNodeBuilder(null, currentGroupBy).getTopNode();
                ProjectTreeNode projectNode = projectTopNode.getNodeById(this.getParentNodeFilterId(transferData, currentGroupBy));
                HashMap<Long, OrgGroup> projectGroupingMap = projectNode.groupingMap();
                Set<Long> projectLongs = projectGroupingMap.values().stream().map(OrgGroup::getId).collect(Collectors.toSet());
                Map<Long, String> projectBaseData = BaseDataHelper.getBaseData(currentGroupBy, projectLongs);
                items.addAll(this.getProjectItems(projectGroupingMap, filterBillDataSet, currentGroupBy, projectBaseData));
            }
        }
        ListDataModel data = this.newListDataModel(items, 5);
        if (items.size() == 1 && ((ItemModel)items.get(0)).getGroupid() == -1L) {
            data.setDataTag(0);
            data.setNoDataTip(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u671f\u95f4\u7684\u8d39\u7528\u672a\u5f52\u96c6\u5230\u4efb\u4f55\u9879\u76ee", (String)"TotalExpenseAnalysisDataProcessImpl_3", (String)"fi-er-mb-business", (Object[])new Object[0]));
        }
        data.setGroupby(currentGroupBy);
        return data;
    }

    private HashMap<Long, OrgGroup> groupingTripProjectMap(DataSet tripProjectDataSet, boolean isParent) {
        HashMap<Long, OrgGroup> tripProjectMap = new HashMap<Long, OrgGroup>();
        for (Row row : tripProjectDataSet) {
            Long tripProjectId = row.getLong("expenseProject");
            OrgGroup orgGroup = tripProjectMap.get(tripProjectId);
            if (orgGroup != null) continue;
            if (isParent) {
                tripProjectMap.put(tripProjectId, new OrgGroup(-2L, false));
                continue;
            }
            tripProjectMap.put(tripProjectId, new OrgGroup(tripProjectId, true));
        }
        return tripProjectMap;
    }

    private Long getParentNodeFilterId(DynamicGroupTransferData transferData, String groupBy) {
        List<GroupDataModel> groupbys = transferData.getGroupbys();
        if (groupbys.size() >= 2) {
            GroupDataModel groupDataModel = groupbys.get(groupbys.size() - 2);
            return groupBy.equals(groupDataModel.getGroupBy()) ? groupDataModel.getGroupId() : null;
        }
        return null;
    }

    private List<ItemModel> getProjectItems(Map<Long, OrgGroup> groupingMap, DataSet filterBillDataSet, String entityName, Map<Long, String> baseData) {
        AmountHandler amountHandler = AmountHelper.get();
        Map<Long, DoubleSummaryStatistics> collect = StreamSupport.stream(Spliterators.spliteratorUnknownSize(filterBillDataSet.groupBy(new String[]{entityName, "currency"}).sum("approveamount").finish(), 16), false).collect(Collectors.groupingBy(row -> {
            Long groupId = row.getLong(entityName);
            OrgGroup orgGroup = (OrgGroup)groupingMap.get(groupId);
            if (orgGroup == null) {
                return -1L;
            }
            return orgGroup.getId();
        }, Collectors.summarizingDouble(row -> {
            BigDecimal totalamount = row.getBigDecimal("approveamount");
            long currency = row.getLong("currency");
            return amountHandler.convertByCurrency(currency, totalamount).doubleValue();
        })));
        Set<Map.Entry<Long, DoubleSummaryStatistics>> entries = collect.entrySet();
        List<ItemModel> items = entries.stream().map(entry -> {
            ItemModel item = new ItemModel();
            item.setGroupid((Long)entry.getKey());
            item.setItemname(baseData.getOrDefault(entry.getKey(), ResManager.loadKDString((String)"\u672a\u5f52\u96c6\u5230\u9879\u76ee", (String)"TotalExpenseAnalysisDataProcessImpl_4", (String)"fi-er-mb-business", (Object[])new Object[0])));
            DoubleSummaryStatistics statistics = (DoubleSummaryStatistics)entry.getValue();
            double sumAmount = statistics.getSum();
            SignAmount signAmount = amountHandler.getSignAmount(sumAmount);
            item.setSignAmount(signAmount);
            item.setItemvalue(signAmount.getText() + "");
            Boolean isLeaf = Optional.ofNullable(groupingMap.get(item.getGroupid())).map(OrgGroup::isLeaf).orElse(Boolean.FALSE);
            item.setHaveChildren(isLeaf == false);
            return item;
        }).sorted().collect(Collectors.toList());
        return items;
    }

    private DataSet doExtFilter(DynamicGroupTransferData transferData, DataSet allBills) {
        List<GroupDataModel> groupDataModels = transferData.getGroupbys();
        HashMap<String, Long> groupIdsMap = new HashMap<String, Long>(groupDataModels.size());
        for (int i = 0; i < groupDataModels.size() - 1; ++i) {
            GroupDataModel groupDataModel = groupDataModels.get(i);
            groupIdsMap.put(groupDataModel.getGroupBy(), groupDataModel.getGroupId());
        }
        for (Map.Entry stringListEntry : groupIdsMap.entrySet()) {
            String groupBy = (String)stringListEntry.getKey();
            Long groupId = (Long)stringListEntry.getValue();
            switch (groupBy) {
                case "orgid": {
                    OrgTreeNode orgTopNode = new OrgNodeBuilder(Collections.singletonList(groupId)).getTopNode();
                    Collection permAccountingChildrenOfOrg = orgTopNode.getNodeById(groupId).containOrgIds();
                    if (this.notConcludeParentNode(transferData, groupBy)) {
                        permAccountingChildrenOfOrg = permAccountingChildrenOfOrg.stream().filter(orgId -> !orgId.equals(groupId)).collect(Collectors.toList());
                    }
                    allBills = allBills.filter("orgid in orgids", M.map("orgids", permAccountingChildrenOfOrg));
                    break;
                }
                case "billType": {
                    allBills = allBills.filter("billType = billTypeIds", M.map("billTypeIds", groupId));
                    break;
                }
                case "expenseProject": {
                    if (groupId == -2L) {
                        allBills = allBills.filter("billType = 2");
                        break;
                    }
                    if (this.fromTripProjectParentNode(transferData)) {
                        allBills = allBills.filter("expenseProject = tripProjectId", M.map("tripProjectId", groupId));
                        break;
                    }
                    ProjectTreeNode expProjectTopNode = new ProjectNodeBuilder(Collections.singleton(groupId), BaseGroupDataEnum.EXPENSEPROJECT.getCode()).getTopNode();
                    Set<Long> permAccountingChildrenOfExpProject = expProjectTopNode.getNodeById(groupId).getPermissionProjectIds();
                    if (this.notConcludeParentNode(transferData, groupBy)) {
                        permAccountingChildrenOfExpProject = permAccountingChildrenOfExpProject.stream().filter(orgId -> !orgId.equals(groupId)).collect(Collectors.toSet());
                    }
                    allBills = allBills.filter("billType != 2").filter("expenseProject in expenseProjectIds", M.map("expenseProjectIds", permAccountingChildrenOfExpProject));
                    break;
                }
                case "project": {
                    ProjectTreeNode projectTopNode = new ProjectNodeBuilder(Collections.singleton(groupId), BaseGroupDataEnum.PROJECT.getCode()).getTopNode();
                    Set<Long> permAccountingChildrenOfProject = projectTopNode.getNodeById(groupId).getPermissionProjectIds();
                    if (this.notConcludeParentNode(transferData, groupBy)) {
                        permAccountingChildrenOfProject = permAccountingChildrenOfProject.stream().filter(orgId -> !orgId.equals(groupId)).collect(Collectors.toSet());
                    }
                    allBills = allBills.filter("project in projectIds", M.map("projectIds", permAccountingChildrenOfProject));
                }
            }
        }
        return allBills;
    }

    private boolean fromTripProjectParentNode(DynamicGroupTransferData transferData) {
        for (GroupDataModel groupby : transferData.getGroupbys()) {
            if (groupby.getGroupId() == null || groupby.getGroupId() != -2L) continue;
            return true;
        }
        return false;
    }

    private boolean notConcludeParentNode(DynamicGroupTransferData transferData, String currentGroupBy) {
        List<GroupDataModel> groupDataModels = transferData.getGroupbys();
        if (groupDataModels.size() >= 2) {
            String LastSecondGroupBy = groupDataModels.get(groupDataModels.size() - 2).getGroupBy();
            return currentGroupBy.equals(LastSecondGroupBy) && !transferData.isConcludeParent();
        }
        return false;
    }

    private ListDataModel newListDataModel(List<ItemModel> collect, int xLimit) {
        Collections.sort(collect);
        ListDataModel data = new ListDataModel();
        data.setDatas(collect);
        data.setSeriesName(ResManager.loadKDString((String)"\u8d39\u7528\u603b\u989d", (String)"TotalExpenseAnalysisDataProcessImpl_0", (String)"fi-er-mb-business", (Object[])new Object[0]));
        data.setyName(ResManager.loadKDString((String)"\u8d39\u7528\u603b\u989d", (String)"TotalExpenseAnalysisDataProcessImpl_0", (String)"fi-er-mb-business", (Object[])new Object[0]));
        data.setChartTitle(data.getyName() + "TOP5");
        data.setChartLimit(xLimit);
        data.setyAxisLineFormatter("function(item) {  return (item).toFixed(1);}");
        data.setTooltipFormatter("");
        return data;
    }
}

