/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.overall;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.util.DateSpanUtils;

public class TotalExpenseDataHelperService {
    public static Map<String, DynamicObjectCollection> getAllBillsWithPermission(ParameterCardDTO parameterDTO) {
        HashMap<String, DynamicObjectCollection> billsMap = new HashMap<String, DynamicObjectCollection>();
        QFilter orgFilter = null;
        QFilter tripOrgFilter = null;
        List<Long> orgIds = parameterDTO.getOrgIds();
        if (!CollectionUtils.isEmpty(orgIds)) {
            orgFilter = new QFilter("expenseentryentity.entrycostcompany", "in", orgIds);
            tripOrgFilter = new QFilter("tripentry.entryentity.travelcostcompany", "in", orgIds);
        }
        QFilter statusFilter = new QFilter("billstatus", "not in", M.arraylist("A", "D", "H"));
        DateRange dateRange = parameterDTO.getDateRange();
        QFilter timeFilter = DateSpanUtils.timeSection("bizdate", dateRange.getStartDate(), dateRange.getEndDate());
        DynamicObjectCollection dailyReimburseBills = QueryServiceHelper.query((String)"er_dailyreimbursebill", (String)"id,currency,expenseentryentity.entrycostcompany as costcompany,expenseentryentity.expeapprovecurramount as approveamount", (QFilter[])new QFilter[]{orgFilter, statusFilter, timeFilter});
        billsMap.put("er_dailyreimbursebill", dailyReimburseBills);
        DynamicObjectCollection tripReimBill = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,currency,tripentry.entrycostcompany as costcompany,tripentry.entryentity.entryappamount as approveamount", (QFilter[])new QFilter[]{tripOrgFilter, statusFilter, timeFilter});
        billsMap.put("er_tripreimbursebill", tripReimBill);
        DynamicObjectCollection publicReimburseBill = QueryServiceHelper.query((String)"er_publicreimbursebill", (String)"id,currency,expenseentryentity.entrycostcompany as costcompany,expenseentryentity.expeapprovecurramount as approveamount", (QFilter[])new QFilter[]{orgFilter, statusFilter, timeFilter});
        billsMap.put("er_publicreimbursebill", publicReimburseBill);
        return billsMap;
    }

    public static BigDecimal compareRatio(BigDecimal thisData, BigDecimal priviousData) {
        BigDecimal yoyRatio = null;
        if (priviousData != null && thisData != null) {
            if (BigDecimal.ZERO.compareTo(priviousData) != 0) {
                yoyRatio = BigDecimal.ZERO.compareTo(thisData) != 0 ? thisData.subtract(priviousData).divide(priviousData, 4, 4) : new BigDecimal("-1");
            } else if (BigDecimal.ZERO.compareTo(thisData) == 0) {
                yoyRatio = new BigDecimal("0");
            }
        }
        return yoyRatio;
    }
}

