/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.personal;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.BusinessDataHelper;
import kd.fi.er.mobile.dto.ConfigMap;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.enums.ExpenseStatusEnum;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.util.DateUtil;
import kd.fi.er.mobile.vo.DataListVO;
import kd.fi.er.mobile.vo.DataVO;

public class PersonalExpenseDetailDataHelper {
    private static final String ALGO_KEY = PersonalExpenseDetailDataHelper.class.getName();

    /*
     * Exception decompiling
     */
    public static DataListVO loadListData(String tabKey, ParameterCardDTO dto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void fillWorkFlowInfo(List<DataVO> list) {
        if (list.isEmpty()) {
            return;
        }
        List bussinessKeys = list.stream().map(vo -> String.valueOf(vo.getItemId())).collect(Collectors.toList());
        QFilter qFilter1 = new QFilter("fbusinesskey", "in", bussinessKeys);
        try (DataSet dataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.workflow, (String)("select t.fbusinesskey as businesskey,t.fname as name,t.fcategory as category, t.fcreatedate as createdate,twh.fuserid as userid,twh.fusername as username  from t_wf_task t left join t_wf_hiparticipant twh on t.fid = twh.ftaskid  where " + qFilter1), null);
             DataSet avartDataSet = dataSet.copy().groupBy(new String[]{"userid"}).finish();){
            Map<String, List<Row>> rowMap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).collect(Collectors.groupingBy(row -> row.getString("businesskey")));
            List userids = StreamSupport.stream(Spliterators.spliteratorUnknownSize(avartDataSet, 16), false).mapToLong(value -> value.getLong("userid")).boxed().collect(Collectors.toList());
            Map userAvatarPath = UserServiceHelper.getUserAvatarPath(userids, (boolean)true);
            for (DataVO vo2 : list) {
                String businesskey = String.valueOf(vo2.getItemId());
                List<Row> rows = rowMap.get(businesskey);
                if (rows == null || rows.size() <= 0) continue;
                Date createdate = rows.get(0).getDate("createdate");
                if (createdate != null) {
                    LocalDateTime parse = CommonUtils.date2LocalDateTime(createdate);
                    long until = parse.until(LocalDateTime.now(), ChronoUnit.HOURS);
                    vo2.setItemvalue2(String.format(ResManager.loadKDString((String)"\u5904\u7406\u65f6\u957f: %s \u5c0f\u65f6", (String)"PersonalExpenseDetailDataHelper_5", (String)"fi-er-mb-business", (Object[])new Object[0]), until));
                }
                Long userid = null;
                String username = "";
                boolean present = rows.stream().anyMatch(row -> "SSCApprove".equals(row.getString("category")));
                if (present) {
                    username = ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279", (String)"PersonalExpenseDetailDataHelper_6", (String)"fi-er-mb-business", (Object[])new Object[0]);
                } else {
                    int size = 0;
                    for (Row row2 : rows) {
                        userid = row2.getLong("userid");
                        if (userid == null || userid <= 0L) continue;
                        username = row2.getString("username");
                        ++size;
                    }
                    if (userid != null && StringUtils.isEmpty((CharSequence)username)) {
                        QFilter filterUser = new QFilter("id", "=", (Object)userid);
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"name", (QFilter[])filterUser.toArray());
                        username = String.valueOf(dynamicObject.get("name"));
                    }
                    if (StringUtils.isEmpty((CharSequence)username)) {
                        username = rows.get(0).getString("name");
                    } else if (size > 1) {
                        String end = ResManager.loadKDString((String)"\u7b49\u4eba", (String)"PersonalExpenseDetailDataHelper_4", (String)"fi-er-mb-business", (Object[])new Object[0]);
                        username = username + end;
                    }
                }
                String avatar = (String)userAvatarPath.get(userid);
                vo2.setItempre1(avatar);
                vo2.setItempre2(username);
            }
        }
    }

    private static Map<String, Double> calavgAuditTime(DataSet dataSet) {
        try (DataSet filter = dataSet.filter("billstatus in (v1,v2)", ExpenseStatusEnum.STATUS_GROUP3.getStatusMap()).groupBy(new String[]{"id", "billNo", "auditdate", "billType"}).min("targetpaydate").finish().select(new String[]{"billType", "DATEDIF(auditdate,targetpaydate,'D') as days"});){
            Map<String, Double> map;
            CommonUtils.dumpDataSet(filter.copy());
            Map<String, Double> map2 = map = StreamSupport.stream(Spliterators.spliteratorUnknownSize(filter, 16), false).collect(Collectors.groupingBy(new Function<Row, String>(){

                @Override
                public String apply(Row row) {
                    return row.getString("billType");
                }
            }, Collectors.averagingInt(new ToIntFunction<Row>(){

                @Override
                public int applyAsInt(Row row) {
                    return row.getInteger("days");
                }
            })));
            return map2;
        }
    }

    private static DataSet getDailyreimbursebillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, "em_m_personal_expense", "er_dailyreimbursebill", PersonalExpenseDetailDataHelper::getDailyreimbursebillDataSet);
    }

    private static DataSet getDailyreimbursebillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters;
        String tabKey = (String)dto.fetchExt("tabKey");
        ExpenseStatusEnum statusEnum = ExpenseStatusEnum.byTabKey(tabKey);
        if ("tabpageap2".equals(tabKey)) {
            qFilters = dto.filterPersonal(configMap.get("applier"));
            qFilters.add(new QFilter(configMap.get("billstatus"), "in", (Object)statusEnum.getExtStatus()));
        } else {
            qFilters = dto.filterPersonalRange(configMap.get("applier"), configMap.get("bizdate"));
            qFilters.add(new QFilter(configMap.get("billstatus"), "in", (Object)statusEnum.getStatus()));
        }
        qFilters.add(new QFilter(configMap.get("accountentry.payertype"), "=", (Object)"er_payeer").and(configMap.get("accountentry.payer.payer"), "=", (Object)dto.getFilterUserId()));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_dailyreimbursebill"), (String)("id as id,billno as billno,'" + configMap.get("er_dailyreimbursebill") + "' as billtype," + configMap.get("description") + " as description," + configMap.get("bizdate") + " as bizdate," + configMap.get("auditdate") + " as auditdate," + configMap.get("nextauditor") + " as nextauditor," + configMap.get("caspayentry.targetpaydate") + " as targetpaydate," + configMap.get("billstatus") + " as billstatus," + configMap.get("approveamount") + " as approveamount," + configMap.get("currency") + " as currency"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("id,billno,billtype,description,bizdate,auditdate,targetpaydate,billstatus,approveamount,currency").distinct();
    }

    private static DataSet getTripreimbursebillDataSet(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, "em_m_personal_expense", "er_tripreimbursebill", PersonalExpenseDetailDataHelper::getTripreimbursebillDataSet);
    }

    private static DataSet getTripreimbursebillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters;
        String tabKey = (String)dto.fetchExt("tabKey");
        ExpenseStatusEnum statusEnum = ExpenseStatusEnum.byTabKey(tabKey);
        if ("tabpageap2".equals(tabKey)) {
            qFilters = dto.filterPersonal(configMap.get("applier"));
            qFilters.add(new QFilter(configMap.get("billstatus"), "in", (Object)statusEnum.getExtStatus()));
        } else {
            qFilters = dto.filterPersonalRange(configMap.get("applier"), configMap.get("bizdate"));
            qFilters.add(new QFilter(configMap.get("billstatus"), "in", (Object)statusEnum.getStatus()));
        }
        qFilters.add(new QFilter(configMap.get("accountentry.payertype"), "=", (Object)"er_payeer").and(configMap.get("accountentry.payer.payer"), "=", (Object)dto.getFilterUserId()));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_tripreimbursebill"), (String)("id as id,billno as billno,'" + configMap.get("er_tripreimbursebill") + "' as billtype," + configMap.get("description") + " as description," + configMap.get("bizdate") + " as bizdate," + configMap.get("auditdate") + " as auditdate," + configMap.get("nextauditor") + " as nextauditor," + configMap.get("caspayentry.targetpaydate") + " as targetpaydate," + configMap.get("billstatus") + " as billstatus," + configMap.get("approveamount") + " as approveamount," + configMap.get("currency") + " as currency"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("id,billno,billtype,description,bizdate,auditdate,targetpaydate,billstatus,approveamount,currency").distinct();
    }

    private static /* synthetic */ double lambda$loadListData$2(DataVO value) {
        return value.getSignAmount().getValue().doubleValue();
    }

    private static /* synthetic */ int lambda$loadListData$1(DataVO o1, DataVO o2) {
        int i = o1.getSeqDate().compareTo(o2.getSeqDate());
        if (i == 0) {
            return -o1.getValue().compareTo(o2.getValue());
        }
        return -i;
    }

    private static /* synthetic */ DataVO lambda$loadListData$0(AmountHandler handler, String tabKey, Map mapAvgDays, Row row) {
        String billType;
        Double orDefault;
        Date date;
        DataVO vo = new DataVO();
        vo.setSeqDate(row.getDate("bizdate"));
        vo.setItemId(row.getLong("id"));
        vo.putExt("billtype", row.getString("billtype"));
        vo.setItemname(row.getString("description"));
        BigDecimal approveamount = row.getBigDecimal("approveamount");
        long currency = row.getLong("currency");
        SignAmount signAmount = handler.getSignAmount(currency, approveamount);
        vo.setSignAmount(signAmount);
        vo.setItemvalue1(signAmount.getText());
        if ((tabKey.equals(ExpenseStatusEnum.STATUS_GROUP2.getTabKey()) || tabKey.equals(ExpenseStatusEnum.STATUS_GROUP3.getTabKey())) && (date = row.getDate("auditdate")) != null) {
            vo.setItemvalue(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7\u65e5\u671f: %1$s", (String)"PersonalExpenseDetailDataHelper_7", (String)"fi-er-mb-business", (Object[])new Object[0]), DateUtil.format(date, "yyyy/MM/dd")));
        }
        if (tabKey.equals(ExpenseStatusEnum.STATUS_GROUP2.getTabKey()) && (date = row.getDate("auditdate")) != null && (orDefault = (Double)mapAvgDays.get(billType = row.getString("billType"))) != null) {
            int diss = BigDecimal.valueOf(orDefault).setScale(0, 4).intValue();
            Date predictDate = DateUtil.addDay(date, diss);
            vo.setItemvalue2(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8\u6b3e\u65e5\u671f: %1$s", (String)"PersonalExpenseDetailDataHelper_8", (String)"fi-er-mb-business", (Object[])new Object[0]), DateUtil.format(predictDate, "yyyy/MM/dd")));
        }
        if (tabKey.equals(ExpenseStatusEnum.STATUS_GROUP3.getTabKey()) && (date = row.getDate("targetpaydate")) != null) {
            vo.setItemvalue2(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f: %1$s", (String)"PersonalExpenseDetailDataHelper_9", (String)"fi-er-mb-business", (Object[])new Object[0]), DateUtil.format(date, "yyyy/MM/dd")));
        }
        return vo;
    }
}

