/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.personal;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.er.mobile.dto.ScenceSuggest;
import kd.fi.er.mobile.enums.ExpenseStatusEnum;
import kd.fi.er.mobile.vo.DataListVO;
import kd.fi.er.mobile.vo.DataVO;

public class PersonalExpenseScenceProvide {
    private final List<Integer> scenceIds = new ArrayList<Integer>();
    private final SecureRandom random;

    public PersonalExpenseScenceProvide() {
        Collections.addAll(this.scenceIds, 0);
        this.random = new SecureRandom();
    }

    protected String getSuggest(DataListVO data) {
        ScenceSuggest suggest = this.recursiveSuggest(data);
        if (suggest == null) {
            return "";
        }
        return suggest.getSuggest();
    }

    private ScenceSuggest recursiveSuggest(DataListVO data) {
        int scenceId = this.randomScenceId();
        ScenceSuggest ss = this.getScenceSuggest(scenceId);
        if (ss == null) {
            return null;
        }
        if (ss.valid(data)) {
            return ss;
        }
        return this.recursiveSuggest(data);
    }

    private int randomScenceId() {
        if (this.scenceIds.size() > 1) {
            int i = this.random.nextInt(this.scenceIds.size() - 1);
            Integer id = this.scenceIds.get(i);
            this.scenceIds.remove(id);
            return id;
        }
        if (this.scenceIds.size() == 1) {
            Integer id = this.scenceIds.get(0);
            this.scenceIds.remove(id);
            return id;
        }
        return -1;
    }

    private ScenceSuggest getScenceSuggest(Integer scenceId) {
        switch (scenceId) {
            case 0: {
                return new ScenceSuggest(0, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u7684\u5355\u636e\u5747\u5df2\u5b8c\u6210\u4ed8\u6b3e", (String)"PersonalExpenseScenceProvide_0", (String)"fi-er-mb-business", (Object[])new Object[0]), data -> {
                    boolean isTrue = true;
                    List<DataVO> datas = data.getDatas();
                    for (DataVO vo : datas) {
                        if (!ExpenseStatusEnum.STATUS_GROUP1.name().equals(vo.getItemKey()) && !ExpenseStatusEnum.STATUS_GROUP2.name().equals(vo.getItemKey()) || vo.getValue().compareTo(BigDecimal.ZERO) <= 0) continue;
                        isTrue = false;
                    }
                    if (isTrue) {
                        return new Object[0];
                    }
                    return null;
                });
            }
        }
        return null;
    }
}

