/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.personal;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.BusinessDataHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.dto.ConfigMap;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.BillStatusEnum;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.vo.TripManVO;

public class TripManDataHelper {
    private static final String ALGO_KEY = TripManDataHelper.class.getName();

    public static TripManVO loadData(ParameterCardDTO dto) {
        try (DataSet tripeqBillDataSet = TripManDataHelper.getTripeqBill(dto);){
            HashSet<String> billNos = new HashSet<String>();
            HashSet<Long> destinations = new HashSet<Long>();
            int days = 0;
            for (Row row : tripeqBillDataSet) {
                billNos.add(row.getString("billno"));
                destinations.add(row.getLong("to"));
                LocalDate startdate = CommonUtils.date2LocalDate(row.getDate("startdate"));
                LocalDate enddate = CommonUtils.date2LocalDate(row.getDate("enddate"));
                days = (int)((long)days + (startdate.until(enddate, ChronoUnit.DAYS) + 1L));
            }
            TripManVO tripManVO = new TripManVO();
            tripManVO.setTripCount(billNos.size());
            tripManVO.setDestinationCount(destinations.size());
            tripManVO.setTripDays(days);
            TripManVO tripManVO2 = tripManVO;
            return tripManVO2;
        }
    }

    private static DataSet getTripeqBill(ParameterCardDTO dto) {
        return BusinessDataHelper.unionDataSet(dto, "em_m_tripman_card", "er_tripreqbill", TripManDataHelper::getTripeqBillDataSet);
    }

    private static DataSet getTripeqBillDataSet(ParameterCardDTO dto, ConfigMap configMap) {
        List<QFilter> qFilters = dto.filterPersonal(configMap.get("applier"));
        qFilters.add(new QFilter(configMap.get("billstatus"), "in", M.arraylist(BillStatusEnum.AUDIDPASS.getValue(), BillStatusEnum.PAID.getValue(), BillStatusEnum.WAITPAYMENT.getValue(), BillStatusEnum.CLOSED.getValue())));
        DateRange dateRange = dto.getDateRange();
        if (dateRange.getStartDate() != null) {
            qFilters.add(new QFilter(configMap.get("bizdate"), ">=", (Object)dateRange.getStartDate()));
        }
        if (dateRange.getEndDate() != null) {
            qFilters.add(new QFilter(configMap.get("bizdate"), "<", (Object)dateRange.getEndDate().plusDays(1L)));
        }
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)configMap.get("er_tripreqbill"), (String)(configMap.get("billno") + " as billno," + configMap.get("tripentry.id") + " as entryid," + configMap.get("tripentry.to") + " as to," + configMap.get("tripentry.startdate") + " as startdate," + configMap.get("tripentry.enddate") + " as enddate"), (QFilter[])qFilters.toArray(new QFilter[0]), null).select("billno,entryid,to,startdate,enddate").distinct();
    }
}

