/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.setting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.dto.ConfigMap;
import kd.fi.er.mobile.util.JsonUtils;

public class CardSettingBussinessHelper {
    public static List<ConfigMap> getConfigMaps(String cardFormId, String entityName) {
        ArrayList<ConfigMap> configs = new ArrayList<ConfigMap>();
        configs.add(new ConfigMap());
        return configs;
    }

    public static Collection<ConfigMap> getExtendsConfigMaps(String cardFormId, String standardEntity) {
        QFilter qFilter = new QFilter("number", "=", (Object)cardFormId).and(new QFilter("extendbill.fbasedataid.standardentity", "=", (Object)standardEntity));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"em_m_setting_card", (String)"extendbill.fbasedataid.standardentity as standardentity,extendbill.fbasedataid.extendconfig as extendconfig", (QFilter[])qFilter.toArray());
        return dynamicObjects.stream().map(dy -> JsonUtils.fromJson(dy.getString("extendconfig"), ConfigMap.class)).collect(Collectors.toList());
    }

    public static QFilter getStandardBill(String standardconfig) {
        if (StringUtils.isNotBlank((CharSequence)standardconfig)) {
            Map<String, String> map = JsonUtils.fromJsonToMap(standardconfig);
            Set<String> strings = map.keySet();
            return new QFilter("standardentity", "in", strings);
        }
        return new QFilter("standardentity", "in", new HashSet());
    }

    public static ConfigMap getStandardConfigMap(String entity) {
        return CardSettingBussinessHelper.getStandardConfigMaps().get(entity);
    }

    public static Map<String, ConfigMap> getStandardConfigMaps() {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"em_m_setting_card", (String)"standardconfig", null);
        HashMap<String, ConfigMap> mergeMapConfig = new HashMap<String, ConfigMap>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String standardConfig = dynamicObject.getString("standardconfig");
            if (StringUtils.isBlank((CharSequence)standardConfig)) continue;
            Map<String, String> map = JsonUtils.fromJsonToMap(standardConfig);
            Set<Map.Entry<String, String>> entries = map.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                ConfigMap configMap = CardSettingBussinessHelper.convertToConfigMap(entry.getValue());
                ConfigMap conf = mergeMapConfig.get(entry.getKey());
                if (conf == null) {
                    mergeMapConfig.put(entry.getKey(), configMap);
                    continue;
                }
                conf.putAll(configMap);
            }
        }
        return mergeMapConfig;
    }

    private static ConfigMap convertToConfigMap(String listStr) {
        String[] split = listStr.split(",");
        Map<String, String> collect = Stream.of(split).collect(Collectors.toMap(s -> s, s -> s));
        ConfigMap configMap = new ConfigMap();
        configMap.putAll(collect);
        return configMap;
    }
}

