/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.trader;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.dto.AirExpenseAnalysisCardDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.util.CommonUtils;

public class AirExpenseAnalysisDataHelper {
    public static final Log logger = LogFactory.getLog(AirExpenseAnalysisDataHelper.class);

    public static List<AirExpenseAnalysisCardDTO> getAirExpenseAnalysisCardDTOLastSixMonth(ParameterCardDTO parameterDTO) {
        LocalDate now = LocalDate.now();
        DataSet dataSetOfLastSixMonth = AirExpenseAnalysisDataHelper.getDataSetByDate(parameterDTO, now.minusMonths(5L).with(TemporalAdjusters.firstDayOfMonth()));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        AmountHandler handler = AmountHelper.get();
        HashMap<String, AirExpenseAnalysisCardDTO> analysisCardDTOMap = new HashMap<String, AirExpenseAnalysisCardDTO>();
        for (Row next : dataSetOfLastSixMonth) {
            LocalDate orderdate = CommonUtils.date2LocalDate(next.getDate("orderdate"));
            long currency = next.getLong("currency");
            AirExpenseAnalysisCardDTO airExpenseAnalysisCardDTO = (AirExpenseAnalysisCardDTO)analysisCardDTOMap.get(formatter.format(orderdate));
            if (airExpenseAnalysisCardDTO == null) {
                airExpenseAnalysisCardDTO = new AirExpenseAnalysisCardDTO();
                airExpenseAnalysisCardDTO.setOrderDate(orderdate.with(TemporalAdjusters.firstDayOfMonth()));
                analysisCardDTOMap.put(formatter.format(orderdate), airExpenseAnalysisCardDTO);
            }
            BigDecimal olderStandardPrice = airExpenseAnalysisCardDTO.getStandardPrice();
            airExpenseAnalysisCardDTO.setStandardPrice(olderStandardPrice.add(handler.convertByCurrency(currency, next.getBigDecimal("standprice"))));
            BigDecimal olderTicketPrice = airExpenseAnalysisCardDTO.getTicketPrice();
            airExpenseAnalysisCardDTO.setTicketPrice(olderTicketPrice.add(handler.convertByCurrency(currency, next.getBigDecimal("ticketprice"))));
            BigDecimal olderLowestPrice = airExpenseAnalysisCardDTO.getLowestPrice();
            BigDecimal lowestpirce = next.getBigDecimal("lowestpirce");
            if (lowestpirce != null) {
                airExpenseAnalysisCardDTO.setLowestPrice(olderLowestPrice.add(handler.convertByCurrency(currency, lowestpirce)));
            }
            int oldNumber = airExpenseAnalysisCardDTO.getNumber();
            airExpenseAnalysisCardDTO.setNumber(++oldNumber);
        }
        for (int i = 0; i <= 5; ++i) {
            LocalDate currentMonth = now.minusMonths(i).with(TemporalAdjusters.firstDayOfMonth());
            String currentMonthStr = formatter.format(currentMonth);
            if (analysisCardDTOMap.get(currentMonthStr) != null) continue;
            AirExpenseAnalysisCardDTO airExpenseAnalysisCardDTO = new AirExpenseAnalysisCardDTO();
            airExpenseAnalysisCardDTO.setOrderDate(currentMonth);
            analysisCardDTOMap.put(currentMonthStr, airExpenseAnalysisCardDTO);
        }
        Collection airExpenseAnalysisCardDTOS = analysisCardDTOMap.values();
        return airExpenseAnalysisCardDTOS.stream().sorted((vo1, vo2) -> vo2.getOrderDate().compareTo(vo1.getOrderDate())).collect(Collectors.toList());
    }

    public static DataSet getDataSetByDate(ParameterCardDTO parameterDTO, LocalDate date) {
        QFilter orgFilter = new QFilter("expcommitcomnum", "in", parameterDTO.getOrgIds());
        QFilter timeFilter = null;
        if (date != null) {
            timeFilter = new QFilter("orderdate", ">=", (Object)date);
        }
        QFilter statusFilter = new QFilter("orderstatus", "in", (Object)new String[]{"40000", "20000", "50301", "50302", "50201", "55555", "55554"});
        QFilter typeFilter = new QFilter("ordertype", "in", (Object)new String[]{"O", "C"});
        return QueryServiceHelper.queryDataSet((String)"ExistAndRebookAnalysisDataHelperService", (String)"er_planebill", (String)"ordernum,parentordernum,currency,ordertype,orderstatus,orderdate,standprice,ticketprice,lowestpirce", (QFilter[])new QFilter[]{orgFilter, timeFilter, statusFilter, typeFilter}, null);
    }
}

