/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.trader;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.dto.AirlinesDTO;
import kd.fi.er.mobile.dto.AirlinesRelationshipAnalysisDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.AirOrderStatusEnum;
import kd.fi.er.mobile.enums.AirOrderTypeEnum;
import kd.fi.er.mobile.util.DateSpanUtils;
import kd.fi.er.mobile.util.JsonUtils;

public class AirlinesRelationshipAnalysisCardHelper {
    public static final Log logger = LogFactory.getLog(AirlinesRelationshipAnalysisCardHelper.class);
    private static final String ALGO_KEY = AirlinesRelationshipAnalysisCardHelper.class.getName();
    private static final String AIR_TICKET_ORDER_NUMBER = "er_planebill";
    private static final String SYSTEM_TYPE = "fi-er-mb-business";
    private static final String QUADRANT_ONE = "area1";
    private static final String QUADRANT_TWO = "area2";
    private static final String QUADRANT_THREE = "area3";
    private static final String QUADRANT_FOUR = "area4";
    private static final String[] colors = new String[]{"#281198", "#CD393B", "#5BC071", "#AA206C", "#FC93D7", "#F91121", "#EF7F88", "#1E49DB", "#CDD89C", "#8C53BC", "#E2CB05", "#BD003B", "#F1FA61", "#5B7664", "#03E53C", "#94FCDC", "#D6DDF2", "#D88A09", "#AFACA3", "#AF452E", "#FE39DE", "#403A04", "#799A8C", "#8670B9", "#B5D064", "#9E2729", "#82A311", "#C30D02", "#029292", "#DA489F", "#0AA9C6", "#7F51F0", "#0671F2", "#826A09", "#319381", "#B89F21", "#CD6698", "#7C19AA", "#7844BD", "#BF8FAA", "#F23394", "#400E85", "#B60E2E", "#E63DF1", "#5DDADE", "#0818D5", "#603563", "#E86E35", "#C3928E", "#A2367C"};

    public static AirlinesRelationshipAnalysisDTO loadData(ParameterCardDTO parameterDTO) {
        logger.info(String.format("AirlinesRelationshipAnalysisCardHelper call loadData, paramDTO:%s", JsonUtils.toJson(parameterDTO)));
        try (DataSet rows = AirlinesRelationshipAnalysisCardHelper.getResultDateSet(parameterDTO);){
            DynamicObjectCollection cols = ORM.create().toPlainDynamicObjectCollection(rows.copy());
            double orderCountAvg = cols.stream().mapToInt(dy -> dy.getInt("orderCount")).average().orElse(0.0);
            double discountAvg = cols.stream().mapToDouble(dy -> dy.getBigDecimal("discount").doubleValue()).average().orElse(0.0);
            int size = cols.size();
            ArrayList<AirlinesDTO> results = new ArrayList<AirlinesDTO>(size);
            int count = 0;
            for (Row row : rows) {
                String airlineName = row.getString("airlinename");
                Integer orderCount = row.getInteger("orderCount");
                BigDecimal discount = row.getBigDecimal("discount").setScale(0, 4);
                results.add(new AirlinesDTO(airlineName, orderCount, discount, colors[count++ % 50]));
            }
            AirlinesRelationshipAnalysisDTO airlinesRelationshipAnalysisDTO = new AirlinesRelationshipAnalysisDTO(results, BigDecimal.valueOf(orderCountAvg).setScale(0, 4), BigDecimal.valueOf(discountAvg).setScale(0, 4));
            return airlinesRelationshipAnalysisDTO;
        }
    }

    public static Map<String, List<AirlinesDTO>> loadDetailData(AirlinesRelationshipAnalysisDTO airlinesDTO) {
        logger.info(String.format("AirlinesRelationshipAnalysisCardHelper call loadDetailData, paramDTO:%s", airlinesDTO));
        HashMap<String, List<AirlinesDTO>> result = new HashMap<String, List<AirlinesDTO>>();
        int size = airlinesDTO.getAirlinesDTOs().size();
        ArrayList<AirlinesDTO> quadrantOneList = new ArrayList<AirlinesDTO>(size);
        ArrayList<AirlinesDTO> quadrantTwoList = new ArrayList<AirlinesDTO>(size);
        ArrayList<AirlinesDTO> quadrantThreeList = new ArrayList<AirlinesDTO>(size);
        ArrayList<AirlinesDTO> quadrantFourList = new ArrayList<AirlinesDTO>(size);
        for (AirlinesDTO dto : airlinesDTO.getAirlinesDTOs()) {
            BigDecimal rate = dto.getDiscountRate();
            BigDecimal count = new BigDecimal(dto.getOrderCount());
            if (rate.compareTo(airlinesDTO.getDiscountAvg()) >= 0) {
                if (count.compareTo(airlinesDTO.getOrderCountAvg()) >= 0) {
                    quadrantOneList.add(dto);
                    continue;
                }
                quadrantTwoList.add(dto);
                continue;
            }
            if (count.compareTo(airlinesDTO.getOrderCountAvg()) >= 0) {
                quadrantFourList.add(dto);
                continue;
            }
            quadrantThreeList.add(dto);
        }
        result.put(QUADRANT_ONE, quadrantOneList);
        result.put(QUADRANT_TWO, quadrantTwoList);
        result.put(QUADRANT_THREE, quadrantThreeList);
        result.put(QUADRANT_FOUR, quadrantFourList);
        return result;
    }

    private static DataSet getResultDateSet(ParameterCardDTO parameterDTO) {
        List<Long> orgIds = parameterDTO.getOrgIds();
        QFilter orgFilter = null;
        if (!CollectionUtils.isEmpty(orgIds)) {
            orgFilter = new QFilter("expcommitcomnum", "in", orgIds);
        }
        QFilter statusFilter = new QFilter("orderstatus", "not in", M.arraylist(AirOrderStatusEnum.TICKET_CANCELLED.getValue(), AirOrderStatusEnum.TICKET_REFUNDED.getValue())).and(new QFilter("ordertype", "in", M.arraylist(AirOrderTypeEnum.ORDER_ORIGINAL.getValue(), AirOrderTypeEnum.ORDER_ADJUSTMENT.getValue())));
        DateRange dateRange = parameterDTO.getDateRange();
        QFilter timeFilter = DateSpanUtils.timeSection("orderdate", dateRange.getStartDate(), dateRange.getEndDate());
        String fields = "airlinename,discount";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)AIR_TICKET_ORDER_NUMBER, (String)fields, (QFilter[])new QFilter[]{orgFilter, statusFilter, timeFilter}, null);
        return dataSet.groupBy(new String[]{"airlinename"}).count("orderCount").avg("discount").finish();
    }

    public static int calcFitMaxValue(Integer maxValue) {
        return AirlinesRelationshipAnalysisCardHelper.calcFitMaxValue(new BigDecimal(maxValue)).intValue();
    }

    public static BigDecimal calcFitMaxValue(BigDecimal maxValue) {
        if (maxValue == null || maxValue.compareTo(new BigDecimal(4)) <= 0) {
            return new BigDecimal(4);
        }
        if (maxValue.compareTo(BigDecimal.TEN) <= 0) {
            return new BigDecimal(12);
        }
        int count = 0;
        BigDecimal current = maxValue;
        do {
            current = current.divideToIntegralValue(BigDecimal.TEN);
            ++count;
        } while (current.compareTo(BigDecimal.TEN) >= 0);
        current = current.remainder(new BigDecimal(2)).compareTo(BigDecimal.ZERO) > 0 ? current.add(BigDecimal.ONE) : current.add(new BigDecimal(2));
        return current.multiply(BigDecimal.TEN.pow(count)).setScale(0, RoundingMode.UNNECESSARY);
    }

    public static Map<String, Object> getScatterChartData(AirlinesRelationshipAnalysisDTO dto, String area) {
        BigDecimal maxDiscountRate = BigDecimal.ZERO;
        Integer maxOrderCount = 0;
        ArrayList seriesData = new ArrayList();
        List<AirlinesDTO> airlinesDTOs = dto.getAirlinesDTOs();
        for (int i = 0; i < airlinesDTOs.size(); ++i) {
            AirlinesDTO e = airlinesDTOs.get(i);
            BigDecimal discountRate = e.getDiscountRate();
            Integer orderCount = e.getOrderCount();
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("value", new Object[]{orderCount, discountRate});
            itemMap.put("name", e.getAirlineName());
            itemMap.put("rate", discountRate);
            itemMap.put("count", orderCount);
            itemMap.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", e.getColor())));
            seriesData.add(itemMap);
            if (discountRate.compareTo(maxDiscountRate) > 0) {
                maxDiscountRate = discountRate;
            }
            if (orderCount <= maxOrderCount) continue;
            maxOrderCount = orderCount;
        }
        int maxValueOfXAxis = AirlinesRelationshipAnalysisCardHelper.calcFitMaxValue(maxOrderCount);
        HashMap<String, Object> chartData = new HashMap<String, Object>();
        HashMap<String, String> gridMap = new HashMap<String, String>();
        gridMap.put("top", "8%");
        gridMap.put("right", "8%");
        chartData.put("grid", gridMap);
        HashMap<String, Object> tooltipMap = new HashMap<String, Object>();
        tooltipMap.put("show", Boolean.TRUE);
        tooltipMap.put("position", "inside");
        tooltipMap.put("trigger", "item");
        String orderCountStr = ResManager.loadKDString((String)"\u8ba2\u5355\u91cf\uff1a", (String)"AirlinesRelationshipAnalysisCardHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String discountRateStr = ResManager.loadKDString((String)"\u5e73\u5747\u6298\u6263\u7387\uff1a", (String)"AirlinesRelationshipAnalysisCardHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        tooltipMap.put("formatter", "function(i) {return i.data.name + '<br />" + orderCountStr + "' + i.data.count + '<br />" + discountRateStr + "' + i.data.rate.toFixed(0) + '%';}");
        chartData.put("tooltip", tooltipMap);
        HashMap<String, Object> xAxisMap = new HashMap<String, Object>();
        xAxisMap.put("name", "");
        xAxisMap.put("nameLocation", "center");
        xAxisMap.put("nameGap", 24);
        xAxisMap.put("type", "value");
        xAxisMap.put("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        xAxisMap.put("splitLine", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> xAxisLineMap = new HashMap<String, Object>();
        xAxisLineMap.put("show", Boolean.TRUE);
        xAxisLineMap.put("symbol", new String[]{"none", "arrow"});
        xAxisLineMap.put("symbolSize", new int[]{8, 8});
        xAxisLineMap.put("lineStyle", Collections.singletonMap("color", "#999999"));
        xAxisMap.put("axisLine", xAxisLineMap);
        xAxisMap.put("interval", maxValueOfXAxis / 4);
        xAxisMap.put("max", maxValueOfXAxis);
        chartData.put("xAxis", new HashMap[]{xAxisMap});
        HashMap<String, Object> yAxisMap = new HashMap<String, Object>();
        yAxisMap.put("name", "");
        yAxisMap.put("nameGap", 22);
        yAxisMap.put("type", "value");
        yAxisMap.put("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        yAxisMap.put("splitLine", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> yAxisLineMap = new HashMap<String, Object>();
        yAxisLineMap.put("show", Boolean.TRUE);
        yAxisLineMap.put("symbol", new String[]{"none", "arrow"});
        yAxisLineMap.put("symbolSize", new int[]{8, 8});
        yAxisLineMap.put("lineStyle", Collections.singletonMap("color", "#999999"));
        yAxisMap.put("axisLine", yAxisLineMap);
        yAxisMap.put("max", 100);
        yAxisMap.put("interval", 25);
        yAxisMap.put("axisLabel", Collections.singletonMap("formatter", "function(v, i) {return v.toFixed(0)}"));
        chartData.put("yAxis", new HashMap[]{yAxisMap});
        HashMap<String, Object> seriesMap = new HashMap<String, Object>();
        seriesMap.put("type", "scatter");
        seriesMap.put("data", seriesData);
        seriesMap.put("markArea", AirlinesRelationshipAnalysisCardHelper.markAreaBySelectedTag(area, dto));
        HashMap<String, Object> markLineMap = new HashMap<String, Object>();
        markLineMap.put("silent", Boolean.TRUE);
        markLineMap.put("symbol", "none");
        markLineMap.put("precision", 0);
        markLineMap.put("tooltip", Collections.singletonMap("show", Boolean.FALSE));
        HashMap<String, Object> lineStyleMap = new HashMap<String, Object>();
        lineStyleMap.put("type", "dashed");
        lineStyleMap.put("normal", Collections.singletonMap("color", "#999999"));
        markLineMap.put("lineStyle", lineStyleMap);
        HashMap<String, String> markLineDataMap1 = new HashMap<String, String>();
        markLineDataMap1.put("type", "average");
        HashMap<String, Object> markLineDataMap2 = new HashMap<String, Object>();
        markLineDataMap2.put("type", "average");
        markLineDataMap2.put("valueIndex", 0);
        markLineMap.put("data", new HashMap[]{markLineDataMap1, markLineDataMap2});
        seriesMap.put("markLine", markLineMap);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        ArrayList<Object> yAxisLabelFuncPath = new ArrayList<Object>();
        yAxisLabelFuncPath.add("yAxis");
        yAxisLabelFuncPath.add(0);
        yAxisLabelFuncPath.add("axisLabel");
        yAxisLabelFuncPath.add("formatter");
        chartData.put("functions", new Object[]{toolTipFuncPath, yAxisLabelFuncPath});
        chartData.put("series", new HashMap[]{seriesMap});
        return chartData;
    }

    public static Map<String, Object> markAreaBySelectedTag(String area, AirlinesRelationshipAnalysisDTO dto) {
        HashMap<String, Object> beginPoint = new HashMap<String, Object>();
        HashMap<String, String> endPoint = new HashMap<String, String>();
        DecimalFormat df = new DecimalFormat("#");
        String orderCountAvg = df.format(dto.getOrderCountAvg());
        String discountAvg = df.format(dto.getDiscountAvg());
        if (QUADRANT_ONE.equals(area)) {
            beginPoint.put("xAxis", orderCountAvg);
            beginPoint.put("yAxis", discountAvg);
        } else if (QUADRANT_TWO.equals(area)) {
            beginPoint.put("xAxis", 0.02);
            beginPoint.put("yAxis", discountAvg);
            endPoint.put("xAxis", orderCountAvg);
        } else if (QUADRANT_THREE.equals(area)) {
            beginPoint.put("xAxis", 0.02);
            beginPoint.put("yAxis", 0.02);
            endPoint.put("xAxis", orderCountAvg);
            endPoint.put("yAxis", discountAvg);
        } else if (QUADRANT_FOUR.equals(area)) {
            beginPoint.put("xAxis", orderCountAvg);
            beginPoint.put("yAxis", 0.02);
            endPoint.put("yAxis", discountAvg);
        }
        HashMap<String, Object> markAreaMap = new HashMap<String, Object>();
        markAreaMap.put("silent", Boolean.TRUE);
        markAreaMap.put("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", "#CDFEFC")));
        markAreaMap.put("data", new Object[]{new Object[]{beginPoint, endPoint}});
        return markAreaMap;
    }
}

