/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.trader;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.enums.DaysSlotEnum;
import kd.fi.er.mobile.enums.DiscountSlotEnum;
import kd.fi.er.mobile.service.trader.AirplaneDiscountScenceProvide;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.vo.DataChartListVO;
import kd.fi.er.mobile.vo.DataVO;
import kd.fi.er.mobile.vo.IChartTextFormatter;
import kd.fi.er.mobile.vo.RightSeriesVO;

public class AirplaneDiscountDataHelper {
    private static final String ALGO_KEY = AirplaneDiscountDataHelper.class.getName();

    public static DataChartListVO loadData(ParameterCardDTO dto) {
        List<QFilter> qFilters = dto.filterOrg("expcommitcomnum");
        try (DataSet dataSet = AirplaneDiscountDataHelper.getErPlaneBillDaysDiscountDataSet(qFilters);){
            Map<Integer, DataVO> map = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).filter(row -> row.getInteger("days") <= 30).map(row -> {
                DataVO vo = new DataVO();
                vo.setCount(row.getLong("id"));
                vo.setValue0(row.getInteger("days"));
                vo.setItemname(AirplaneDiscountDataHelper.createItemName(vo.getValue0()));
                vo.putExt("ticketprice", row.getBigDecimal("ticketprice"));
                vo.putExt("standprice", row.getBigDecimal("standprice"));
                vo.setValue(row.getBigDecimal("ticketprice").divide(row.getBigDecimal("standprice"), 10, 4).multiply(new BigDecimal("100")));
                vo.setItemvalue(vo.getValue().setScale(1, 4) + "%");
                return vo;
            }).collect(Collectors.toMap(DataVO::getValue0, o -> o));
            Collection<DataVO> values = map.values();
            long countSum = values.stream().mapToLong(DataVO::getCount).sum();
            int daysSum = values.stream().mapToInt(value -> (int)((long)value.getValue0().intValue() * value.getCount())).sum();
            double ticketprice = values.stream().mapToDouble(value -> ((BigDecimal)value.getExt("ticketprice")).doubleValue()).sum();
            double standprice = values.stream().mapToDouble(value -> ((BigDecimal)value.getExt("standprice")).doubleValue()).sum();
            DataChartListVO data = new DataChartListVO();
            BigDecimal avgDays = AirplaneDiscountDataHelper.avg(daysSum, countSum);
            BigDecimal avgDiscount = AirplaneDiscountDataHelper.divide(ticketprice, standprice).multiply(new BigDecimal("100"));
            data.putExt("avgDays", avgDays);
            data.putExt("avgDiscount", avgDiscount);
            String avgDaysStr = String.format(ResManager.loadKDString((String)"%s\u5929", (String)"AirplaneDiscountDataHelper_8", (String)"fi-er-mb-business", (Object[])new Object[0]), avgDays.setScale(1, RoundingMode.HALF_UP));
            String avgDiscountStr = avgDiscount.setScale(1, RoundingMode.HALF_UP) + "%";
            data.putExt("avgDaysStr", avgDaysStr);
            data.putExt("avgDiscountStr", avgDiscountStr);
            data.setDatas(new ArrayList<DataVO>(values));
            String suggest = new AirplaneDiscountScenceProvide().getSuggest(data);
            data.setSuggest(suggest);
            data.setDatas(AirplaneDiscountDataHelper.fillVOS(map));
            data.setFormatter(new IChartTextFormatter(){

                @Override
                public String formatTip(DataVO vo) {
                    return String.format(ResManager.loadKDString((String)"\u63d0\u524d\u9884\u8ba2\u5929\u6570: %1$s<br/>\u5e73\u5747\u6298\u6263: %2$s", (String)"AirplaneDiscountDataHelper_9", (String)"fi-er-mb-business", (Object[])new Object[0]), vo.getItemname(), vo.getItemvalue());
                }
            });
            DataChartListVO dataChartListVO = data;
            return dataChartListVO;
        }
    }

    /*
     * Exception decompiling
     */
    public static DataChartListVO loadDaysListData(ParameterCardDTO dto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DataChartListVO loadDiscountListData(ParameterCardDTO dto) {
        List<QFilter> qFilters = dto.filterOrg("expcommitcomnum");
        try (DataSet dataSet = AirplaneDiscountDataHelper.getErPlaneBillDaysDiscountDataSet(qFilters);){
            Map<String, LongSummaryStatistics> collect = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).filter(row -> row.getInteger("days") <= 30).map(row -> {
                DataVO vo = new DataVO();
                vo.setCount(row.getLong("id"));
                vo.setValue0(row.getInteger("days"));
                vo.setItemname(AirplaneDiscountDataHelper.createItemName(vo.getValue0()));
                vo.putExt("ticketprice", row.getBigDecimal("ticketprice"));
                vo.putExt("standprice", row.getBigDecimal("standprice"));
                vo.setValue(row.getBigDecimal("ticketprice").divide(row.getBigDecimal("standprice"), 10, 4).multiply(new BigDecimal("100")));
                return vo;
            }).collect(Collectors.groupingBy(vo -> DiscountSlotEnum.getSolt(vo.getValue().doubleValue()).name(), Collectors.summarizingLong(DataVO::getCount)));
            long totalCount = 0L;
            DiscountSlotEnum[] values = DiscountSlotEnum.values();
            ArrayList<DataVO> list = new ArrayList<DataVO>(values.length);
            String format = ResManager.loadKDString((String)"%s\u5f20", (String)"AirplaneDiscountDataHelper_3", (String)"fi-er-mb-business", (Object[])new Object[0]);
            for (DiscountSlotEnum value : values) {
                LongSummaryStatistics statistics = collect.get(value.name());
                DataVO vo2 = new DataVO();
                vo2.setItemname(value.getDesc());
                if (statistics != null) {
                    long sum = statistics.getSum();
                    totalCount += sum;
                    vo2.setCount(sum);
                } else {
                    vo2.setCount(0L);
                }
                vo2.setValue(new BigDecimal(vo2.getCount()));
                vo2.setItemvalue(String.format(format, vo2.getCount()));
                list.add(vo2);
            }
            for (DataVO vo3 : list) {
                long count = vo3.getCount();
                BigDecimal percent = CommonUtils.dividePercent(count, totalCount, 0);
                vo3.setValue2(percent);
                vo3.setItemvalue2(percent + "%");
            }
            DataChartListVO data = new DataChartListVO();
            data.setSeriesName(ResManager.loadKDString((String)"\u7968\u5f20\u6570", (String)"AirplaneDiscountDataHelper_4", (String)"fi-er-mb-business", (Object[])new Object[0]));
            RightSeriesVO series = new RightSeriesVO();
            series.setSeriesName(ResManager.loadKDString((String)"\u7968\u5f20\u5360\u6bd4", (String)"AirplaneDiscountDataHelper_5", (String)"fi-er-mb-business", (Object[])new Object[0]));
            series.setyName(ResManager.loadKDString((String)"\u7968\u5f20\u5360\u6bd4", (String)"AirplaneDiscountDataHelper_5", (String)"fi-er-mb-business", (Object[])new Object[0]));
            data.setRightSeries(series);
            data.setDatas(list);
            data.setTooltipFormatter("function(params){ var arr = params[0].data; return arr.text; }");
            data.setFormatter(new IChartTextFormatter(){

                @Override
                public String formatTip(DataVO vo) {
                    return String.format(ResManager.loadKDString((String)"\u7968\u5f20\u6570: %1$s<br/>\u7968\u5f20\u5360\u6bd4: %2$s", (String)"AirplaneDiscountDataHelper_10", (String)"fi-er-mb-business", (Object[])new Object[0]), vo.getItemvalue(), vo.getItemvalue2());
                }
            });
            DataChartListVO dataChartListVO = data;
            return dataChartListVO;
        }
    }

    private static BigDecimal avg(double sum, long count) {
        if (count == 0L) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(sum).divide(new BigDecimal(count), 10, 4);
    }

    private static BigDecimal divide(double a, double b) {
        if (Double.compare(b, 0.0) == 0) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(a).divide(BigDecimal.valueOf(b), 10, 4);
    }

    private static List<DataVO> fillVOS(Map<Integer, DataVO> map) {
        ArrayList<DataVO> vos = new ArrayList<DataVO>(31);
        for (int i = 0; i < 31; ++i) {
            DataVO vo = map.get(i);
            if (vo == null) {
                vo = new DataVO();
                vo.setValue0(i);
                vo.setItemname(AirplaneDiscountDataHelper.createItemName(i));
                vo.setItemvalue("-");
                vo.setValue2(BigDecimal.ZERO);
                vo.setCount(0L);
                vo.setValue(BigDecimal.ZERO);
            }
            vos.add(vo);
        }
        return vos;
    }

    private static String createItemName(Integer days) {
        return String.format(ResManager.loadKDString((String)"%s\u5929", (String)"AirplaneDiscountDataHelper_8", (String)"fi-er-mb-business", (Object[])new Object[0]), days);
    }

    public static DataSet getErPlaneBillDaysDiscountDataSet(List<QFilter> filters) {
        String selectFields = "id,orderdate,takeofftime,ticketprice,standprice";
        return AirplaneDiscountDataHelper.getErPlaneBillDataSet(filters, selectFields).select(new String[]{"DATEDIF(orderdate,takeofftime,'D') as days", "ticketprice", "standprice"}).groupBy(new String[]{"days"}).sum("ticketprice").sum("standprice").count("id").finish().orderBy(new String[]{"days asc"});
    }

    public static DataSet getErPlaneBillDataSet(List<QFilter> filters, String selectFields) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(filters);
        qFilters.add(new QFilter("ordertype", "!=", (Object)"T"));
        qFilters.add(new QFilter("orderstatus", "in", (Object)new String[]{"40000", "20000", "50301", "50302", "50201", "55555", "55554"}));
        qFilters.add(new QFilter("standprice", ">", (Object)0));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"er_planebill", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    private static /* synthetic */ String lambda$loadDaysListData$8(DataVO vo) {
        return DaysSlotEnum.getSolt(vo.getValue0()).name();
    }

    private static /* synthetic */ DataVO lambda$loadDaysListData$7(Row row) {
        DataVO vo = new DataVO();
        Integer days = row.getInteger("days");
        vo.setValue0(days);
        vo.setItemname(AirplaneDiscountDataHelper.createItemName(vo.getValue0()));
        vo.setCount(row.getLong("id"));
        return vo;
    }

    private static /* synthetic */ boolean lambda$loadDaysListData$6(Row row) {
        return row.getInteger("days") <= 30;
    }
}

