/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.trader;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.dto.ExistAndRebookCardDTO;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.util.CommonUtils;

public class ExistAndRebookAnalysisDataHelperService {
    public static final Log logger = LogFactory.getLog(ExistAndRebookAnalysisDataHelperService.class);

    public static Collection<ExistAndRebookCardDTO> getExistAndRebookCardDTOs(ParameterCardDTO parameterDTO, LocalDate date, String type) {
        DataSet dataSet;
        QFilter orgFilter = new QFilter("expcommitcomnum", "in", parameterDTO.getOrgIds());
        QFilter timeFilter = null;
        timeFilter = date != null ? new QFilter("orderdate", ">=", (Object)date) : new QFilter("orderdate", "is not null", null);
        QFilter statusFilter = new QFilter("orderstatus", "!=", (Object)"30000");
        switch (type) {
            case "1": {
                dataSet = QueryServiceHelper.queryDataSet((String)"ExistAndRebookAnalysisDataHelperService", (String)"er_planebill", (String)"ordernum,parentordernum,currency,ordertype,orderstatus,orderdate,totalamount,refundamount,servicefee", (QFilter[])new QFilter[]{orgFilter, timeFilter, statusFilter}, null);
                break;
            }
            case "2": {
                dataSet = QueryServiceHelper.queryDataSet((String)"ExistAndRebookAnalysisDataHelperService", (String)"er_trainbill", (String)"ordernum,parentordernum,currency,ordertype,orderstatus,orderdate,totalamount,refundamount,servicefee", (QFilter[])new QFilter[]{orgFilter, timeFilter}, null);
                break;
            }
            default: {
                return new ArrayList<ExistAndRebookCardDTO>();
            }
        }
        HashMap<String, ExistAndRebookCardDTO> existAndRebookCardDTOMap = new HashMap<String, ExistAndRebookCardDTO>();
        DataSet originDataSet = dataSet.copy().filter("ordertype = 'O' or ordertype = 'C'");
        for (Row row : originDataSet) {
            ExistAndRebookCardDTO existAndRebookCardDTO = new ExistAndRebookCardDTO();
            existAndRebookCardDTO.setOrderNumber(row.getString("ordernum"));
            existAndRebookCardDTO.setOrderDate(CommonUtils.date2LocalDate(row.getDate("orderdate")));
            existAndRebookCardDTOMap.put(existAndRebookCardDTO.getOrderNumber(), existAndRebookCardDTO);
        }
        DataSet existOrRebookDataSet = dataSet.copy().filter("ordertype = 'T' or ordertype = 'G'");
        for (Row row : existOrRebookDataSet) {
            BigDecimal newRebookCost;
            ExistAndRebookCardDTO existAndRebookCardDTO;
            String parentordernum = row.getString("parentordernum");
            Row rowByOrderNum = ExistAndRebookAnalysisDataHelperService.getRowByOrderNum(dataSet.copy(), parentordernum);
            while (rowByOrderNum != null && ("T".equals(rowByOrderNum.getString("ordertype")) || "G".equals(rowByOrderNum.getString("ordertype")))) {
                parentordernum = rowByOrderNum.getString("parentordernum");
                if (rowByOrderNum.getString("ordernum").equals(parentordernum)) {
                    parentordernum = "-1";
                    break;
                }
                rowByOrderNum = ExistAndRebookAnalysisDataHelperService.getRowByOrderNum(dataSet.copy(), parentordernum);
            }
            if ((existAndRebookCardDTO = (ExistAndRebookCardDTO)existAndRebookCardDTOMap.get(parentordernum)) == null) continue;
            if ("T".equals(row.getString("ordertype"))) {
                Set<String> existOrderNumber = existAndRebookCardDTO.getExistOrderNumber();
                existOrderNumber.add(row.getString("ordernum"));
                BigDecimal oldExistCost = existAndRebookCardDTO.getExistCost();
                newRebookCost = oldExistCost.add(AmountHelper.convertByCurrency(row.getLong("currency"), row.getBigDecimal("refundamount").add(row.getBigDecimal("servicefee"))));
                existAndRebookCardDTO.setExistCost(newRebookCost);
            } else {
                Set<String> rebookOrderNumber = existAndRebookCardDTO.getRebookOrderNumber();
                rebookOrderNumber.add(row.getString("ordernum"));
                BigDecimal oldRebookCost = existAndRebookCardDTO.getRebookCost();
                newRebookCost = oldRebookCost.add(AmountHelper.convertByCurrency(row.getLong("currency"), row.getBigDecimal("totalamount")));
                existAndRebookCardDTO.setRebookCost(newRebookCost);
            }
            existAndRebookCardDTO.setExistOrRebook(true);
        }
        return existAndRebookCardDTOMap.values();
    }

    private static Row getRowByOrderNum(DataSet dataSet, String orderNum) {
        DataSet filter = dataSet.filter("ordernum = orderNum", M.map("orderNum", orderNum));
        if (filter.hasNext()) {
            return filter.next();
        }
        return null;
    }
}

