/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.trader;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.er.mobile.basedata.BaseDataHelper;
import kd.fi.er.mobile.basedata.org.OrgGroup;
import kd.fi.er.mobile.basedata.org.OrgNodeBuilder;
import kd.fi.er.mobile.basedata.org.OrgTreeNode;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.common.BusinessDataHelper;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.enums.UnitEnum;
import kd.fi.er.mobile.service.analyse.data.HeadDataModel;
import kd.fi.er.mobile.service.analyse.data.IModelItem;
import kd.fi.er.mobile.service.analyse.data.ItemModel;
import kd.fi.er.mobile.service.analyse.data.ListDataModel;
import kd.fi.er.mobile.service.analyse.data.NextListTransferData;
import kd.fi.er.mobile.service.trader.TraderBillOverallDataHelper;
import kd.fi.er.mobile.stream.MapDoubleSummaryStatisticsFunction;
import kd.fi.er.mobile.stream.RowToDoubleFunction;

public class TraderBillOverallAnalyseDataHelper {
    public static HeadDataModel loadHeadData(NextListTransferData transferData) {
        ParameterCardDTO dto = transferData.getCardParameter();
        AmountHandler handler = AmountHelper.get(dto.getConvertDTO());
        List<QFilter> qFilters = dto.filterRange("expcommitcomnum", "orderdate");
        String selectFields = "totalamount,currency";
        try (DataSet dataSet = TraderBillOverallAnalyseDataHelper.getFilterDataSet(qFilters, transferData.getFilter(), selectFields).groupBy(new String[]{"currency"}).sum("totalamount").finish();){
            BigDecimal totalAmount = TraderBillOverallAnalyseDataHelper.calTotalAmount(dataSet, handler);
            SignAmount signAmount = handler.getSignAmount(totalAmount);
            HeadDataModel model = new HeadDataModel();
            model.setName1(ResManager.loadKDString((String)"\u6d88\u8d39\u91d1\u989d", (String)"TraderBillOverallAnalyseDataHelper_0", (String)"fi-er-mb-business", (Object[])new Object[0]));
            model.setValue1(signAmount.getText());
            HeadDataModel headDataModel = model;
            return headDataModel;
        }
    }

    public static ListDataModel structureAnalyse(NextListTransferData transferData) {
        ParameterCardDTO dto = transferData.getCardParameter();
        AmountHandler handler = AmountHelper.get(dto.getConvertDTO());
        List<Long> orgIds = dto.getOrgIds();
        OrgTreeNode orgTopNode = new OrgNodeBuilder(orgIds).getTopNode();
        OrgTreeNode node = orgTopNode.getNodeById(transferData.getLastGroupById());
        dto.setOrgIds(new ArrayList<Long>(node.childOrgIds()));
        List<QFilter> qFilters = dto.filterRange("expcommitcomnum", "orderdate");
        String selectFields = "expcommitcomnum,totalamount,currency";
        try (DataSet dataSet = TraderBillOverallAnalyseDataHelper.getFilterDataSet(qFilters, transferData.getFilter(), selectFields).groupBy(new String[]{"expcommitcomnum", "currency"}).sum("totalamount").finish();){
            HashMap<Long, OrgGroup> groupingMap = node.groupingMap();
            List<Long> longs = groupingMap.values().stream().map(OrgGroup::getId).collect(Collectors.toList());
            Map<Long, String> baseData = BaseDataHelper.getBaseData("orgid", longs);
            Map<Long, DoubleSummaryStatistics> collect = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).collect(Collectors.groupingBy(row -> {
                Long org = row.getLong("expcommitcomnum");
                return ((OrgGroup)groupingMap.get(org)).getId();
            }, Collectors.summarizingDouble(new RowToDoubleFunction(handler, "totalamount"))));
            Set<Map.Entry<Long, DoubleSummaryStatistics>> entries = collect.entrySet();
            List<ItemModel> list = entries.stream().map(entry -> {
                ItemModel item = new ItemModel();
                item.setGroupid((Long)entry.getKey());
                item.setItemname(baseData.getOrDefault(entry.getKey(), entry.getKey() + ""));
                DoubleSummaryStatistics statistics = (DoubleSummaryStatistics)entry.getValue();
                double sumAmount = statistics.getSum();
                SignAmount signAmount = handler.getSignAmount(sumAmount);
                item.setSignAmount(signAmount);
                item.setItemvalue(signAmount.getText() + "");
                Boolean isLeaf = Optional.ofNullable(groupingMap.get(item.getGroupid())).map(OrgGroup::isLeaf).orElse(Boolean.FALSE);
                item.setHaveMore(isLeaf != false ? 0 : 1);
                return item;
            }).sorted().collect(Collectors.toList());
            double max = BusinessDataHelper.getMax(list);
            UnitEnum maxUnitEnum = handler.getUnitEnum(max);
            for (IModelItem listDataModel : list) {
                listDataModel.getSignAmount().revertToMaxUnit(maxUnitEnum);
            }
            ListDataModel data = new ListDataModel();
            data.setSeriesName(ResManager.loadKDString((String)"\u6d88\u8d39\u91d1\u989d", (String)"TraderBillOverallAnalyseDataHelper_0", (String)"fi-er-mb-business", (Object[])new Object[0]));
            data.setyName(maxUnitEnum.getDesc());
            data.setChartTitle(ResManager.loadKDString((String)"\u6d88\u8d39\u91d1\u989dTOP5", (String)"TraderBillOverallAnalyseDataHelper_1", (String)"fi-er-mb-business", (Object[])new Object[0]));
            data.setDatas(list);
            data.setChartLimit(5);
            data.setTooltipFormatter("");
            data.setNoDataTip(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u672a\u53d1\u73b0\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u6761\u4ef6", (String)"TraderBillOverallAnalyseDataHelper_2", (String)"fi-er-mb-business", (Object[])new Object[0]));
            ListDataModel listDataModel = data;
            return listDataModel;
        }
    }

    public static ListDataModel loadTrendData(NextListTransferData transferData) {
        ParameterCardDTO dto = transferData.getCardParameter();
        AmountHandler handler = AmountHelper.get(dto.getConvertDTO());
        List<QFilter> qFilters = dto.filterOrg("expcommitcomnum");
        String selectFields = "orderdate,totalamount,currency";
        try (DataSet dataSet = TraderBillOverallAnalyseDataHelper.getFilterDataSet(qFilters, transferData.getFilter(), selectFields).select(new String[]{"TO_CHAR(orderdate,\"yyyy-MM\") as month", "totalamount", "currency"}).groupBy(new String[]{"month", "currency"}).sum("totalamount").finish();){
            Map<String, DoubleSummaryStatistics> collect = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).collect(Collectors.groupingBy(row -> row.getString("month"), Collectors.summarizingDouble(new RowToDoubleFunction(handler, "totalamount"))));
            Set<Map.Entry<String, DoubleSummaryStatistics>> entries = collect.entrySet();
            List<ItemModel> list = entries.stream().map(new MapDoubleSummaryStatisticsFunction(handler)).sorted((o1, o2) -> -o1.getItemname().compareTo(o2.getItemname())).collect(Collectors.toList());
            double max = BusinessDataHelper.getMax(list);
            UnitEnum maxUnitEnum = handler.getUnitEnum(max);
            for (ItemModel item : list) {
                item.getSignAmount().revertToMaxUnit(maxUnitEnum);
            }
            ListDataModel data = new ListDataModel();
            data.setSeriesType("LineSeries");
            data.setSeriesName(ResManager.loadKDString((String)"\u6d88\u8d39\u91d1\u989d", (String)"TraderBillOverallAnalyseDataHelper_0", (String)"fi-er-mb-business", (Object[])new Object[0]));
            data.setyName(maxUnitEnum.getDesc());
            data.setChartTitle(ResManager.loadKDString((String)"\u6d88\u8d39\u91d1\u989d\u8d8b\u52bf", (String)"TraderBillOverallAnalyseDataHelper_3", (String)"fi-er-mb-business", (Object[])new Object[0]));
            data.setDatas(TraderBillOverallAnalyseDataHelper.buildDatas(list, handler.getSignAmount(BigDecimal.ZERO)));
            data.setChartLimit(6);
            data.setTooltipFormatter("");
            data.setNoDataTip(ResManager.loadKDString((String)"\u8fd16\u4e2a\u6708\u672a\u53d1\u73b0\u8ba2\u5355\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u6216\u5207\u6362\u6761\u4ef6", (String)"TraderBillOverallAnalyseDataHelper_4", (String)"fi-er-mb-business", (Object[])new Object[0]));
            ListDataModel listDataModel = data;
            return listDataModel;
        }
    }

    protected static List<ItemModel> buildDatas(List<ItemModel> items, SignAmount zeroSignAmount) {
        if (items.isEmpty()) {
            return items;
        }
        Map<String, ItemModel> itemMap = items.stream().collect(Collectors.toMap(ItemModel::getItemname, o -> o));
        ItemModel itemModel = items.get(items.size() - 1);
        String itemname = itemModel.getItemname();
        ArrayList<ItemModel> results = new ArrayList<ItemModel>(items.size());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate startDate = LocalDate.parse(itemname + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate pDate = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        for (int i = 0; i < 6 || pDate.getYear() * 100 + pDate.getMonthValue() >= startDate.getYear() * 100 + startDate.getMonthValue(); ++i) {
            String name = pDate.format(dateTimeFormatter);
            ItemModel item = itemMap.get(name);
            if (item == null) {
                item = new ItemModel();
                item.setItemname(name);
                item.setSignAmount(zeroSignAmount);
                item.setItemvalue(zeroSignAmount.getText());
            }
            results.add(item);
            pDate = pDate.minusMonths(1L);
        }
        return results;
    }

    private static BigDecimal calTotalAmount(DataSet dataSet, AmountHandler handler) {
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (Row row : dataSet) {
            Long currency = row.getLong("currency");
            BigDecimal totalamount = row.getBigDecimal("totalamount");
            BigDecimal targetAmount = handler.convertByCurrency(currency, totalamount);
            sumAmount = sumAmount.add(targetAmount);
        }
        return sumAmount;
    }

    public static DataSet getFilterDataSet(List<QFilter> qFilters, String filter, String selectFields) {
        if ("er_planebill".equals(filter)) {
            return TraderBillOverallDataHelper.getErPlaneBillDataSet(qFilters, selectFields);
        }
        if ("er_hotelbill".equals(filter)) {
            return TraderBillOverallDataHelper.getErHotelBillDataSet(qFilters, selectFields);
        }
        if ("er_trainbill".equals(filter)) {
            return TraderBillOverallDataHelper.getErTrainBillDataSet(qFilters, selectFields);
        }
        if ("er_vehiclebill".equals(filter)) {
            return TraderBillOverallDataHelper.getErVehicBillDataSet(qFilters, selectFields);
        }
        return TraderBillOverallDataHelper.getErPlaneBillDataSet(qFilters, selectFields).union(TraderBillOverallDataHelper.getErHotelBillDataSet(qFilters, selectFields)).union(TraderBillOverallDataHelper.getErTrainBillDataSet(qFilters, selectFields)).union(TraderBillOverallDataHelper.getErVehicBillDataSet(qFilters, selectFields));
    }
}

