/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.trader;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.DateRangeUtils;
import kd.fi.er.mobile.datarange.DateRangeWrapper;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.SignAmount;
import kd.fi.er.mobile.stream.RowToDoubleFunction;
import kd.fi.er.mobile.vo.CompareRateVO;
import kd.fi.er.mobile.vo.TraderOverallVO;

public class TraderBillOverallDataHelper {
    private static final String ALGO_KEY = TraderBillOverallDataHelper.class.getName();

    /*
     * Exception decompiling
     */
    public static TraderOverallVO loadData(ParameterCardDTO dto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CompareRateVO calItemVOByDs(DataSet dataSet, AmountHandler handler, DateRange dateRange) {
        DateRangeWrapper wrapper = new DateRangeWrapper(dateRange);
        BigDecimal currTotalAmount = TraderBillOverallDataHelper.calTotalAmount(dataSet.copy(), handler, dateRange.getStartDate(), dateRange.getEndDate());
        SignAmount signAmount = handler.getSignAmount(currTotalAmount);
        CompareRateVO itemVO = new CompareRateVO(signAmount);
        if (wrapper.canCompareToPrevious()) {
            BigDecimal previousTotalAmount = TraderBillOverallDataHelper.calTotalAmount(dataSet.copy(), handler, wrapper.getPreviousStartDate(), wrapper.getPreviousEndDate());
            itemVO.setPreviousSignAmount(handler.getSignAmount(previousTotalAmount));
        }
        if (wrapper.canCompareToLink()) {
            BigDecimal linkTotalAmount = TraderBillOverallDataHelper.calTotalAmount(dataSet.copy(), handler, wrapper.getLinkStartDate(), wrapper.getLinkEndDate());
            itemVO.setLinkSignAmount(handler.getSignAmount(linkTotalAmount));
        }
        return itemVO;
    }

    private static BigDecimal calTotalAmount(DataSet dateSet, AmountHandler handler, LocalDate startDate, LocalDate endDate) {
        try (DataSet dataSet = DateRangeUtils.filterDataSet(dateSet, "orderdate", startDate, endDate).groupBy(new String[]{"currency"}).sum("totalamount").finish();){
            DoubleSummaryStatistics statistics = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).collect(Collectors.summarizingDouble(new RowToDoubleFunction(handler, "totalamount")));
            BigDecimal bigDecimal = BigDecimal.valueOf(statistics.getSum());
            return bigDecimal;
        }
    }

    public static DataSet getErPlaneBillDataSet(List<QFilter> filters, String selectFields) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(filters);
        qFilters.add(new QFilter("orderstatus", "!=", (Object)"30000"));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"er_planebill", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    public static DataSet getErHotelBillDataSet(List<QFilter> filters, String selectFields) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(filters);
        qFilters.add(new QFilter("orderstatus", "in", (Object)new String[]{"5", "7", "8", "10"}));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"er_hotelbill", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    public static DataSet getErTrainBillDataSet(List<QFilter> filters, String selectFields) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(filters);
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"er_trainbill", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    public static DataSet getErVehicBillDataSet(List<QFilter> filters, String selectFields) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(filters);
        qFilters.add(new QFilter("orderstatus", "in", (Object)new String[]{"Successful", "Refunded", "PartialRefund"}));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"er_vehiclebill", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }
}

