/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.service.trader;

import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.mobile.common.chart.M;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.dto.ParameterCardDTO;
import kd.fi.er.mobile.dto.TripTailRankCardDTO;
import kd.fi.er.mobile.util.DateSpanUtils;

public class TripTailRankCardHelper {
    public static List<TripTailRankCardDTO> getTripTailRankCardDTOs(ParameterCardDTO parameterDTO) {
        Map<String, DoubleSummaryStatistics> collect;
        try (DataSet tripTailBills = TripTailRankCardHelper.getTripTailBills(parameterDTO);){
            collect = StreamSupport.stream(Spliterators.spliteratorUnknownSize(tripTailBills.groupBy(new String[]{"from", "to"}).sum("number").finish(), 16), false).collect(Collectors.groupingBy(row -> row.getString("from") + " - " + row.getString("to"), Collectors.summarizingDouble(row -> row.getInteger("number").intValue())));
        }
        List<TripTailRankCardDTO> dtoList = collect.entrySet().stream().map(entry -> {
            TripTailRankCardDTO dto = new TripTailRankCardDTO();
            dto.setTail((String)entry.getKey());
            dto.setNumber((int)((DoubleSummaryStatistics)entry.getValue()).getSum());
            return dto;
        }).sorted().collect(Collectors.toList());
        if (dtoList.size() == 0) {
            return dtoList;
        }
        TripTailRankCardHelper.fillRankValue(dtoList);
        return dtoList;
    }

    private static void fillRankValue(List<TripTailRankCardDTO> dtoList) {
        int index;
        int lastDTORank = index = 1;
        int lastDTONumber = dtoList.get(0).getNumber();
        for (TripTailRankCardDTO dto : dtoList) {
            if (dto.getNumber() == lastDTONumber) {
                dto.setRank(lastDTORank);
            } else {
                dto.setRank(index);
            }
            lastDTORank = dto.getRank();
            lastDTONumber = dto.getNumber();
            ++index;
        }
    }

    public static DataSet getTripTailBills(ParameterCardDTO parameterDTO) {
        QFilter orgFilter = new QFilter("tripentry.entrycostcompany", "in", parameterDTO.getOrgIds());
        QFilter statusFilter = new QFilter("billstatus", "in", M.arraylist("E", "F", "G", "I"));
        DateRange dateRange = parameterDTO.getDateRange();
        QFilter timeFilter = DateSpanUtils.timeSection("bizdate", dateRange.getStartDate(), dateRange.getEndDate());
        return QueryServiceHelper.queryDataSet((String)"TripTailRankCardHelper", (String)"er_tripreqbill", (String)"1 as number,tripentry.from.name as from,tripentry.to.name as to", (QFilter[])new QFilter[]{orgFilter, statusFilter, timeFilter}, null);
    }
}

