/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;

public class CommonUtils {
    public static final Log logger = LogFactory.getLog((String)"em_utils");

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static LocalDate date2LocalDate(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Map<String, Object> createDateRange(Date startDate, Date endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", startDate);
        map.put("endDate", CommonUtils.nextDate(endDate));
        return map;
    }

    public static Date nextDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static long toLong(String str) {
        return CommonUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static BigDecimal divide(Integer dividend, Integer divisor, int scale) {
        if (divisor == null || divisor == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(dividend).divide(new BigDecimal(divisor), scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal percent(BigDecimal dividend, BigDecimal divisor) {
        if (divisor == null || divisor.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return dividend.divide(divisor, 4, RoundingMode.HALF_UP);
    }

    public static BigDecimal dividePercent(Long dividend, Long divisor, int scale) {
        if (divisor == null || divisor == 0L) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(dividend).multiply(new BigDecimal("100")).divide(new BigDecimal(divisor), scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal dividePercent(BigDecimal dividend, BigDecimal divisor, int scale) {
        if (divisor == null || divisor.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return dividend.multiply(new BigDecimal("100")).divide(divisor, scale, RoundingMode.HALF_UP);
    }

    public static String formatDividePercent(BigDecimal dividend, BigDecimal divisor, int scale) {
        return CommonUtils.dividePercent(dividend, divisor, scale) + "%";
    }

    public static BigDecimal compareRatio(BigDecimal thisData, BigDecimal previousData) {
        BigDecimal yoyRatio = null;
        if (previousData != null && thisData != null) {
            if (BigDecimal.ZERO.compareTo(previousData) != 0) {
                yoyRatio = BigDecimal.ZERO.compareTo(thisData) != 0 ? thisData.subtract(previousData).divide(previousData, 5, 4) : new BigDecimal("-1");
            } else if (BigDecimal.ZERO.compareTo(thisData) == 0) {
                yoyRatio = new BigDecimal("0");
            }
        }
        return yoyRatio;
    }

    public static void dumpDataSet(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        int cols = rowMeta.getFieldCount();
        StringBuilder sb = new StringBuilder();
        for (Row row : ds) {
            for (int i = 0; i < cols; ++i) {
                sb.append(rowMeta.getField(i).getAlias()).append(": ");
                sb.append(row.get(i)).append("  ");
            }
            sb.append("\n\r");
        }
        logger.info("dumpDataSet: " + sb);
    }

    public static String joinLines(String text) {
        int col = 3;
        int length = text.length();
        boolean toolong = false;
        if (length > 9) {
            text = text.substring(0, 8);
            toolong = true;
            length = text.length();
        }
        if (length > col) {
            int lines = (int)Math.ceil((double)text.length() * 1.0 / (double)col);
            StringJoiner stringJoiner = new StringJoiner("##");
            for (int i = 0; i < lines; ++i) {
                stringJoiner.add(text.substring(3 * i, Math.min(3 * (i + 1), length)));
            }
            if (toolong) {
                return stringJoiner + "...";
            }
            return stringJoiner.toString();
        }
        return text;
    }

    public static String createNoExchangeRateTips(List<String> absentCurrencies) {
        AmountHandler handler = AmountHelper.get();
        String collect = absentCurrencies.stream().limit(2L).collect(Collectors.joining(","));
        if (absentCurrencies.size() > 2) {
            collect = collect + '\u7b49';
        }
        String tips = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u544a\u5e01\u4e3a\u201c%1$s\u201d\uff0c\u5f53\u524d\u6c47\u7387\u8868\u201c%2$s\u201d\u7f3a\u5c11\u201c%3$s\u201d\u5230\u62a5\u544a\u5e01\u7684\u6c47\u7387", (String)"CommonUtils_0", (String)"fi-er-mb-business", (Object[])new Object[0]), handler.getCurrency().getString("name"), handler.getExratetable().getString("name"), collect);
        return tips;
    }
}

