/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateUtil {
    private static Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new ConcurrentHashMap<String, ThreadLocal<SimpleDateFormat>>();

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getCurMonthStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        return calendar.getTime();
    }

    private static SimpleDateFormat getSdf(String pattern) {
        ThreadLocal<SimpleDateFormat> tl = sdfMap.get(pattern);
        if (tl == null) {
            tl = ThreadLocal.withInitial(() -> new SimpleDateFormat(pattern));
            sdfMap.put(pattern, tl);
        }
        return tl.get();
    }

    public static String format(Object date, String pattern) {
        return DateUtil.getSdf(pattern).format(date);
    }

    public static Date parse(String dateStr, String pattern) throws ParseException {
        return DateUtil.getSdf(pattern).parse(dateStr);
    }

    public static Date getFirstDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static int getYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int year = cal.get(1);
        int era = cal.get(0);
        if (era == 0) {
            return -1 * year;
        }
        return year;
    }

    public static int getMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(2) + 1;
    }

    public static int getDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public static String getNumberDateStr(String dateStr) {
        String[] date = dateStr.split("/");
        String month = date[1];
        String day = "";
        if (date.length > 2) {
            day = date[2];
        }
        if (Integer.parseInt(month) < 10) {
            month = "0" + month;
        }
        if (!"".equals(day) && Integer.parseInt(day) < 10) {
            day = "0" + day;
        }
        return date[0] + month + day;
    }

    public static Date addDay(Date dDate, long iNbDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        cal.add(5, (int)iNbDay);
        return cal.getTime();
    }

    public static Date addMonth(Date dDate, int iNbMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        int month = cal.get(2);
        int year = (month += iNbMonth) / 12;
        cal.set(2, month %= 12);
        if (year != 0) {
            int oldYear = cal.get(1);
            cal.set(1, year + oldYear);
        }
        return cal.getTime();
    }

    public static Date getCurDateForm(Date date, boolean isStart) throws ParseException {
        SimpleDateFormat shortformat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat longformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = shortformat.format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        return longformat.parse(dateStr + suffix);
    }

    public static String taskefficiencyFormMart(BigDecimal taskefficiency) {
        StringBuilder sb = new StringBuilder();
        BigDecimal coefficient = new BigDecimal(60);
        int hour = taskefficiency.intValue();
        sb.append(hour > 9 ? Integer.valueOf(hour) : "0" + hour).append(" : ");
        BigDecimal taskMinute = taskefficiency.subtract(new BigDecimal(hour)).multiply(coefficient);
        int minute = taskMinute.intValue();
        sb.append(minute > 9 ? Integer.valueOf(minute) : "0" + minute).append(" : ");
        BigDecimal taskSecond = taskMinute.subtract(new BigDecimal(minute)).multiply(coefficient);
        int second = taskSecond.intValue();
        sb.append(second > 9 ? Integer.valueOf(second) : "0" + second);
        return sb.toString();
    }

    public static ThreadLocal<SimpleDateFormat> removeSdf(String pattern) {
        return sdfMap.remove(pattern);
    }

    public static int convertIntFormate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
    }
}

