/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.mobile.util.CastUtils;

public class InvokeUtil {
    private static final Log log = LogFactory.getLog(InvokeUtil.class);

    public static <T> T getInstance(String className) {
        if (className == null) {
            return null;
        }
        try {
            Object object = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return CastUtils.cast(object);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getLocalizedMessage());
            return null;
        }
    }

    public static <T> Class<T> getParameterizedType(Class<?> clazz, int i) {
        ParameterizedType parameterizedType;
        Type[] typeArray;
        Type superclass = clazz.getGenericSuperclass();
        if (superclass instanceof ParameterizedType && (typeArray = (parameterizedType = (ParameterizedType)superclass).getActualTypeArguments()) != null && typeArray.length > 0) {
            return (Class)CastUtils.cast(typeArray[0]);
        }
        throw new KDBizException(clazz.getName() + "not have ParameterizedType " + i);
    }
}

