/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class JsonUtils {
    private static final Log log = LogFactory.getLog(JsonUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String DEFAULT_DATE_TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULT_DATE_FORMATTER = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMATTER = "HH:mm:ss";

    private JsonUtils() {
    }

    private static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static <T> String toJson(T obj) {
        try {
            return JsonUtils.getObjectMapper().writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("to json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(String text, Class<T> type) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(text, type);
        }
        catch (IOException e) {
            log.error("from json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static JsonNode fromJson(String text) {
        try {
            return JsonUtils.getObjectMapper().readTree(text);
        }
        catch (IOException e) {
            log.error("from json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T fromJson(String text, JavaType javaType) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(text, javaType);
        }
        catch (IOException e) {
            log.error("from json failure", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> List<T> fromJsonToList(String text, Class<T> type) {
        return (List)JsonUtils.fromJson(text, OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{type}));
    }

    public static Map<String, String> fromJsonToMap(String text) {
        return (Map)JsonUtils.fromJson(text, OBJECT_MAPPER.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, String.class}));
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMATTER)));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMATTER)));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMATTER)));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMATTER)));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern(DEFAULT_DATE_FORMATTER)));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern(DEFAULT_TIME_FORMATTER)));
        OBJECT_MAPPER.registerModule((Module)javaTimeModule);
    }
}

