/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.vo;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.fi.er.mobile.common.AmountHandler;
import kd.fi.er.mobile.common.AmountHelper;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.vo.CompareRateVO;
import kd.fi.er.mobile.vo.IViewObject;

public class TraderOverallVO
implements IViewObject {
    CompareRateVO planeBillItemVO;
    CompareRateVO hotelBillItemVO;
    CompareRateVO trainBillItemVO;
    CompareRateVO vehicBillItemVO;

    public CompareRateVO getPlaneBillItemVO() {
        return this.planeBillItemVO;
    }

    public void setPlaneBillItemVO(CompareRateVO planeBillItemVO) {
        this.planeBillItemVO = planeBillItemVO;
    }

    public CompareRateVO getHotelBillItemVO() {
        return this.hotelBillItemVO;
    }

    public void setHotelBillItemVO(CompareRateVO hotelBillItemVO) {
        this.hotelBillItemVO = hotelBillItemVO;
    }

    public CompareRateVO getTrainBillItemVO() {
        return this.trainBillItemVO;
    }

    public void setTrainBillItemVO(CompareRateVO trainBillItemVO) {
        this.trainBillItemVO = trainBillItemVO;
    }

    public CompareRateVO getVehicBillItemVO() {
        return this.vehicBillItemVO;
    }

    public void setVehicBillItemVO(CompareRateVO vehicBillItemVO) {
        this.vehicBillItemVO = vehicBillItemVO;
    }

    public CompareRateVO getTotalBillVO() {
        List<CompareRateVO> list = Arrays.asList(this.planeBillItemVO, this.hotelBillItemVO, this.trainBillItemVO, this.vehicBillItemVO);
        BigDecimal currSum = BigDecimal.ZERO;
        BigDecimal previousSum = BigDecimal.ZERO;
        BigDecimal linkSum = BigDecimal.ZERO;
        for (CompareRateVO vo : list) {
            currSum = currSum.add(vo.getCurrSignAmountValue());
            previousSum = previousSum.add(vo.getPreviousSignAmountValue());
            linkSum = linkSum.add(vo.getLinkSignAmountValue());
        }
        this.planeBillItemVO.setPercent(CommonUtils.percent(this.planeBillItemVO.getCurrSignAmountValue(), currSum));
        this.hotelBillItemVO.setPercent(CommonUtils.percent(this.hotelBillItemVO.getCurrSignAmountValue(), currSum));
        this.trainBillItemVO.setPercent(CommonUtils.percent(this.trainBillItemVO.getCurrSignAmountValue(), currSum));
        this.vehicBillItemVO.setPercent(CommonUtils.percent(this.vehicBillItemVO.getCurrSignAmountValue(), currSum));
        AmountHandler handler = AmountHelper.get();
        CompareRateVO totalVO = new CompareRateVO(handler.getSignAmount(currSum));
        if (this.planeBillItemVO.getPreviousSignAmount() != null) {
            totalVO.setPreviousSignAmount(handler.getSignAmount(previousSum));
        }
        if (this.planeBillItemVO.getLinkSignAmount() != null) {
            totalVO.setLinkSignAmount(handler.getSignAmount(linkSum));
        }
        totalVO.setPercent(BigDecimal.ONE);
        return totalVO;
    }
}

