/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mobile.datarange;

import java.time.LocalDate;
import java.util.Date;
import java.util.EventObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.mobile.datarange.DateRange;
import kd.fi.er.mobile.datarange.DateRangeEnum;
import kd.fi.er.mobile.datarange.IDateRange;
import kd.fi.er.mobile.util.CommonUtils;
import kd.fi.er.mobile.util.JsonUtils;

public class SelectDateRangeMobFormPlugin
extends AbstractMobFormPlugin {
    private static final Log log = LogFactory.getLog(SelectDateRangeMobFormPlugin.class);
    public static final String FORMID = "em_m_daterange_select";
    private static final String CTRL_BTN_CONFIRM = "confirm_button";
    private static final String CTRL_BTN_CLOSE = "datetime_close";
    private static final String CTRL_DATERANGE_EDIT = "custom";
    private static final String RG_FAST_SELECT = "datespan_radio";
    private static final String FIELD_DATERANGE_STARTDATE = "daterangefield_startdate";
    private static final String FIELD_DATERANGE_ENDDATE = "daterangefield_enddate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_CONFIRM, CTRL_BTN_CLOSE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initializeData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (RG_FAST_SELECT.equals(propName)) {
            String dateSpan = (String)this.getModel().getValue(RG_FAST_SELECT);
            if (dateSpan != null) {
                this.setDateRange(DateRangeEnum.getEnumByNumber((String)dateSpan).toDateRange());
                this.getView().updateView(CTRL_DATERANGE_EDIT);
            }
        } else if (FIELD_DATERANGE_STARTDATE.equals(propName) || FIELD_DATERANGE_ENDDATE.equals(propName)) {
            this.getModel().setValue(RG_FAST_SELECT, null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CTRL_BTN_CONFIRM.equals(key)) {
            String spanType = (String)this.getModel().getValue(RG_FAST_SELECT);
            DateRange dateRange = this.packageReturnData(spanType);
            DateRange dateRangeByParameter = this.getDateRangeByParameter();
            log.info(dateRange.toString());
            if (!dateRangeByParameter.equals((Object)dateRange)) {
                DateRange fillDateRange = DateRangeEnum.fillDateRange((IDateRange)dateRange);
                this.getView().returnDataToParent((Object)JsonUtils.toJson((Object)fillDateRange));
            }
            this.getView().close();
        } else if (CTRL_BTN_CLOSE.equals(key)) {
            this.getView().close();
        }
    }

    private void initializeData() {
        this.setDateRange(this.getDateRangeByParameter());
    }

    private void setDateRange(DateRange range) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue(RG_FAST_SELECT, (Object)range.getSpanType());
        model.setValue(FIELD_DATERANGE_STARTDATE, (Object)CommonUtils.localDate2Date((LocalDate)range.getStartDate()));
        model.setValue(FIELD_DATERANGE_ENDDATE, (Object)CommonUtils.localDate2Date((LocalDate)range.getEndDate()));
        model.endInit();
    }

    private DateRange packageReturnData(String spanType) {
        DateRange dateRange = new DateRange();
        dateRange.setSpanType(spanType);
        dateRange.setStartDate(CommonUtils.date2LocalDate((Date)((Date)this.getModel().getValue(FIELD_DATERANGE_STARTDATE))));
        dateRange.setEndDate(CommonUtils.date2LocalDate((Date)((Date)this.getModel().getValue(FIELD_DATERANGE_ENDDATE))));
        return dateRange;
    }

    protected DateRange getDateRangeByParameter() {
        String dateRange = (String)this.getView().getFormShowParameter().getCustomParam("dateRange");
        return (DateRange)JsonUtils.fromJson((String)dateRange, DateRange.class);
    }
}

